<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Publicaciones</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    <link href="{{ asset('/css/preloader.css') }}" rel="stylesheet">
    <style>
        .food-media {
            position: relative;
            width: 350px;
            height: 300px;
            overflow: hidden;
            border-radius: 10px;
        }

        .food-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 8px;
        }
        </style>
</head>

<body>
    <div id="progressSection" style="display: none;"> <!-- Contenedor de la barra de progreso, inicialmente oculto -->
        <div id="porcentaje">0</div>
        <div class="barra_progreso">
            <div class="progreso" id="progreso"></div>
        </div>
    </div>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            {{ __('Administrar Publicaciones') }}
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body mh-auto">
            <div class="container-fluid p-0 mh-auto">
                <div class="row">

                    <div class="col-xl-8" style="height: 100vh">
                        <div class="card mb-sm-3 mb-md-0 contacts_card dlab-chat-user-box" >
                            <div class="card-header chat-list-header text-center">

                                <div>
                                    <h6 class="mb-1">Lista de Publicaciones</h6>
                                </div>
                                <a href="javascript:void(0);" id="btn_add_publicacion">
                                    <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960" width="24px" fill="#5f6368"><path d="M440-280h80v-160h160v-80H520v-160h-80v160H280v80h160v160Zm40 200q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"/></svg>
                                </a>
                            </div>
                            <div class="card-body contacts_body p-1 dlab-scroll" id="DLAB_W_Contacts_Body">


                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="card">
                            <div class="card-header border-0 pb-0 flex-wrap">
                                <h6 class="mb-0">Menu publicaciones</h6>
                                <ul class="nav nav-tabs food-tabs" id="myTab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="home-tab" data-bs-toggle="tab"
                                            data-bs-target="#home-tab-pane" type="button" role="tab"
                                            aria-controls="home-tab-pane" aria-selected="true">Recientes</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="profile-tab" data-bs-toggle="tab"
                                            data-bs-target="#profile-tab-pane" type="button" role="tab"
                                            aria-controls="profile-tab-pane" aria-selected="false">pasados</button>
                                    </li>
                                </ul>
                            </div>
                            <div class="card-body">
                                <div id="DZ_W_TimeLine02" class="widget-timeline dlab-scroll style-1 p-3 height450">
                                    <div class="tab-content" id="myTabContent">
                                        <div class="tab-pane fade show active" id="home-tab-pane" role="tabpanel" aria-labelledby="home-tab" tabindex="0">
                                            <ul class="timeline" id="list_recientes">

                                            </ul>
                                        </div>
                                        <div class="tab-pane fade" id="profile-tab-pane" role="tabpanel" aria-labelledby="profile-tab" tabindex="0">
                                            <ul class="timeline" id="list_pasados">

                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <form class="needs-validation" id="formModal">
            @csrf
            <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel">
                <div class="modal-dialog modal-dialog-center modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Crear una publicación
                            </h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body px-1 py-1">
                            <div class="row">
                                <div class="row col-xl-12 m-0">
                                    <!-- data -->
                                    <input type="hidden" id="txt-idpublicacion" name="txt-idpublicacion">
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                        <label for="txt-plans" class="form-label text-primary">Plan</label>
                                        <select id="txt-plans" name="txt-plans" class="default-select  form-control form-control-sm" required>
                                            {{-- combobox --}}
                                        </select>
                                    </div>
                                    <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                        <label for="txt-titulo" class="form-label text-primary">Título</label>
                                        <input id="txt-titulo" name="txt-titulo" type="text"
                                            class="form-control form-control-sm" required>
                                    </div>
                                    <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                        <label for="txt-contenido" class="form-label text-primary">Contenido</label>
                                        <!-- Aquí va el textarea para CKEditor -->
                                        <div class="card-body custom-ekeditor p-0">
                                            <textarea class="form-control" rows="7" id="contenido"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                        <label for="txt-imagen" class="form-label text-primary">Imagen</label>
                                        <input id="txt-imagen" name="txt-imagen" type="file" accept="image/*"
                                            class="form-control form-control-sm" required>
                                    </div>
                                    <!-- data -->
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                                data-bs-dismiss="modal">Cerrar</button>
                            <button id="btnCreateUpdate" type="button" value="Create"
                                class="btn btn-primary btn-sm ">Guardar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

        <!--**********************************
            Content body end
        ***********************************-->

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')
    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = "{{ route('logout') }}";
    </script>

    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/bienestar/publicaciones_Ajax.js']);
    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
    <script src="https://cdn.ckeditor.com/ckeditor5/36.0.1/classic/ckeditor.js"></script>


</body>

</html>
