<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Publicaciones</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    <link href="{{ asset('/css/preloader.css') }}" rel="stylesheet">

</head>

<body>
    <div id="progressSection" style="display: none;"> <!-- Contenedor de la barra de progreso, inicialmente oculto -->
        <div id="porcentaje">0</div>
        <div class="barra_progreso">
            <div class="progreso" id="progreso"></div>
        </div>
    </div>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            {{ __('Gestionar Preguntas de la Encuestas') }}
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid">
                <div class="row">
                    <!--column-->
                    <div class="col-xl-3 col-xxl-3 col-lg-3 col-md-12">
                        @if (count($data) > 0)
                        <!-- Verifica si hay datos -->
                        @foreach ($data as $encuesta)
                            <input type="hidden" name="id_encuesta" value="{{ $encuesta->id }}">
                            <div class="card">
                                <div class="card-header border-0 pb-0">
                                    <h6 class="card-title">TITULO: {{ $encuesta->titulo }}</h6>
                                </div>
                                <div class="card-body pb-0">
                                    <p> <strong>Descripción:</strong> {{ $encuesta->descripcion }}</p>
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Estado:</strong>
                                            <span class="mb-0">
                                                @if ($encuesta->estado == 'activa')
                                                    <span class="badge badge-success light">Activa</span>
                                                @else
                                                    <span class="badge badge-danger light">Inactiva</span>
                                                @endif
                                            </span>
                                        </li>
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Fecha inicio</strong>
                                            <span class="mb-0">{{ $encuesta->fecha_inicio }}</span>
                                        </li>
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Fecha Fin</strong>
                                            <span class="mb-0">{{ $encuesta->fecha_fin }}</span>
                                        </li>
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Plan</strong>
                                            <span class="mb-0"> {{ $encuesta->nombre }}</span>
                                        </li>
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Tipo</strong>
                                            <span class="mb-0">{{ $encuesta->tipo }}</span>
                                        </li>
                                        <li class="list-group-item d-flex px-0 justify-content-between">
                                            <strong>Dirigido a:</strong>
                                            <span class="mb-0">{{ $encuesta->dirigido_a }}</span>
                                        </li>

                                    </ul>
                                </div>
                                <div class="card-footer pt-0 pb-0 text-center">
                                    <div class="row">
                                        <div class="col-4 pt-3 pb-3 border-end">
                                            <h3 class="mb-1 text-primary" id="total_texto">-</h3>
                                            <span>Texto</span>
                                        </div>
                                        <div class="col-4 pt-3 pb-3 border-end">
                                            <h3 class="mb-1 text-primary" id="total_respuestaunica">-</h3>
                                            <span>Sencillas</span>
                                        </div>
                                        <div class="col-4 pt-3 pb-3">
                                            <h3 class="mb-1 text-primary" id="total_multiple">-</h3>
                                            <span>Multiples</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        @else
                            <p>No hay encuestas disponibles.</p>
                        @endif
                    </div>
                    <!--/column-->
                    <!--column-->
                    <div class="col-xl-9 col-xxl-9 col-lg-9 col-lg-12">
                        <div class="card">
                            <div class="card-header border-0 pb-0">
                                <div class="file-header border-0 w-100">
                                    <div class="page-titles">
                                        <div class="my-2">
                                            <h2 class="heading">Hisotiral de Encuestas</h2>
                                            <div class="file-path">
                                                <div class="me-2">
                                                    <svg width="20" height="16" viewBox="0 0 20 16"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M18.9833 6.64169C18.9049 6.545 18.8058 6.46712 18.6933 6.41376C18.5808 6.36041 18.4578 6.33293 18.3333 6.33335H16.6666V5.50002C16.6666 4.83698 16.4033 4.20109 15.9344 3.73225C15.4656 3.26341 14.8297 3.00002 14.1666 3.00002H8.93331L8.66665 2.16669C8.49377 1.67771 8.1731 1.2546 7.74906 0.955986C7.32502 0.657367 6.81861 0.498019 6.29998 0.500019H3.33331C2.67027 0.500019 2.03439 0.763411 1.56555 1.23225C1.09671 1.70109 0.833313 2.33698 0.833313 3.00002V13C0.833313 13.6631 1.09671 14.2989 1.56555 14.7678C2.03439 15.2366 2.67027 15.5 3.33331 15.5H15.3333C15.901 15.4984 16.4512 15.3036 16.8935 14.9476C17.3357 14.5917 17.6437 14.0959 17.7666 13.5417L19.1666 7.35002C19.192 7.22578 19.1886 7.0974 19.1569 6.97466C19.1251 6.85191 19.0657 6.73803 18.9833 6.64169ZM4.47498 13.1834C4.43264 13.3713 4.32647 13.5388 4.17453 13.6574C4.02259 13.7759 3.83428 13.8381 3.64165 13.8334H3.33331C3.1123 13.8334 2.90034 13.7456 2.74406 13.5893C2.58778 13.433 2.49998 13.221 2.49998 13V3.00002C2.49998 2.779 2.58778 2.56704 2.74406 2.41076C2.90034 2.25448 3.1123 2.16669 3.33331 2.16669H6.29998C6.4817 2.1572 6.66153 2.20746 6.81201 2.30978C6.96248 2.4121 7.07533 2.56087 7.13331 2.73335L7.58331 4.10002C7.63679 4.25897 7.73698 4.39809 7.87079 4.49919C8.0046 4.60029 8.1658 4.65867 8.33331 4.66669H14.1666C14.3877 4.66669 14.5996 4.75448 14.7559 4.91076C14.9122 5.06704 15 5.27901 15 5.50002V6.33335H6.66665C6.47401 6.32864 6.2857 6.39084 6.13376 6.50935C5.98182 6.62786 5.87565 6.79537 5.83331 6.98335L4.47498 13.1834ZM16.1416 13.1834C16.0993 13.3713 15.9931 13.5388 15.8412 13.6574C15.6893 13.7759 15.5009 13.8381 15.3083 13.8334H6.00831C6.05135 13.7405 6.08216 13.6425 6.09998 13.5417L7.33331 8.00002H17.3333L16.1416 13.1834Z"
                                                            fill="#01A3FF" />
                                                    </svg>
                                                </div>
                                                <h4><a id="link1" class="link active" data-opcion="1" href="{{ route('admin.institucion.bienestar.encuestas') }}">Ver lista de encuestas</a></h4>
                                            </div>
                                        </div>
                                        <div class="d-flex my-2">
                                            <div class="p-0">

                                                <button type="button" value="Create" id="btn_createQuestions"
                                                    class="btn btn-primary btn-sm btn-block">+ Agregar
                                                    Pregunta</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body p-0">
                                <ul id="DZ_W_TimeLine" class="widget-media dlab-scroll height600 my-4 px-4">

                                </ul>
                            </div>
                        </div>
                    </div>
                    <!--/column-->
                </div>
            </div>
        </div>

        <!--**********************************
            Content body end
        ***********************************-->
        <form class="needs-validation" id="formModal">
            @csrf
            <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel">
                <div class="modal-dialog modal-dialog-center modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Crear pregunta
                            </h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="row px-1 alert alert-dark alert-dismissible alert-alt fade show">
                                <div class="col-xl-5 ">
                                    @if (count($data) > 0)
                                        <!-- Verifica si hay datos -->
                                        @foreach ($data as $encuesta)
                                            <input type="hidden" name="id_encuesta_form" id="id_encuesta_form" value="{{ $encuesta->id }}">
                                        @endforeach
                                    @else
                                        <p>No hay encuestas disponibles.</p>
                                    @endif
                                    <input type="hidden" id="txt-idpregunta" name="txt-idpregunta">
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                        <label for="txt-pregunta" class="form-label text-primary"><strong>Pregunta</strong> </label>
                                        <!-- Aquí va el textarea para CKEditor -->
                                        <div class="card-body custom-ekeditor p-0">
                                            <textarea class="form-control" rows="2" id="text_pregunta" name="text_pregunta"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                        <label for="txt-tiprespuesta" class="form-label text-primary"><strong>Tipo de Respuesta</strong> </label>
                                        <select id="txt-tiprespuesta" name="txt-tiprespuesta" class="default-select  form-control form-control-sm" required>
                                                <option selected disables value="0">Seleccione opcion </option>
                                                <option value="texto">Texto</option>
                                                <option value="opcion_unica">Opcion única</option>
                                                <option value="multiple">Múltiple</option>
                                            </select>
                                    </div>
                                </div>
                                <div class="col-xl-7" id="sectionTipoPregunta">


                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                                data-bs-dismiss="modal">Cerrar</button>
                            <button id="btnCreateUpdate" type="button" value="Create"
                                class="btn btn-primary btn-sm ">Guardar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        ***********************************-->
        <form class="needs-validation" id="formModalEditTitulo">
            @csrf
            <div id="modalCreateUpdateQuestionOption" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabelEdith">
                <div class="modal-dialog modal-dialog-center modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalCreateUpdateLabelEdith">Actualizar Dato
                            </h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="row px-1 alert alert-dark alert-dismissible alert-alt fade show">
                                <div class="col-xl-12">
                                    <input type="hidden" id="txt-PreguntaoOpcion" name="txt-PreguntaoOpcion">

                                    <input type="hidden" id="txt-idpopcionpregunta" name="txt-idpopcionpregunta">
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                        <label for="txt-pregunta" class="form-label text-primary"><strong id="labelpreguntayopcion">Pregunta</strong> </label>
                                        <!-- Aquí va el textarea para CKEditor -->
                                        <input type="text" name="text_opcionyopcion" id="text_opcionyopcion" class="form-control form-control-sm" required>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                                data-bs-dismiss="modal">Cerrar</button>
                            <button id="btnUpdate" type="button" value="Update"
                                class="btn btn-primary btn-sm ">Actualizar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')
    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>

    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/bienestar/preguntas_encuestas_Ajax.js']);
    {{-- rowgroup --}}
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
    <script></script>


</body>

</html>











