<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <!-- Meta -->
    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <title>Inscripción en Línea</title>
    @include('include.datatable-styles')

    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@48,400,0,0"
        rel="stylesheet">
    <link href="{{ asset('/css/style_inscripcion.css') }}" rel="stylesheet">
</head>

<body class="body h-100">
    <div class="authincation d-flex flex-column flex-lg-row flex-column-fluid">
        <div class="login-aside text-center  d-flex flex-column flex-row-auto">
            <div class="d-flex flex-column-auto flex-column pt-lg-40 pt-15 align-items-center">
                <div class="text-center mb-lg-4 mb-2 pt-5 logo">
                    <img src="{{ route('institucion.cargarLogo') }}" alt="" width="80%">
                </div>
                <h3 class="mb-2 text-white">IESTP {{ $institutions['nombre'] }}</h3>
                <p class="mb-4"><br>Sistema de Gestión Académica</p>
            </div>
            <div class="aside-image position-relative"
                style="background-image:url({{ asset('/images/background/pic-2.png') }});">

            </div>
        </div>
        <div class="container-fluid d-flex flex-column justify-content-start">
            <div class="row">
                <div class="col-xl-12">
                    <div class="row py-3">
                        <div class="form-validation">
                            <form class="needs-validation" id="formModal" name="form" novalidate>
                                <input id="hidden_documento" name="hidden_documento" value="" type="hidden">
                                <input id="hidden_concepto" name="hidden_concepto" value="" type="hidden">
                                @csrf
                                <!-- Column starts -->
                                <div class="col-xl-12">
                                    <div class="card" id="accordion-three">
                                        <div class="card-header flex-wrap px-3 text-center">
                                            <div class="text-center">
                                                <h4 class="card-title"><i class="fas fa-cog fa-spin"></i>Inscripción en Línea de Postulantes</h4>
                                            </div>
                                        </div>
                                        <!-- /tab-content -->
                                        <div class="tab-content" id="myTabContent-2">
                                            <div class="tab-pane fade show active" id="withoutSpace" Aulae="tabpanel" aria-labelledby="home-tab-2">
                                                <div class="card-body p-4">
                                                    <div class="row">
                                                        <!-- data -->
                                                        <fieldset style="border: 1px groove #ddd !important; padding: 0 1.4em 1.4em 1.4em !important; margin: 0 0 1.5em 0 !important; -webkit-box-shadow: 0px 0px 0px 0px #000; box-shadow: 0px 0px 0px 0px #000;">
                                                            <legend class="text-primary mt-2" style="font-size: 1.2em !important; font-weight: bold !important; text-align: left !important;">
                                                                Información a tomar en cuenta
                                                            </legend>
                                                            <p>Los documentos que se suban deben estar en formato PDF pesar menos de 500 KB.</p>
                                                            <p>Asegúrese que los datos ingresados sean correctos.</p>
                                                            <p>Los datos que se registren deben ser reales, de lo contrario, no se tomarán en cuenta.</p>
                                                        </fieldset>
                                                        <!-- data -->
                                                        <fieldset
                                                            style="border: 1px groove #ddd !important; padding: 0 1.4em 1.4em 1.4em !important;
                                                            margin: 0 0 1.5em 0 !important; -webkit-box-shadow: 0px 0px 0px 0px #000; box-shadow: 0px 0px 0px 0px #000;
                                                        ">
                                                            <legend class="text-primary mt-2"
                                                                style="font-size: 1.2em !important; font-weight: bold !important;
                                                                    text-align: left !important;">
                                                                DATOS DEL POSTULANTE
                                                            </legend>

                                                            <!-- body -->
                                                            <div class="modal-body">
                                                                <div class="row">
                                                                    <div class="row col-xl-12">
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-idadmissionplan"
                                                                                class="form-label text-primary">Programa</label>
                                                                            <select id="txt-idadmissionplan"
                                                                                name="txt-idadmissionplan"
                                                                                class="default-select  form-control form-control-sm"
                                                                                required>
                                                                                <!-- combobox -->
                                                                            </select>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label
                                                                                for="txt-identificationtype_aplicants"
                                                                                class="form-label text-primary">Tipo de
                                                                                ID</label>
                                                                            <select
                                                                                id="txt-identificationtype_aplicants"
                                                                                name="txt-identificationtype_aplicants"
                                                                                class="default-select  form-control form-control-sm"
                                                                                required>
                                                                                <!-- combobox -->
                                                                            </select>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-nroidenti"
                                                                                class="form-label text-primary">#
                                                                                Identificación</label>
                                                                            <div class="input-group">
                                                                                <input id="txt-nroidenti"
                                                                                    name="txt-nroidenti" type="number"
                                                                                    class="form-control form-control-sm"
                                                                                    placeholder="12345678"
                                                                                    autocomplete="off"
                                                                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                                                                    required>
                                                                                @include('include.div.invalid-feedback')
                                                                                {{-- mensaje de error campo vacio --}}
                                                                            </div>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-docdni"
                                                                                class="form-label text-primary">Doc. de
                                                                                Identidad</label>
                                                                            <div class="input-group">
                                                                                <input id="txt-docdni" name="txt-docdni"
                                                                                    type="file"
                                                                                    class="form-control form-control-sm"
                                                                                    required>
                                                                                @include('include.div.invalid-feedback')
                                                                                {{-- mensaje de error campo vacio --}}
                                                                            </div>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-doccertif"
                                                                                class="form-label text-primary">Certificado</label>
                                                                            <div class="input-group">
                                                                                <input id="txt-doccertif"
                                                                                    name="txt-doccertif" type="file"
                                                                                    class="form-control form-control-sm"
                                                                                    required>
                                                                                @include('include.div.invalid-feedback')
                                                                                {{-- mensaje de error campo vacio --}}
                                                                            </div>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-docboucher"
                                                                                class="form-label text-primary">Boucher</label>
                                                                            <div class="input-group">
                                                                                <input id="txt-docboucher"
                                                                                    name="txt-docboucher"
                                                                                    type="file"
                                                                                    class="form-control form-control-sm"
                                                                                    required>
                                                                                @include('include.div.invalid-feedback')
                                                                                {{-- mensaje de error campo vacio --}}
                                                                            </div>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-docdatosper"
                                                                                class="form-label text-primary">Partida
                                                                                de Nacimiento</label>
                                                                            <div class="input-group">
                                                                                <input id="txt-docdatosper"
                                                                                    name="txt-docdatosper"
                                                                                    type="file"
                                                                                    class="form-control form-control-sm"
                                                                                    required>
                                                                                @include('include.div.invalid-feedback')
                                                                                {{-- mensaje de error campo vacio --}}
                                                                            </div>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-modalidad_aplicants"
                                                                                class="form-label text-primary">Modalidad</label>
                                                                            <select id="txt-modalidad_aplicants"
                                                                                name="txt-modalidad_aplicants"
                                                                                class="default-select form-control form-control-sm"
                                                                                required>
                                                                                <!-- combobox -->
                                                                                <option selected value="Ordinario">
                                                                                    Ordinario</option>
                                                                                <option value="Exonerado">Exonerado
                                                                                </option>
                                                                            </select>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-tipomodalidad" class="form-label text-primary">Tipo de Modalidad</label>
                                                                            <select id="txt-tipomodalidad" name="txt-tipomodalidad" class="default-select form-control form-control-sm" required>
                                                                                <!-- combobox -->
                                                                                <option disabled selected value=""> Seleccione opcion</option>
                                                                                <option value="Ordinario"> Ordinario</option>
                                                                                <option value="Artista Calificado">Artista Calificado</option>
                                                                                <option value="Comunidades Nativas">Comunidades Nativas</option>
                                                                                <option value="Convenio Alianza Estratégica">Convenio Alianza Estratégica</option>
                                                                                <option value="Deportista calificado">Deportista calificado</option>
                                                                                <option value="Discapacitados"> Discapacitados</option>
                                                                                <option value="Fuerzas Armadas">Fuerzas Armadas</option>
                                                                                <option value="Mayores 35 años">Mayores 35 años</option>
                                                                                <option value="Convenio Centro Experimental"> Convenio Centro Experimental</option>
                                                                                <option value="Preinstituto"> Preinstituto</option>
                                                                                <option value="Primeros Puestos"> Primeros Puestos</option>
                                                                                <option value="Servicio Militar">Servicio Militar</option>
                                                                                <option value="Titulado">Titulado</option>
                                                                                <option value="Victimas Terrorismo">Victimas Terrorismo</option>
                                                                            </select>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-nombres" class="form-label text-primary">Nombres</label>
                                                                            <input id="txt-nombres" name="txt-nombres" type="text" class="form-control form-control-sm text-capitalize" placeholder="Ingrese nombres" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-apellido_pa" class="form-label text-primary">Apellido paterno</label>
                                                                            <input id="txt-apellido_pa" name="txt-apellido_pa" type="text"
                                                                                class="form-control form-control-sm text-capitalize"
                                                                                placeholder="Ingrese apellido paterno"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-apellido_ma"
                                                                                class="form-label text-primary">Apellido
                                                                                materno</label>
                                                                            <input id="txt-apellido_ma"
                                                                                name="txt-apellido_ma" type="text"
                                                                                class="form-control form-control-sm text-capitalize"
                                                                                placeholder="Ingrese apellido materno"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-lugar_nac"
                                                                                class="form-label text-primary">Lugar
                                                                                Nacimiento</label>
                                                                            <input id="txt-lugar_nac"
                                                                                name="txt-lugar_nac" type="text"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}

                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-fecnac"
                                                                                class="form-label text-primary">Fecha
                                                                                de
                                                                                Nacimiento</label>
                                                                            <input id="txt-fecnac" name="txt-fecnac"
                                                                                type="date"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-correo"
                                                                                class="form-label text-primary">Correo
                                                                                Electrónico</label>
                                                                            <input id="txt-correo" name="txt-correo"
                                                                                type="text"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="example@email.com"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-telefono"
                                                                                class="form-label text-primary">Teléfono</label>
                                                                            <input id="txt-telefono"
                                                                                name="txt-telefono" type="text"
                                                                                autocomplete="off"
                                                                                onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                                                                maxlength="9"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="357-2984" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-celular"
                                                                                class="form-label text-primary">Celular</label>
                                                                            <input id="txt-celular" name="txt-celular"
                                                                                type="text" autocomplete="off"
                                                                                onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                                                                maxlength="9"
                                                                                class="form-control form-control-sm"
                                                                                placeholder="967-542-321" required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-genre_id"
                                                                                class="form-label text-primary">Género</label>
                                                                            <select id="txt-genre_id"
                                                                                name="txt-genre_id"
                                                                                class="default-select form-control form-control-sm"
                                                                                required>
                                                                                <!-- combobox -->
                                                                                @include('include.combobox.genre')
                                                                            </select>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-departamento"
                                                                                class="form-label text-primary">Departamento</label>
                                                                            <select id="txt-departamento"
                                                                                name="txt-departamento"
                                                                                class="form-control form-control-sm"
                                                                                data-live-search="true" required>
                                                                                <!-- combobox -->
                                                                                @include('include.combobox.departamento')
                                                                            </select>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-provincia"
                                                                                class="form-label text-primary">Provincia</label>
                                                                            <select id="txt-provincia"
                                                                                name="txt-provincia"
                                                                                class="form-control form-control-sm"
                                                                                data-live-search="true" required>
                                                                                <!-- combobox dinamico -->
                                                                                <option selected disabled
                                                                                    value="">Seleccione opción
                                                                                </option>
                                                                            </select>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-distrito"
                                                                                class="form-label text-primary">Distrito</label>
                                                                            <select id="txt-distrito"
                                                                                name="txt-distrito"
                                                                                class="form-control form-control-sm"
                                                                                data-live-search="true" required>
                                                                                <!-- combobox dinamico -->
                                                                                <option selected disabled
                                                                                    value="">Seleccione opción
                                                                                </option>
                                                                            </select>
                                                                        </div>
                                                                        <!-- data -->
                                                                        <div
                                                                            class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                                                            <label for="txt-direccion"
                                                                                class="form-label text-primary">Dirección</label>
                                                                            <input id="txt-direccion"
                                                                                name="txt-direccion" type="text"
                                                                                class="form-control form-control-sm"
                                                                                maxlength="200"
                                                                                placeholder="Ejemplo: URB. SANTO DOMINGO ETAPA X MZ. M LT. 2"
                                                                                required>
                                                                            @include('include.div.invalid-feedback')
                                                                            {{-- mensaje de error campo vacio --}}
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </fieldset>
                                                    </div>
                                                </div>
                                                <div class="card-footer text-lg-end text-end">
                                                    <button id="btnCreateUpdate" type="button"
                                                        class="btn btn-primary btn-sm">Guardar</button>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /tab-content -->
                                    </div>
                                </div>
                                <!-- Column ends -->
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!--**********************************
        Scripts
    ***********************************-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <!-- vendors -->
    <script src="{{ asset('/vendor/global/global.min.js') }}"></script>
    <script src="{{ asset('/vendor/jquery-nice-select/js/jquery.nice-select.min.js') }}"></script>
    <script src="{{ asset('/vendor/bootstrap-select/dist/js/bootstrap-select.min.js') }}"></script>
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>
    <script src="{{ asset('/vendor/sweetalert2/dist/sweetalert2.min.js') }}"></script>
    <!-- Toastr -->
    <script src="{{ asset('/vendor/toastr/js/toastr.min.js') }}"></script>
    <!-- All init script -->
    <script src="{{ asset('/js/plugins-init/toastr-init.js') }}"></script>
    @include('include.datatable-scripts')

    <script>
        var route_login = "{{ route('page.error.403') }}";
    </script>

    <!--  Page JS -->
    @vite(['resources/js/admin/admision/inscripcion_linea.js']);
    @vite(['resources/js/common/combobox/ubigeo_online.js']);

</body>

</html>
