<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Docentes</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}
    <style>
        .btn-celeste {
            background-color: #00bcd4;
            /* Celeste */
            color: white;
        }

        .btn-celeste:hover {
            background-color: #0097a7;
            /* Color más oscuro al pasar el ratón */
        }
    </style>


</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Gestionar Docentes
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre Docentes</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nuevo Docente
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Tipo ID</th>
                                                                <th class="text-center"># ID</th>
                                                                <th class="text-center">Apellidos</th>
                                                                <th class="text-center">Nombres</th>
                                                                <th class="text-center">Tipo de Contrato</th>
                                                                <th class="text-center">Horas Lectivas</th>
                                                                <th class="text-center">Horas No Lectivas</th>
                                                                <th class="text-center">Acceso</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form id="formModal" class="needs-validation" novalidate>
        @csrf
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nuevo Docente</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_iduser" name="txt_iduser" type="hidden">
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-identificationtype" class="form-label text-primary">Tipo de
                                        ID</label>
                                    <select id="txt-identificationtype" name="txt-identificationtype"
                                        class="default-select  form-control form-control-sm" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_nroidenti" class="form-label text-primary"># Identificación</label>
                                    <div class="input-group">
                                        <input id="txt_nroidenti" name="txt_nroidenti" type="number" autocomplete="off"
                                            class="form-control form-control-sm" placeholder="12345678" required>
                                        <a class="input-group-text bg-primary text-white btn btn-sm rounded-pill"
                                            href="javascript:void(0);" id="btn-querybd" data-bs-placement="top"
                                            title="Consultar usuario existente"> <i class="fa fa-search"></i> </a>
                                        <a class="input-group-text bg-info text-white btn btn-sm rounded-pill"
                                            href="javascript:void(0);" id="btn-querydata" data-bs-placement="top"
                                            title="Consultar RENIEC"> <i class="fa fa-search"></i> </a>
                                        @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                    </div>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_nombres" class="form-label text-primary">Nombres</label>
                                    <input id="txt_nombres" name="txt_nombres" type="text" autocomplete="off"
                                        class="form-control form-control-sm text-capitalize"
                                        placeholder="Ingrese nombres" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_apellido_pa" class="form-label text-primary">Apellido
                                        paterno</label>
                                    <input id="txt_apellido_pa" name="txt_apellido_pa" type="text"
                                        autocomplete="off" class="form-control form-control-sm text-capitalize"
                                        placeholder="Ingrese apellido paterno" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_apellido_ma" class="form-label text-primary">Apellido
                                        materno</label>
                                    <input id="txt_apellido_ma" name="txt_apellido_ma" type="text"
                                        autocomplete="off" class="form-control form-control-sm text-capitalize"
                                        placeholder="Ingrese apellido materno" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div id="div_txt_password" class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_password" class="form-label text-primary">Contraseña</label>
                                    <input id="txt_password" name="txt_password" type="password"
                                        class="form-control form-control-sm" placeholder="********" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_acceso" class="form-label text-primary">Acceso</label>
                                    <select id="txt_acceso" name="txt_acceso"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        @include('include.combobox.bit')
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_fecnac" class="form-label text-primary">Fecha de
                                        Nacimiento</label>
                                    <input id="txt_fecnac" name="txt_fecnac" type="date"
                                        class="form-control form-control-sm" placeholder="" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-teachertypes" class="form-label text-primary">Tipo de
                                        docente</label>
                                    <select id="txt-teachertypes" name="txt-teachertypes"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_tipocontrato" class="form-label text-primary">Tipo de
                                        Contrato</label>
                                    <select id="txt_tipocontrato" name="txt_tipocontrato"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_horas_lectivas" class="form-label text-primary">Horas
                                        Lectivas</label>
                                    <input id="txt_horas_lectivas" name="txt_horas_lectivas" type="number"
                                        autocomplete="off"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                        class="form-control form-control-sm" placeholder="20" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_horas_nolectivas" class="form-label text-primary">Horas No
                                        Lectivas</label>
                                    <input id="txt_horas_nolectivas" name="txt_horas_nolectivas" type="number"
                                        autocomplete="off"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                        class="form-control form-control-sm" placeholder="20" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_estado" class="form-label text-primary">Estado</label>
                                    <select id="txt_estado" name="txt_estado"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        <option selected value="1">Contratado</option>
                                        <option value="0">Sin Contrato</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_correo" class="form-label text-primary">Correo Electrónico</label>
                                    <input id="txt_correo" name="txt_correo" type="email" autocomplete="off"
                                        class="form-control form-control-sm" placeholder="example@email.com" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_telefono" class="form-label text-primary">Teléfono</label>
                                    <input id="txt_telefono" name="txt_telefono" type="text" autocomplete="off"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                        class="form-control form-control-sm" placeholder="357-2984">
                                    {{-- @include('include.div.invalid-feedback') --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_celular" class="form-label text-primary">Celular</label>
                                    <input id="txt_celular" name="txt_celular" type="text" autocomplete="off"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                        class="form-control form-control-sm" placeholder="967-542-321" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_genre_id" class="form-label text-primary">Género</label>
                                    <select id="txt_genre_id" name="txt_genre_id"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        @include('include.combobox.genre')
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_departamento" class="form-label text-primary">Departamento</label>
                                    <select id="txt_departamento" name="txt_departamento"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox -->
                                        @include('include.combobox.departamento')
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_provincia" class="form-label text-primary">Provincia</label>
                                    <select id="txt_provincia" name="txt_provincia"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox dinamico -->
                                        <option selected disabled value="">Seleccione opción</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_distrito" class="form-label text-primary">Distrito</label>
                                    <select id="txt_distrito" name="txt_distrito"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox dinamico -->
                                        <option selected disabled value="">Seleccione opción</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_direccion" class="form-label text-primary">Dirección</label>
                                    <input id="txt_direccion" name="txt_direccion" type="text" autocomplete="off"
                                        class="form-control form-control-sm" maxlength="200"
                                        placeholder="Ejemplo: URB. SANTO DOMINGO ETAPA X MZ. M LT. 2" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- footer -->
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal -->
    <form id="formModal2" novalidate>
        @csrf
        <div id="modalUpdatePassword" class="modal fade" tabindex="-1" aria-labelledby="modalUpdatePasswordLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xs">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdatePasswordLabel">Actualizar Contraseña</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_iduser2" name="txt_iduser2" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_nroidenti2" class="form-label text-primary">#
                                        Identificación</label>
                                    <input id="txt_nroidenti2" name="txt_nroidenti2" type="text"
                                        autocomplete="off" class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_apenom" class="form-label text-primary">Apellidos y
                                        Nombres</label>
                                    <input id="txt_apenom" name="txt_apenom" type="text" autocomplete="off"
                                        class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_password2" class="form-label text-primary">Contraseña</label>
                                    <input id="txt_password2" name="txt_password2" type="password"
                                        autocomplete="off" class="form-control form-control-sm"
                                        placeholder="********">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnUpdatePassword" type="button"
                            class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal -->
    <form id="formModal3" novalidate>
        @csrf
        <div id="modalUpdateCredentialsZoom" class="modal fade" tabindex="-1"
            aria-labelledby="modalUpdateCredentialsZoomLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xs">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdatePasswordLabel">Actualizar Credenciales de Zoom
                        </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_iduser3" name="txt_iduser3" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_nroidenti3" class="form-label text-primary">#
                                        Identificación</label>
                                    <input id="txt_nroidenti3" name="txt_nroidenti3" type="text"
                                        autocomplete="off" class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_account_id" class="form-label text-primary">ID de Cuenta
                                        (Zoom)</label>
                                    <input id="txt_account_id" name="txt_account_id" type="text"
                                        autocomplete="off" class="form-control form-control-sm"
                                        placeholder="Conseguir de API de Zoom">
                                        @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_client_id" class="form-label text-primary">ID de Cliente
                                        (Zoom)</label>
                                    <input id="txt_client_id" name="txt_client_id" type="text" autocomplete="off"
                                        class="form-control form-control-sm"
                                        placeholder="Conseguir de API de Zoom">
                                        @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_client_secret" class="form-label text-primary">Client Secret
                                        (Zoom)</label>
                                    <input id="txt_client_secret" name="txt_client_secret" type="text"
                                        autocomplete="off" class="form-control form-control-sm"
                                        placeholder="Conseguir de API de Zoom">
                                        @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnUpdateCredentialsZoom" type="button"
                            class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);

    <!--  Page JS -->
    @vite(['resources/js/admin/portafolio_docentes/docentes.js']);
    @vite(['resources/js/common/combobox/roles.js']);
    @vite(['resources/js/common/combobox/ubigeo.js']);
    @vite(['resources/js/common/combobox/teachercontracttypes.js']);
    @vite(['resources/js/common/combobox/teachertypes.js']);
    @vite(['resources/js/common/combobox/identificationtypes.js']);

</body>

</html>
