import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert, swal_message_success } from "../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../common/schemas.js";
import { cb_areas } from "../common/combobox/areas.js";
import { cb_td_tipos } from "../common/combobox/td_tipos.js";
import { cb_identificationtypes } from "../common/combobox/identificationtypes_v2.js";
import { cb_td_tipos_solicitantes } from "../common/combobox/td_tipos_solicitantes.js";
import { cb_programs } from "../common/combobox/programs_v2.js";

$(document).ready(function () {
    cb_areas();
    cb_td_tipos();
    cb_identificationtypes("txt_identification_type");
    cb_td_tipos_solicitantes();
    // cb_programs("txt_programa");

    function cb_areas() {
        $("#txt_area").find("option").remove().end() 
        $.ajax({
            type: "GET",
            url: '/ajax_all/areas',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt_area").append('<option selected disabled value="">Seleccione un área</option>');
                response.forEach((elemento) => {
                    const titulo = `(${elemento.abreviatura}) ${elemento.nombre}`
                    $("#txt_area").append('<option value="' + elemento.id + '" >' + titulo + '</option>');
                })
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function cb_td_tipos() {
        $("#txt_td_tipo").find("option").remove().end() 
        $.ajax({
            type: "GET",
            url: '/ajax_all/td_tipos',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt_td_tipo").append('<option selected disabled value="">Seleccione una opción</option>');
                response.forEach((elemento) => {
                    $("#txt_td_tipo").append('<option value="' + elemento.id + '" >' + elemento.nombre + '</option>');
                })
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function cb_identificationtypes(elementId='txt-identificationtype') {
        const elementItem = $(`#${elementId}`)
        elementItem.find("option").remove().end()
        $.ajax({
            type: "GET",
            url: "/ajax_all/identificationtypes",
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                elementItem.append('<option selected disabled value="">Seleccione una opción</option>');
                response.forEach((elemento) => {
                    elementItem.append('<option ' +
                        'value="' + elemento.id + '" ' +
                        'data-tipo="' + elemento.tipo + '"' +
                        ' >' + elemento.tipo + '</option>');
                })
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function cb_td_tipos_solicitantes() {
        $("#txt_td_tipo_solicitante").find("option").remove().end()
        $.ajax({
            type: "GET",
            url: '/ajax_all/td_tipos_solicitantes',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt_td_tipo_solicitante").append('<option selected disabled value="">Seleccione una opción</option>');
                response.forEach((elemento) => {
                    $("#txt_td_tipo_solicitante").append('<option value="' + elemento.id + '" >' + elemento.nombre + '</option>');
                })
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
    
    // setear fecha de documento
    $("#txt_fechadoc").val(getActualDate());

    $('#txt_td_tipo_solicitante').on('change', function () {
        var valor = $(this).val();
        if (valor == 5) {
            $('#div_ruc, #div_razon_social').show();
            $('#txt_ruc, #txt_razon_social').prop('disabled', false).prop('required', true);
        } else {
            $('#div_ruc, #div_razon_social').hide();
            $('#txt_ruc, #txt_razon_social').prop('disabled', true).prop('required', false).val('');
        }
    });
    
    $("#btnRegistrarTD").on("click", function (event) {
        event.preventDefault();
        
        const formCheck = $("#form")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass("was-validated"); // añadir validaciones
            return;
        }
        
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a registrar tu solicitud de trámite documentario",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                store();
            }
        });
    });
    
    function getActualDate() {
        const fechaActual = new Date();
        // Formatear la fecha (puedes personalizar el formato según tus necesidades)
        const formatoFecha = { year: "numeric", month: "2-digit", day: "2-digit" };
        const fechaFormateada = fechaActual.toLocaleDateString(
            "es-ES",
            formatoFecha
        );
        return fechaFormateada;
    }
    
    function store() {
        const btnTrigger = $("#btnRegistrarTD");
        const formData = new FormData(document.getElementById("form"));
        
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/tramite_documentario/registrar",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                btnTrigger.addClass("disabled");
            },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    swal_message_success(
                        `Código: ${data.nt}`,
                        'En "Mis trámites" puedes consultar el estado!',
                        "success"
                    );
                    btnTrigger.removeClass("disabled");
                    clearForm();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    btnTrigger.removeClass("disabled");
                }
            },
            error: function (error) {
                console.log("Error", error);
                btnTrigger.removeClass("disabled");
            },
        });
    }

    // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
    const clearForm = () => {
        // $("#txt_td_tipo").val("");
        // $("#txt_area").val("");
        // $("#txt_asunto").val("");
        // $("#txt_documentos").val("");
        // $("#txt_folios").val("");
        // $("#txt_fechadoc").val(getActualDate());
        // $("#documento").val("");
        $("#check_tyc").prop("checked", false);
    };

    //Traer datos con el RUC 
    $("#btn-querydata1").on("click", function (event) {
        var ruc = $("#txt_ruc").val();
        $.ajax({
            type: "GET",
            url: '/admin/query_data_ruc/' + ruc,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                const dataObj = JSON.parse(response.data);
                if (dataObj.hasOwnProperty('message')) {
                    console.log(dataObj.message);
                    notificaciontoast("error", "Datos del DNI no encontrado", "Error!", "top-center");
                } else {
                    $("#txt_razon_social").val(convertirTexto(dataObj.nombre));
                    // setear data de programa
                    $("#txt_razon_social").addClass("border border-info shadow");
                    // remover clases después de un tiempo
                    setTimeout(function () {
                        $("#txt_razon_social").removeClass("border border-info shadow");
                    }, 300);
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

    //Traer datos con el DNI desde la RENIEC
    $("#btn-querydata2").on("click", function (event) {
        var nroidenti = $("#txt_numero_documento").val();
        $.ajax({
            type: "GET",
            url: '/admin/query_data/' + nroidenti,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                const dataObj = JSON.parse(response.data);
                if (dataObj.hasOwnProperty('message')) {
                    console.log(dataObj.message);
                    notificaciontoast("error", "Datos del DNI no encontrado", "Error!", "top-center");
                } else {
                    $("#txt_nombres").val(convertirTexto(dataObj.nombres));
                    $("#txt_apellido_pa").val(convertirTexto(dataObj.apellidoPaterno));
                    $("#txt_apellido_ma").val(convertirTexto(dataObj.apellidoMaterno));
                    // setear data de programa
                    $("#txt_nombres").addClass("border border-info shadow");
                    $("#txt_apellido_pa").addClass("border border-info shadow");
                    $("#txt_apellido_ma").addClass("border border-info shadow");
                    // remover clases después de un tiempo
                    setTimeout(function () {
                        $("#txt_nombres").removeClass("border border-info shadow");
                        $("#txt_apellido_pa").removeClass("border border-info shadow");
                        $("#txt_apellido_ma").removeClass("border border-info shadow");
                    }, 300);
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

    function convertirTexto(texto) {
        texto = texto.toLowerCase();
        var palabras = texto.split(' ');
        for (var i = 0; i < palabras.length; i++) {
            palabras[i] = palabras[i].charAt(0).toUpperCase() + palabras[i].substring(1);
        }
        var resultado = palabras.join(' ');
        
        return resultado;
    }

    // INICIO - MODAL
    $("#btnConsultarTD").on("click", function (event) {
        // setear data de cargo
        $('#codigo').val($(this).attr("data-codigo"))
        
        $('#estado').val($(this).attr("data-estado"))
        $('#estado').css({ 'color': `${$(this).attr("data-estado-color")}` });
        
        var datos_solicitante = '';
        if($(this).attr("data-ruc") != "--"){ 
            datos_solicitante =  'RUC: ' + $(this).attr("data-ruc") + '\n' 
            datos_solicitante += 'Razón Social: ' + $(this).attr("data-razon_social") + '\n';
        }
        datos_solicitante += 'N° Documento: ' + $(this).attr("data-numero_documento") + '\n';
        datos_solicitante += 'Nombres: ' + $(this).attr("data-nombres") + '\n';
        datos_solicitante += 'Apellido Paterno: ' + $(this).attr("data-apellido_pa") + '\n';
        datos_solicitante += 'Apellido Materno: ' + $(this).attr("data-apellido_ma") + '\n';
        datos_solicitante += 'Ubigeo: ' + $(this).attr("data-ubigeo_id") + '\n';
        datos_solicitante += 'Dirección: ' + $(this).attr("data-direccion") + '\n';
        datos_solicitante += 'Celular: ' + $(this).attr("data-celular") + '\n';
        datos_solicitante += 'Correo: ' + $(this).attr("data-correo");
        

        $('#tipo').val($(this).attr("data-tipo"))
        $('#area').val($(this).attr("data-area"))
        $('#asunto').val($(this).attr("data-asunto"))
        $('#solicitante').val(datos_solicitante)
        $('#documentos').val($(this).attr("data-documentos"))
        $('#folios').val($(this).attr("data-folios"))
        $('#fecha').val($(this).attr("data-fecha"))
        const info_nota_respuesta = $(this).attr("data-nota_respuesta")
        if (info_nota_respuesta === null || info_nota_respuesta === 'null') {
            $('#info_nota_respuesta').val('')
        } else {
            $('#info_nota_respuesta').val($(this).attr("data-nota_respuesta"))
        }
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
    });
    // FIN - MODAL

    $("#btnConsultarTD").on("click", async function (event) {
        event.preventDefault();
        const codigoTd = document.getElementById("txt-codigo_tramite").value;
        
        clearDatos();
        
        $("#modalConsulta").modal("show");

        // SI EL NUMERO DE IDENTIFACION ESTÁ VACIO
        if (codigoTd == "") {
            notificaciontoast("error", "Ingrese código", "Mensaje!");
            // setear data de programa
            $("#txt-codigo_tramite").addClass("border border-danger shadow");
            setTimeout(function () {
                document.getElementById("txt-codigo_tramite").focus();
                $("#txt-codigo_tramite").removeClass(
                    "border border-danger shadow"
                );
            }, 1500);
            return;
        }
        
        // FETCH DE DATOS
        notificaciontoast("warning", "Consultando!", "Mensaje!");
        const data = await getDataTdByCodigo(codigoTd);
        if (!data.status) {
            notificaciontoast("error", data.mensaje, "Error!");
            return;
        }
        notificaciontoast("info", data.mensaje, "Info!");
        
        // DATA TD
        const data_td = data.data_td;
        
        $("#txt-td_codigo").val(codigoTd);
        $("#txt-td_estado").val(data_td.td_estado.nombre);
        $("#txt-td_estado").css('color', data_td.td_estado.color);
        $("#txt-td_tipo").val(data_td.td_tipo.nombre);
        $("#txt-td_tipo_solicitante").val(data_td.td_tipo_solicitante.nombre);
        $("#txt-area").val(data_td.area.nombre);
        $("#txt-identification_type").val(data_td.tipo_identificacion.tipo);
        $("#txt-numero_documento").val(data_td.numero_documento);
        $("#txt-ruc").val(data_td.ruc);
        $("#txt-razon_social").val(data_td.razon_social);
        $("#txt-nombres").val(data_td.nombres);
        $("#txt-apellido_pa").val(data_td.apellido_pa);
        $("#txt-apellido_ma").val(data_td.apellido_ma);
        $("#txt-direccion").val(data_td.direccion);
        $("#txt-correo").val(data_td.correo);
        $("#txt-celular").val(data_td.celular);
        $("#txt-asunto").val(data_td.info_asunto);
        $("#txt-documentos").val(data_td.info_documentos);
        $("#txt-folios").val(data_td.info_folios);
        $("#txt-nota").val(data_td.nota_respuesta);
        
        const date = new Date(data_td.fecha);
        const year = date.getFullYear();
        const month = String(date.getMonth() + 1).padStart(2, "0"); // Mes es 0-indexado
        const day = String(date.getDate()).padStart(2, "0");
        const formattedDate = `${year}-${month}-${day}`;
        $("#txt_fechadoc").val(formattedDate);
    });

    const getDataTdByCodigo = async (codigoTd) => {
        const response = await fetch(
            `/api/tramite_documentario/codigo/${codigoTd}`
        );
        const data = await response.json();
        return data;
    };

    const clearDatos = () => {
    $("#txt-td_codigo").val("");
    $("#txt-td_estado").val("");
    $("#txt-nota").val("");
    $("#txt-td_tipo").val("");
    $("#txt-td_tipo_solicitante").val("");
    $("#txt-identification_type").val("");
    $("#txt-numero_documento").val("");
    $("#txt-apellido_pa").val("");
    $("#txt-apellido_ma").val("");
    $("#txt-nombres").val("");
    $("#txt-ruc").val("");
    $("#txt-razon_social").val("");
    $("#txt-direccion").val("");
    $("#txt-correo").val("");
    $("#txt-celular").val("");
    $("#txt-asunto").val("");
    $("#txt-documentos").val("");
    $("#txt-folios").val("");
    $("#txt-fechadoc").val("");
};
});
