import { notificaciontoast } from "../common/method_toast.js";

$(document).ready(function () {
    // VALIDAR DATA ALUMNO
    $("#btnConsultarTD").on("click", async function (event) {
        event.preventDefault();
        const codigoTd = document.getElementById("txt_td_codigo_buscar").value;

        clearDatos();

        // SI EL NUMERO DE IDENTIFACION ESTÁ VACIO
        if (codigoTd == "") {
            notificaciontoast("error", "Ingrese código", "Mensaje!");
            // setear data de programa
            $("#txt_td_codigo_buscar").addClass("border border-danger shadow");
            setTimeout(function () {
                document.getElementById("txt_td_codigo_buscar").focus();
                $("#txt_td_codigo_buscar").removeClass(
                    "border border-danger shadow"
                );
            }, 1500);
            return;
        }

        // FETCH DE DATOS
        notificaciontoast("warning", "Consultando!", "Mensaje!");
        const data = await getDataTdByCodigo(codigoTd);
        if (!data.status) {
            notificaciontoast("error", data.mensaje, "Error!");
            return;
        }
        notificaciontoast("info", data.mensaje, "Info!");

        // DATA TD
        const data_td = data.data_td;

        $("#txt_td_codigo").val(codigoTd);
        $("#txt_td_estado").val(data_td.td_estado.nombre);
        $("#txt_td_estado").css('color', data_td.td_estado.color);
        $("#txt_nota").val(data_td.nota_respuesta);
        $("#txt_td_tipo").val(data_td.td_tipo.nombre);
        $("#txt_td_area").val(data_td.td_tipo.nombre);
        $("#txt_td_tipo_solicitante").val(data_td.td_tipo_solicitante.nombre);
        $("#txt_identification_type").val(data_td.tipo_identificacion.tipo);
        $("#txt_numero_documento").val(data_td.numero_documento);
        $("#txt_ruc").val(data_td.ruc);
        $("#txt_razon_social").val(data_td.razon_social);
        $("#txt_nombres").val(data_td.nombres);
        $("#txt_apellido_pa").val(data_td.apellido_pa);
        $("#txt_apellido_ma").val(data_td.apellido_ma);
        $("#txt_programa").val(data_td.programa.nombre);
        $("#txt_direccion").val(data_td.direccion);
        $("#txt_correo").val(data_td.correo);
        $("#txt_celular").val(data_td.celular);
        $("#txt_asunto").val(data_td.info_asunto);
        $("#txt_documentos").val(data_td.info_documentos);
        $("#txt_folios").val(data_td.info_folios);

        const date = new Date(data_td.fecha);
        const year = date.getFullYear();
        const month = String(date.getMonth() + 1).padStart(2, "0"); // Mes es 0-indexado
        const day = String(date.getDate()).padStart(2, "0");
        const formattedDate = `${year}-${month}-${day}`;
        $("#txt_fechadoc").val(formattedDate);
    });
});

const getDataTdByCodigo = async (codigoTd) => {
    const response = await fetch(
        `/api/tramite_documentario/codigo/${codigoTd}`
    );
    const data = await response.json();
    return data;
};

const clearDatos = () => {
    $("#txt_td_codigo").val("");
    $("#txt_td_estado").val("");
    $("#txt_nota").val("");
    $("#txt_td_tipo").val("");
    $("#txt_td_tipo_solicitante").val("");
    $("#txt_identification_type").val("");
    $("#txt_numero_documento").val("");
    $("#txt_apellido_pa").val("");
    $("#txt_apellido_ma").val("");
    $("#txt_nombres").val("");
    $("#txt_programa").val("");
    $("#txt_direccion").val("");
    $("#txt_correo").val("");
    $("#txt_celular").val("");
    $("#txt_asunto").val("");
    $("#txt_documentos").val("");
    $("#txt_folios").val("");
    $("#txt_fechadoc").val("");
};
