import { notificaciontoast } from "../common/method_toast.js";
import { message_sweetAlert } from "../common/method_sweetAlert.js";

'use strict';
(function () {

    // Obtener una referencia al botón
    var miBoton = document.querySelector('#btn_button_login');

    // Agregar un evento de clic al botón
    miBoton.addEventListener('click', function (event) {
        event.preventDefault();
        const formCheck = $("#form")[0];
        $(formCheck).addClass('was-validated'); // añadir validaciones
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            notificaciontoast("warning", "Validando credenciales", "Mensaje", "top-right");
            //LLAMAR A FUNCION PARA VERIFICAR CON DELAY
            // setTimeout(function () {
                validateLogin();
            // }, 1150);
        }
    }, false);


    const btnProfileLogin = document.querySelector('#btnProfileLogin')

    btnProfileLogin.addEventListener('click', function (event) {
        event.preventDefault();
        const formCheck = $("#formProfileLogin")[0];
        $(formCheck).addClass('was-validated'); // añadir validaciones
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            setProfileLogin();
        }
    }, false);


    function validateLogin() {
        const formData = new FormData(document.getElementById('form'));
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: '/authenticateLogin',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    setTimeout(function () {
                        if (data.hasRedirect == true) {
                            notificaciontoast("info", data.message, "Éxito!", "top-right");
                            setTimeout(function () {
                                window.location = data.redirect;
                            }, 1150);
                        }
                        else {
                            const userRoles = data.userRoles;
                            $("#tipoUsuarioLogin").find("option").remove().end() // delete options
                            $("#tipoUsuarioLogin").append('<option selected disabled value="">Seleccione opción</option>');
                            if (userRoles.includes('admin')) {
                                $("#tipoUsuarioLogin").append(`<option value='admin'>Administrador</option>`);
                            }
                            if (userRoles.includes('docente')) {
                                $("#tipoUsuarioLogin").append(`<option value='docente'>Docente</option>`);
                            }
                            if (userRoles.includes('alumno')) {
                                $("#tipoUsuarioLogin").append(`<option value='alumno'>Alumno</option>`);
                            }
                            $("#tipoUsuarioLogin").selectpicker("refresh");
                            $("#modalProfileLogin").modal("show");
                        }
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.message, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
                notificaciontoast("error", "Ha ocurrido un error inesperado. Por favor, inténtalo de nuevo.", "Error!");
            },
        });
    }


    function setProfileLogin() {
        const formData = new FormData(document.getElementById('formProfileLogin'));
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: '/profileLogin',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.message, "Éxito!", "top-right");
                    setTimeout(function () {
                        window.location = data.redirect;
                    }, 1150);
                } else {
                    notificaciontoast("error", data.message, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    const passwordInput = document.getElementById("password");
    const togglePasswordButton = document.getElementById("btn_view_password");

    togglePasswordButton.addEventListener("click", () => {
        // Alternar el tipo del input entre "password" y "text"
        const isPassword = passwordInput.type === "password";
        passwordInput.type = isPassword ? "text" : "password";
    });


})();
