import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../common/schemas.js";

$(document).ready(function () {
    // VALIDAR DATA ALUMNO
    $("#btn-querydata").on("click", async function (event) {
        event.preventDefault();
        const nroDocumento = document.getElementById("txt_nroidenti").value;
        clearFields();

        // SI EL NUMERO DE IDENTIFACION ESTÁ VACIO
        if (nroDocumento == "") {
            notificaciontoast(
                "error",
                "Ingrese # de identificación",
                "Mensaje!"
            );
            // setear data de programa
            $("#txt_nroidenti").addClass("border border-danger shadow");
            setTimeout(function () {
                document.getElementById("txt_nroidenti").focus();
                $("#txt_nroidenti").removeClass("border border-danger shadow");
            }, 1500);
            return;
        }

        // FETCH DE DATOS
        notificaciontoast("warning", "Consultando!", "Mensaje!");
        const data = await getDataFichaByNroDocumento(nroDocumento);
        if (!data.status) {
            notificaciontoast("error", data.mensaje, "Error!");
            return;
        }
        notificaciontoast("info", data.mensaje, "Info!");

        const btnSaveFicha = $("#btnSaveFicha");

        // DATA USER
        const data_user = data.data_user;
        // SET ID ESTUDIANTE
        $("#txt_idstudent").val(data_user.students[0].id);

        btnSaveFicha.html("Registrar");
        // 1° CARD -> IDENTIFICACIÓN PERSONAL
        $("#txt_nombres").val(data_user.nombres);
        $("#txt_apellido_pa").val(data_user.apellido_pa);
        $("#txt_apellido_ma").val(data_user.apellido_ma);
        $("#txt_dni").val(data_user.nroidenti);
        $("#txt_carrera").val(data_user.students[0].plan.program.nombre);
        $("#txt_ingreso").val(data_user.students[0].anho_ingreso);
        $("#txt_domicilio").val(data_user.direccion);
        $("#txt_correo").val(data_user.correo);
        $("#txt_celular").val(data_user.celular);
        $("#txt_direccion").val(data_user.direccion);

        if (data.ficha_socioeconomica) {
            btnSaveFicha.html("Actualizar");
            // 2° CARD -> ACTIVIDAD LABORAL
            const data_ficha = data.data_ficha;
            $("#txt_trabaja").selectpicker("val", data_ficha.flg_trabaja);
            if (data_ficha.flg_trabaja == "si") {
                showActualTrabaja();
            } else {
                hideActualTrabaja();
            }
            $("#txt_rubro").val(data_ficha.rubro_empresa);
            $("#txt_jefe").val(data_ficha.nombre_jefe);
            $("#txt_formacontrato").val(data_ficha.forma_contrato);
            $("#txt_tipoempresa").val(data_ficha.forma_contrato);
            $("#txt_nomempresa").val(data_ficha.empresa);
            $("#txt_remuneracion").val(data_ficha.ingreso_mensual);
            $("#txt_civil").val(data_ficha.estado_civil);
            $("#txt_numhijos").val(data_ficha.nro_hijos);
            $("#txt_tipovivienda").val(data_ficha.tipovivienda);
            $("#txt_cargo").val(data_ficha.ocupacion);
            $("#txt_gastos").val(data_ficha.gastos_mensuales);

            // 3° CARD -> EVALUACIÓN DE LA FORMACIÓN
            $("#txt_anteriormente").selectpicker(
                "val",
                data_ficha.flg_antes_trabajaba
            );
            if (data_ficha.flg_antes_trabajaba == "si") {
                showAnteriorTrabaja();
            } else {
                hideAnteriorTrabaja();
            }
            $("#txt_negativopositivo").val(data_ficha.meses_no_trabaja);
            $("#txt_porque").val(data_ficha.explicacion);
            $("#txt_explicacionlaboral").val(data_ficha.form_prof_recibida);
            $("#txt_satisface").val(data_ficha.carrera_satis_necesi);
            $("#txt_beneficiado").val(
                data_ficha.area_carrera_profesiona_beneficiado
            );
            $("#txt_conforme").val(data_ficha.satisfecho_form_institu_brindo);
            $("#txt_motivos").val(
                data_ficha.motivos_satisfecho_form_institu_brindo
            );
            $("#txt_motivos_razon").val(data_ficha.razon_form_institu_brindo);
        }
        // estilo para inputs
        addClasses();
        setTimeout(() => {
            clearClasses();
        }, 1500);
    });

    const getDataFichaByNroDocumento = async (nroDocumento) => {
        const response = await fetch(
            `/api/ficha_socioeconomica/nro_documento/${nroDocumento}`
        );
        const data = await response.json();
        return data;
    };

    // GUARDAR FICHA SOCIOECONOMICA
    $("#btnSaveFicha").on("click", async function (event) {
        event.preventDefault();

        const formCheck = $("#form")[0];
        $(formCheck).addClass("was-validated"); // añadir validaciones

        if (!formCheck.checkValidity()) {
            event.stopPropagation();
            notificaciontoast("warning", "Llene todos los campos!", "Mensaje!");
            return;
        }

        const idStudent = $("#txt_idstudent").val();
        if (idStudent === "" || idStudent === null) {
            notificaciontoast(
                "warning",
                "Favor de buscar a un estudiante",
                "Mensaje!"
            );
            return;
        }

        upsertFicha();
    });

    const upsertFicha = async () => {
        const form = document.getElementById("form");
        const formData = new URLSearchParams(new FormData(form)); // serializar formulario
        const btnTrigger = $("#btnSaveFicha");

        try {
            btnTrigger.addClass("disabled");

            const response = await fetch("/api/ficha_socioeconomica/upsert", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded", // formato de serialize()
                },
                body: formData,
            });

            if (!response.ok) {
                throw new Error("Error en la respuesta del servidor");
            }

            const data = await response.json();

            if (data.status === true) {
                notificaciontoast("info", data.mensaje, "Éxito!");
            } else {
                notificaciontoast("error", data.mensaje, "Error!");
            }
        } catch (error) {
            console.error("Error", error);
        } finally {
            btnTrigger.removeClass("disabled");
            setTimeout(() => {
                const formCheck = document.getElementById("form");
                formCheck.classList.remove("was-validated"); // remover validaciones
            }, 2000);
        }
    };

    function addClasses() {
        $("#txt_tipoUser_consulta").addClass("text-primary");
        $("#txt_nombres").addClass("border border-info shadow");
        $("#txt_apellido_pa").addClass("border border-info shadow");
        $("#txt_apellido_ma").addClass("border border-info shadow");
        $("#txt_dni").addClass("border border-info shadow");
        $("#txt_carrera").addClass("border border-info shadow");
        $("#txt_ingreso").addClass("border border-info shadow");
        $("#txt_domicilio").addClass("border border-info shadow");
        $("#txt_correo").addClass("border border-info shadow");
        $("#txt_celular").addClass("border border-info shadow");

        $("#txt_trabaja").addClass("border border-info shadow");
        $("#txt_rubro").addClass("border border-info shadow");
        $("#txt_jefe").addClass("border border-info shadow");
        $("#txt_formacontrato").addClass("border border-info shadow");
        $("#txt_tipoempresa").addClass("border border-info shadow");
        $("#txt_nomempresa").addClass("border border-info shadow");
        $("#txt_remuneracion").addClass("border border-info shadow");
        $("#txt_civil").addClass("border border-info shadow");
        $("#txt_numhijos").addClass("border border-info shadow");
        $("#txt_tipovivienda").addClass("border border-info shadow");
        $("#txt_cargo").addClass("border border-info shadow");
        $("#txt_gastos").addClass("border border-info shadow");

        $("#txt_anteriormente").addClass("border border-info shadow");
        $("#txt_negativopositivo").addClass("border border-info shadow");
        $("#txt_porque").addClass("border border-info shadow");
        $("#txt_explicacionlaboral").addClass("border border-info shadow");
        $("#txt_satisface").addClass("border border-info shadow");
        $("#txt_beneficiado").addClass("border border-info shadow");
        $("#txt_conforme").addClass("border border-info shadow");
        $("#txt_motivos").addClass("border border-info shadow");
        $("#txt_gastos").addClass("border border-info shadow");
        $("#txt_motivos_razon").addClass("border border-info shadow");
    }

    function clearClasses() {
        // limpiar clases
        $("#txt_nombres").removeClass("border border-info shadow");
        $("#txt_apellido_pa").removeClass("border border-info shadow");
        $("#txt_apellido_ma").removeClass("border border-info shadow");
        $("#txt_dni").removeClass("border border-info shadow");
        $("#txt_carrera").removeClass("border border-info shadow");
        $("#txt_ingreso").removeClass("border border-info shadow");
        $("#txt_domicilio").removeClass("border border-info shadow");
        $("#txt_correo").removeClass("border border-info shadow");
        $("#txt_celular").removeClass("border border-info shadow");
        $("#txt_trabaja")
            .closest(".bootstrap-select")
            .removeClass("border border-info shadow");
        $("#txt_rubro").removeClass("border border-info shadow");
        $("#txt_jefe").removeClass("border border-info shadow");
        $("#txt_formacontrato").removeClass("border border-info shadow");
        $("#txt_tipoempresa").removeClass("border border-info shadow");
        $("#txt_nomempresa").removeClass("border border-info shadow");
        $("#txt_remuneracion").removeClass("border border-info shadow");
        $("#txt_civil").removeClass("border border-info shadow");
        $("#txt_numhijos").removeClass("border border-info shadow");
        $("#txt_tipovivienda").removeClass("border border-info shadow");
        $("#txt_cargo").removeClass("border border-info shadow");
        $("#txt_gastos").removeClass("border border-info shadow");

        $("#txt_anteriormente").removeClass("border border-info shadow");
        $("#txt_negativopositivo").removeClass("border border-info shadow");
        $("#txt_porque").removeClass("border border-info shadow");
        $("#txt_explicacionlaboral").removeClass("border border-info shadow");
        $("#txt_satisface").removeClass("border border-info shadow");
        $("#txt_beneficiado").removeClass("border border-info shadow");
        $("#txt_conforme").removeClass("border border-info shadow");
        $("#txt_motivos").removeClass("border border-info shadow");
        $("#txt_gastos").removeClass("border border-info shadow");
        $("#txt_motivos_razon").removeClass("border border-info shadow");
    }

    function clearFields() {
        // 1° CARD -> IDENTIFICACIÓN PERSONAL
        $("#txt_nombres").val("");
        $("#txt_apellido_pa").val("");
        $("#txt_apellido_ma").val("");
        $("#txt_dni").val("");
        $("#txt_carrera").val("");
        $("#txt_ingreso").val("");
        $("#txt_domicilio").val("");
        $("#txt_correo").val("");
        $("#txt_celular").val("");
        $("#txt_direccion").val("");
        // 2° CARD -> ACTIVIDAD LABORAL
        showActualTrabaja();
        $("#txt_trabaja").selectpicker("val", "si");
        $("#txt_rubro").val("");
        $("#txt_jefe").val("");
        $("#txt_formacontrato").val("");
        $("#txt_tipoempresa").val("");
        $("#txt_nomempresa").val("");
        $("#txt_remuneracion").val("");
        $("#txt_civil").val("");
        $("#txt_numhijos").val("");
        $("#txt_tipovivienda").val("");
        $("#txt_cargo").val("");
        $("#txt_gastos").val("");

        // 3° CARD -> EVALUACIÓN DE LA FORMACIÓN
        showAnteriorTrabaja();
        $("#txt_anteriormente").selectpicker("val", "si");
        $("#txt_negativopositivo").val("");
        $("#txt_porque").val("");
        $("#txt_explicacionlaboral").val("");
        $("#txt_satisface").val("");
        $("#txt_beneficiado").val("");
        $("#txt_conforme").selectpicker("val", "si");
        $("#txt_motivos").val("");
        $("#txt_motivos_razon").val("");
    }

    // on change actividad laboral
    $("#txt_trabaja").on("change", function () {
        if ($(this).val() == "si") {
            showActualTrabaja();
        } else {
            hideActualTrabaja();
        }
    });

    // on change actividad laboral
    $("#txt_anteriormente").on("change", function () {
        if ($(this).val() == "si") {
            showAnteriorTrabaja();
        } else {
            hideAnteriorTrabaja();
        }
    });

    function showActualTrabaja() {
        $("#div-txt_nomempresa").css("display", "block");
        $("#txt_nomempresa").attr("required", "true"); // agregar required
        $("#div-txt_tipoempresa").css("display", "block");
        $("#txt_tipoempresa").attr("required", "true"); // agregar required
        $("#div-txt_remuneracion").css("display", "block");
        $("#txt_remuneracion").attr("required", "true"); // agregar required
        $("#div-txt_rubro").css("display", "block");
        $("#txt_rubro").attr("required", "true"); // agregar required
        $("#div-txt_jefe").css("display", "block");
        $("#txt_jefe").attr("required", "true"); // agregar required
        $("#div-txt_cargo").css("display", "block");
        $("#txt_cargo").attr("required", "true"); // agregar required
        $("#div-txt_formacontrato").css("display", "block");
        $("#txt_formacontrato").attr("required", "true"); // agregar required
    }
    function hideActualTrabaja() {
        $("#div-txt_nomempresa").css("display", "none");
        $("#txt_nomempresa").removeAttr("required"); // para poder pasar el check validity
        $("#div-txt_tipoempresa").css("display", "none");
        $("#txt_tipoempresa").removeAttr("required"); // para poder pasar el check validity
        $("#div-txt_remuneracion").css("display", "none");
        $("#txt_remuneracion").removeAttr("required"); // para poder pasar el check validity
        $("#div-txt_rubro").css("display", "none");
        $("#txt_rubro").removeAttr("required"); // para poder pasar el check validity
        $("#div-txt_jefe").css("display", "none");
        $("#txt_jefe").removeAttr("required"); // para poder pasar el check validity
        $("#div-txt_cargo").css("display", "none");
        $("#txt_cargo").removeAttr("required"); // para poder pasar el check validity
        $("#div-txt_formacontrato").css("display", "none");
        $("#txt_formacontrato").removeAttr("required"); // para poder pasar el check validity
    }
    function showAnteriorTrabaja() {
        $("#div-txt_negativopositivo").css("display", "block");
        $("#txt_negativopositivo").attr("required", "true"); // agregar required
        $("#div-txt_explicacionlaboral").css("display", "block");
        $("#txt_explicacionlaboral").attr("required", "true"); // agregar required
        $("#div-txt_porque").css("display", "block");
        $("#txt_porque").attr("required", "true"); // agregar required
    }
    function hideAnteriorTrabaja() {
        $("#div-txt_negativopositivo").css("display", "none");
        $("#txt_negativopositivo").removeAttr("required"); // para poder pasar el check validity
        $("#div-txt_explicacionlaboral").css("display", "none");
        $("#txt_explicacionlaboral").removeAttr("required"); // para poder pasar el check validity
        $("#div-txt_porque").css("display", "none");
        $("#txt_porque").removeAttr("required"); // para poder pasar el check validity
    }
});
