// "use strict";
import { notificaciontoast } from '../common/method_toast.js'
import { confirmation_sweetAlert } from '../common/method_sweetAlert.js'

$(document).ready(function () {
  const tableName = 'Clases del Curso'

  // IDs seleccionados
  var dt_idsemester = 0

  // --------- DATATABLE AHORA LISTA CLASES (NO ALUMNOS) --------- //
  var table = $('#datatableGeneral').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    // AHORA SIN AJAX DIRECTO. SE ALIMENTA DESDE tl_subjectclasses
    data: [],
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacía.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    buttons: [
      {
        extend: 'excel',
        title: function () {
          return 'Reporte de Clases'
        },
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'pdf',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'print',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'colvis',
        text: 'Seleccionar celdas',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      }
    ],
    columns: [
      // Clase / Semana
      { data: 'clase', className: 'text-center' },
      // Día
      { data: 'dia', className: 'text-center' },
      // Horario: horaini2 - horafin2
      {
        data: null,
        className: 'text-center',
        render: function (data, type, row) {
          return `${row.horaini2} - ${row.horafin2}`
        }
      },
      // Reunión Zoom (crear / unirse / eliminar)
      {
        data: null,
        sortable: false,
        className: 'text-center noExport',
        render: function (data, type, row, meta) {
          // Si tiene reunión Zoom
          if (row.id_zoom_meeting && row.id_zoom_meeting.trim() !== '') {
            return `
              <div class="d-flex justify-content-center align-items-center flex-wrap">
                <button class="btn btn-success btn-sm mx-1"
                    onclick="joinZoomMeeting('${row.id_zoom_meeting}')"
                    title="Unirse a la reunión">
                  <i class="fas fa-play"></i>
                </button>
                <button class="btn btn-danger btn-sm mx-1"
                    data-toggle="modal"
                    data-target="#deleteConfirmationModal"
                    onclick="confirmDeleteZoomMeeting('${row.id_zoom_meeting}', '${row.idclass}')"
                    title="Eliminar esta reunión">
                  <i class="fas fa-trash-alt"></i>
                </button>
              </div>
            `
          } else {
            // No tiene reunión: botón para crear
            return `
              <button class="btn btn-sm mx-1"
                style="background-color:#2D8CFF; color:white; border-radius:8px;"
                onclick="preFillCreateMeetingModal(
                  '${row.fecha}', '${row.horaini}', '${row.duracion}',
                  '${row.account_id}', '${row.client_id}', '${row.client_secret}', '${row.id}',
                  '${row.apellido_pa}', '${row.apellido_ma}', '${row.nombres}', '${row.clase}',
                  '${row.dia}', '${row.nombre_curso}', '${row.idclass}'
                )"
                title="Crear una nueva reunión">
                <i class="bi bi-camera-video-fill"></i>
                <i class="bi bi-plus"></i>
            </button>
            `
          }
        }
      }
    ]
  })

  //--------- F U N C I O N E S --------------//
  function tl_subjects(idsemester) {
    $.ajax({
      type: 'GET',
      url: '/docente/materiales_recursos/ajax_all/asignaturas/' + idsemester,
      dataType: 'json',
      beforeSend: function () {},
      success: function (response) {
        document.getElementById('tlsubject').innerHTML = ''
        response.forEach((elemento) => {
          document.getElementById('tlsubject').innerHTML += `
            <li>
              <div class='divsubject timeline-badge primary'></div>
              <a class='btnSubject timeline-panel text-muted px-2 py-1 mr-4 ml-2'
                href='javascript:void(0);'
                data-idsubject='${elemento.id}'
                data-codcurso='${elemento.codcurso}'
                data-curso='${elemento.namecurso}'
                data-seccion='${elemento.seccion}'>
                <h6 class='mb-0 fs-14'>
                  <strong class='text-dark'>${elemento.namecurso}</strong>
                  <br>Sección: ${elemento.seccion}
                </h6>
              </a>
            </li>
          `
        })
      },
      error: function (error) {
        console.log('Error', error)
      }
    })
  }

  // Variable para almacenar el controlador de abortar
  let abortController = null
  let currentSubjectId = null

  // listar subjectclasses con cancelación de la solicitud anterior
  function tl_subjectclasses(idsubject) {
    if (abortController) {
      abortController.abort()
    }

    abortController = new AbortController()
    const signal = abortController.signal

    $('.btnSubject').prop('disabled', true).addClass('disabled')

    $('#login-loader').show()
    $('#login-loader').css('display', 'flex')

    $.ajax({
      type: 'GET',
      url: '/ajax_all/teachers/subjectclasses/' + idsubject,
      dataType: 'json',
      signal: signal,
      success: function (response) {
        table.clear()
        table.rows.add(response) // response es un array de objetos
        table.draw()

        $('#login-loader').hide()
        $('#login-loader').css('display', 'none')

        $('.btnSubject').prop('disabled', false).removeClass('disabled')
      },
      error: function (error) {
        if (error.name !== 'AbortError') {
          console.error('Error en la solicitud AJAX de clases', error)
        }
        $('#login-loader').hide()
        $('#login-loader').css('display', 'none')

        $('.btnSubject').prop('disabled', false).removeClass('disabled')
      }
    })
  }

  // on change semestres
  $(document).on('click', '.btnSemester', function () {
    dt_idsemester = $(this).attr('data-idsemester')
    $('.divsemester').removeClass('dark').addClass('primary')
    $(this).prev('div').removeClass('primary').addClass('dark')
    notificaciontoast('info', 'Consultando la base de datos.', 'Mensaje!')

    // Limpiar cursos y clases
    document.getElementById('tlsubject').innerHTML = ''
    table.clear().draw()

    tl_subjects(dt_idsemester) // Cargar nuevos cursos para el periodo
  })

  // on change asignaturas
  $(document).on('click', '.btnSubject', function () {
    currentSubjectId = $(this).data('idsubject')
    $('.divsubject').removeClass('dark').addClass('primary')
    $(this).prev('div').removeClass('primary').addClass('dark')

    // Limpiar timeline de clases y tabla, luego cargar
    table.clear().draw()

    tl_subjectclasses(currentSubjectId) // Cargar CLASES del curso en timeline + tabla
  })

  //on delete meeting: refrescar clases
  $(document).ready(function () {
    // Configurar un intervalo para monitorear el estado de la eliminación
    setInterval(function () {
      if (window.deleteSuccess) {
        window.deleteSuccess = false
        if (typeof tl_subjectclasses === 'function' && currentSubjectId) {
          tl_subjectclasses(currentSubjectId)
        }
      }
    }, 1000)
  })

  //on success create meeting: refrescar clases
  window.createSuccess = false

  $(document).ready(function () {
    setInterval(function () {
      if (window.createSuccess) {
        window.createSuccess = false
        if (typeof tl_subjectclasses === 'function' && currentSubjectId) {
          tl_subjectclasses(currentSubjectId)
        } else {
          console.warn('La función tl_subjectclasses no está definida.')
        }
      }
    }, 1000)
  })
})
