'use strict'

import { notificaciontoast } from '../common/method_toast.js'
import { getButtonsSchema, languageSchema } from '../common/schemas.js'

$(document).ready(function () {
  const tableName = 'Requisitos de Docentes'

  // LISTAR DATATABLE
  var table = $('#datatableGeneral').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    ajax: {
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: 'POST',
      url: '/docente/requisitos/list'
    },
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: languageSchema,
    buttons: getButtonsSchema(tableName),
    columns: [
      { data: 'id', className: 'text-center' },
      { data: 'requirement_name', className: 'text-center' },
      {
        data: 'documento',
        sortable: false,
        className: 'text-center',
        render: function (data, type, all, meta) {
          if (data == null) {
            return '--'
          } else {
            return `
              <div class="d-flex justify-content-center">
                <a href="/docente/requisitos/verDocumento/${all.id}"
                class="btnVerBoucher btn btn-info shadow btn-xs sharp me-1" target="_blank" data-bs-placement="top"
                title="Ver Documento">
                <i class="fas fa-file-lines fa-lg"></i>
                </a>
              </div>
            `
          }
        }
      },
      {
        data: 'estado',
        className: 'text-center',
        render: function (data, type, all, meta) {
          let badge = ''
          switch (data) {
            case 0:
              badge = '<span class="badge light badge-warning">Pendiente</span>'
              break
            case 1:
              badge = '<span class="badge light badge-success">Aprobado</span>'
              break
            case 2:
              badge = '<span class="badge light badge-danger">Rechazado</span>'
              break
            default:
              badge =
                '<span class="badge light badge-secondary">No enviado</span>'
          }
          return badge
        }
      },
      {
        data: 'id',
        className: 'text-center',
        sortable: false,
        render: function (data, type, all, meta) {
          // Estado 1: Aprobado → Deshabilitar edición
          if (all.estado == 1) {
            return `
              <div class="d-flex justify-content-center">
                <button class="btn btn-secondary shadow btn-xs sharp me-1" 
                  disabled 
                  title="Registro aprobado - no editable">
                  <i class="fas fa-lock"></i>
                </button>
              </div>
            `
          }

          // Caso normal → botón activo
          return `
            <div class="d-flex justify-content-center">
              <a href="#" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
              data-id="${all.id}"
              data-requirement_id="${all.requirement_id}"
              data-requirement_name="${all.requirement_name}"
              data-bs-placement="top"
              title="Editar registro">
              <i class="fas fa-pencil-alt"></i>
              </a>
            </div>
          `
        }
      }
    ]
  })

  // Agregar una columna de números automáticos
  table
    .on('order.dt search.dt', function () {
      table
        .column(0, { search: 'applied', order: 'applied' })
        .nodes()
        .each(function (cell, i) {
          cell.innerHTML = i + 1
        })
    })
    .draw()

  // - - - - - - - - - - M O D A L S - - - - - - - - - -
  // INICIO - MODAL CREATE
  $('#btnCreateModal').click(function () {
    // change value
    document.getElementById('btnCreateUpdate').setAttribute('value', 'Create')
    document.getElementById('btnCreateUpdate').innerHTML = 'Guardar'
    document.getElementById('modalCreateUpdateLabel').innerHTML =
      'Registrar documento de requisito'
    Clearform()
  })
  // FIN - MODAL CREATE

  // INICIO - MODAL UPDATE
  $('#datatableGeneral tbody').on('click', '.editBtn', function (e) {
    //cambiar el text del button
    document.getElementById('btnCreateUpdate').innerHTML = 'Actualizar'
    document.getElementById('modalCreateUpdateLabel').innerHTML =
      'Actualizar documento de requisito'
    // setear data de cargo
    document.getElementById('txt-id').value = $(this).attr('data-id')
    document.getElementById('txt-requirement_id').value = $(this).attr(
      'data-requirement_id'
    )
    document.getElementById('txt-nombre').value = $(this).attr(
      'data-requirement_name'
    )
    // show form
    $('#modalCreateUpdate').modal('show')
    // change value
    document.getElementById('btnCreateUpdate').setAttribute('value', 'Update')
  })
  // FIN - MODAL UPDATE

  var valbtn = ''
  // INICIO - FUNCION CREATE O UPDATE
  $('#btnCreateUpdate').on('click', function (e) {
    // obtener valor del boton
    valbtn = $('#btnCreateUpdate').val()
    // FUNCION CREAR
    if (valbtn === 'Create') {
      // insertar tabla cargo
      store()
    }

    // FUNCION ACTUALIZAR
    if (valbtn === 'Update') {
      // actualizar tabla cargo
      update()
    }
  })
  // FIN - FUNCION CREATE O UPDATE

  // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
  function store() {
    var formData = $('#formModal').serialize()
    $.ajax({
      type: 'POST',
      url: '/docente/requisitos/store',
      data: formData,
      dataType: 'json',
      beforeSend: function () {},
      success: function (data) {
        if (data.status == true) {
          notificaciontoast('info', data.mensaje, 'Éxito!')
          table.ajax.reload()
          $('#modalCreateUpdate').modal('hide')
        } else {
          notificaciontoast('error', data.mensaje, 'Error!')
        }
      },
      error: function (error) {
        console.log('Error', error)
      }
    })
  }

  function update() {
    var id = document.getElementById('txt-id').value
    var formData = new FormData(document.getElementById('formModal'))
    $.ajax({
      type: 'POST',
      url: '/docente/requisitos/update/' + id,
      data: formData,
      processData: false,
      contentType: false,
      beforeSend: function () {},
      success: function (data) {
        if (data.status == true) {
          notificaciontoast('info', data.mensaje, 'Éxito!')
          table.ajax.reload()
          $('#modalCreateUpdate').modal('hide')
          setTimeout(function () {
            document
              .getElementById('formModal')
              .classList.remove('was-validated')
            document.getElementById('formModal').reset()
            document
              .getElementById('btnCreateUpdate')
              .setAttribute('value', 'Registrar')
          }, 500)
        } else {
          notificaciontoast('error', data.mensaje, 'Error!')
        }
      },
      error: function (error) {
        console.log('Error', error)
      }
    })
  }

  // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
  function Clearform() {
    document.getElementById('txt-id').value = ''
    document.getElementById('txt-requirement_id').value = ''
    document.getElementById('txt-documento').value = ''
  }
})
