"use strict";
import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../common/schemas.js";

$(document).ready(function () {
    $.ajax({
        type: "GET",
        url: "/home/docente/dataAsignaturas",
        dataType: "json",
        success: function (response) {
            if (response.status === true) {
                if (response.data.length > 0) {
                    let html = "";
                    let count = 1;
                    response.data.forEach((e) => {
                        let clasesBtn = "d-flex justify-content-center mt-2";
                        if (
                            (e.silabo == null || e.silabo == "--") &&
                            (e.instrumentos_evaluacion == null ||
                                e.instrumentos_evaluacion == "--")
                        ) {
                            clasesBtn = "";
                        }

                        let btnSilabo = `
                            <a href="/verSilabo/${e.idsubject}"
                                class="btn btn-info shadow btn-xs sharp me-4"
                                target="_blank"
                                data-bs-placement="top"
                                title="Ver Silabo">
                                <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        `;
                        if (e.silabo == null || e.silabo == "--") {
                            btnSilabo = "";
                        }

                        let btnInstrumentoEvaluacion = `
                            <a href="/verInstrumentosEvaluacion/${e.idsubject}"
                                class="btn btn-info shadow btn-xs sharp me-4"
                                target="_blank"
                                data-bs-placement="top"
                                title="Ver Instrumento de Evaluación">
                                <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        `;
                        if (
                            e.instrumentos_evaluacion == null ||
                            e.instrumentos_evaluacion == "--"
                        ) {
                            btnInstrumentoEvaluacion = "";
                        }

                        html += `<li>
                                    <div class="timeline-badge info">
                                    </div>
                                    <div class="timeline-panel text-muted cursor-default">
                                        <h4 class="mb-0">${e.curso}</h4>
                                        <h6 class="mb-0">Código: <strong class="text-primary">${e.codcurso}</strong> </h6>
                                        <span><strong class="text-info"> Periodo: ${e.periodo} - Créditos: ${e.creditos} - Horas: ${e.horas} </strong></span>
                                        <p class="mb-0">Periodo Lectivo: ${e.semestre} - Tipo: ${e.tipo_curso}</p>
                                        <div class="${clasesBtn}">
                                            ${btnSilabo}
                                            ${btnInstrumentoEvaluacion}
                                        </div>
                                    </div>
                                </li>`;
                        count++;
                    });
                    document.getElementById("total_asign").innerHTML =
                        "Total: " + count;
                    document.getElementById("list_asignaturas").innerHTML =
                        html;
                }
            }
        },
        error: function (error) {
            console.log("Error", error);
        },
    });

    let tableName = "Estudiante por curso";
    var datatableGeneral = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            type: "GET",
            url: "/home/docente/list_students",
        },
        pageLength: 12, // 12 filas
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            {
                data: "codcurso",
                className: "text-center",
                render: function (data, type, all, meta) {
                    return `<div class="timeline-panel text-muted">
                                <h6 class="mb-0"><strong class="text-primary">Curso: ${all.codcurso} - ${all.curso}</strong> </h6>
                                <span><strong class="text-info">Semestre: ${all.semestre} - Periodo: ${all.periodo} - Horas: ${all.horas} </strong></span>
                                <p class="mb-0">Créditos: ${all.creditos}</p>
                            </div>`;
                },
                name: "primero",
            },
            {
                data: "nroidenti",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    return all.nroidenti;
                },
            },
            {
                data: "nombres",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    return all.nombres;
                },
            },
            {
                data: "apellido_pa",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    return all.apellido_pa;
                },
            },
            {
                data: "apellido_ma",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    return all.apellido_ma;
                },
            },
            {
                data: "correo",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    return all.correo;
                },
            },
        ],
        rowsGroup: ["primero:name"],
        orderFixed: [0, "asc"], // Fija el orden por defecto de la primera columna
    });
});
