import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";

document.addEventListener('DOMContentLoaded', function () {

    var idsemester, idsubject;

    function list_forums(idsubject) {
        $.ajax({
            type: "GET",
            url: "/docente/foros/list/" + idsubject,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                var html = "";
                response.forEach((elemento) => {
                    html += `
                    <li>
                        <div class="timeline-panel">
                            <div class="col-xl-9 col-sm-6">
                                <div class="card schedule-card mb-0">
                                    <div class="card-body px-3 pb-1 pt-1">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <ul class="list-unstyled">
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-solid fa-book fa-lg" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    <b class="text-md text-primary">${elemento.titulo}</b>
                                                </li>
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-regular fa-calendar-days fa-lg mr-2" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    Inicio: ${elemento.fecinicio2}
                                                </li>
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-regular fa-calendar-days fa-lg mr-2" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    Fin: ${elemento.fecfin2}
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6 d-flex justify-content-center align-items-center">
                                <div class="file-list">
                                    
                                    <a href="javascript:void(0);" class="viewBtn btn btn-primary shadow btn-xs sharp me-2"
                                        data-idforum="${elemento.idforum}"
                                        data-titulo="${elemento.titulo}"
                                        data-descripcion="${elemento.descripcion}"
                                        data-fecinicio="${elemento.fecinicio}"
                                        data-fecfin="${elemento.fecfin}"
                                        data-autor="${elemento.autor}"
                                        data-fecha_mod="${elemento.fecha_mod}"
                                        data-bs-placement="top"
                                        title="Ver Foro">
                                        <i class="fa-solid fa-eye fa-lg"></i>
                                    </a>
                                    
                                    <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-2"
                                        data-idforum="${elemento.idforum}"
                                        data-titulo="${elemento.titulo}"
                                        data-descripcion="${elemento.descripcion}"
                                        data-fecinicio="${elemento.fecinicio}"
                                        data-fecfin="${elemento.fecfin}"
                                        data-autor="${elemento.autor}"
                                        data-fecha_mod="${elemento.fecha_mod}"
                                        data-bs-placement="top"
                                        title="Editar Foro">
                                        <i class="fas fa-pencil-alt"></i>
                                    </a>
                                    
                                    <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp me-2"
                                        data-idforum="${elemento.idforum}"
                                        data-bs-placement="top"
                                        title="Eliminar Foro">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>`;
                })
                document.getElementById("list_foros").innerHTML = html;
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function list_forum_answers(idforum) {
        $.ajax({
            type: "GET",
            url: "/docente/respuestas_foros/list/" + idforum,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                var html = "";
                var cont = 1;
                response.forEach((elemento) => {
                    if (cont == 1) {
                        html += `<a href="javascript:void(0);" class="list-group-item list-group-item-action flex-column align-items-start rounded-0">`;
                    } else {
                        html += `<a href="javascript:void(0);" class="list-group-item list-group-item-action flex-column align-items-start">`;
                    }
                    html += `<div class="d-flex w-100 justify-content-between">
                                <h5 class="mb-3">${elemento.estudiante}</h5>
                                <small>Modificado hace ${elemento.dias_transcurridos} días</small>
                            </div>
                            <textarea class="form-control" rows="3" readonly>${elemento.comentario}</textarea>
                        </a>`;
                    cont++;
                })
                document.getElementById("list_respuestas").innerHTML = html;
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    $(document).on("change", "#txt-semestre", function () {
        idsemester = $(this).val();
        idsubject = "0";
        $("#text_asignatura").val("");
        cb_subjects(idsemester);
        list_forums(idsubject);
        list_forum_answers(0);

        $("#txt-autor").html("");
        $("#txt-titulo").html("");
        $("#txt-fecha_mod").html("");
        $("#txt-descripcion").val($(this).data(""));
    });

    $(document).on("change", "#txt-asignatura", function () {
        idsubject = $(this).val();
        var curso = $('option:selected', this).data('namecurso');
        $("#dt-subject_id").val(idsubject);
        $("#text_asignatura").val(curso);
        list_forums(idsubject);
        list_forum_answers(0);

        $("#txt-autor").html("");
        $("#txt-titulo").html("");
        $("#txt-fecha_mod").html("");
        $("#txt-descripcion").val($(this).data(""));
    });



    // INICIO - MODAL VIEW
    $("#list_foros").on("click", ".viewBtn", function (e) {
        let idforum = $(this).data("idforum");
        $("#txt-autor").html("Autor: " + $(this).data("autor"));
        $("#txt-titulo").html("Titulo del Tema: " + $(this).data("titulo"));
        $("#txt-fecha_mod").html("Ultima modificación: " + $(this).data("fecha_mod"));
        $("#txt-descripcion").val($(this).data("descripcion"));

        list_forum_answers(idforum);
    });
    // FIN - MODAL VIEW

    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        $("#btnCreateUpdate").attr("value", "Create");
        $("#btnCreateUpdate").html("Registrar");
        $("#modalCreateUpdateLabel").html("Registrar datos del Foro");
        // clearCheck();
        clearForm();
        $("#modalCreateUpdate").modal("show");
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#list_foros").on("click", ".editBtn", function () {
        //cambiar el text del button
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar datos del Foro");
        // setear data de usuario
        $("#dt-idforum").val($(this).data("idforum"));
        $("#dt-subject_id").val($(this).data("subject_id"));
        $("#dt-titulo").val($(this).data("titulo"));
        $("#dt-descripcion").val($(this).data("descripcion"));
        $("#dt-fecinicio").val($(this).data("fecinicio"));
        $("#dt-fecfin").val($(this).data("fecfin"));
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        $("#btnCreateUpdate").attr("value", "Update");
    });
    // FIN - MODAL UPDATE

    // INICIO - MODAL DELETE
    $("#list_foros").on("click", ".deleteBtn", function (e) {
        let idforum = $(this).data("idforum")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(idforum);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE

    var formCheck, valbtn;
    $('#btnCreateUpdate').on('click', function (event) {
        valbtn = $("#btnCreateUpdate").val();
        // FUNCION CREAR
        if (valbtn === "Create") {
            // insertar
            store();
        }
        // FUNCION ACTUALIZAR
        if (valbtn === "Update") {
            // actualizar
            update($("#dt-idforum").val());
        }
    });



    //--------- F U N C I O N E S --------------//
    cb_semesters();
    function cb_semesters() {
        $("#txt-semestre").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/semestersDocentes',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-semestre").append('<option selected disabled value="">Selecciona un periodo lectivo</option>');
                response.forEach((elemento) => {
                    $("#txt-semestre").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-anho="' + elemento.anho + '" ' +
                        ' data-numero="' + elemento.numero + '" ' +
                        ' data-fecinicio="' + elemento.fecinicio + '" ' +
                        ' data-fecfin="' + elemento.fecfin + '" ' +
                        '>' + elemento.anho + " - " + elemento.numero + '</option>');
                })
                $("#txt-semestre").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function cb_subjects(idsemester) {
        $("#txt-asignatura").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: "/docente/materiales_recursos/ajax_all/asignaturas/" + idsemester,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-asignatura").append('<option selected disabled value="">Selecciona una asignatura</option>');
                response.forEach((elemento) => {
                    $("#txt-asignatura").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-namecurso="' + elemento.namecurso + '" ' +
                        '>' + elemento.namecurso + " - Sec:" + elemento.seccion + '</option>');
                })
                $("#txt-asignatura").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    var formData;
    function store() {
        var formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/docente/foros/store',
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                // Validators
                if (data.status == 'validators') {
                    for (var campo in data.mensaje) {
                        if (data.mensaje.hasOwnProperty(campo)) {
                            var mensajes = data.mensaje[campo];
                            for (var i = 0; i < mensajes.length; i++) {
                                var mensaje = mensajes[i];
                                // console.log("campo: " + campo + ", mensaje: " + mensaje);
                                notificaciontoast("error", mensaje, "Error!", "bottom-right", 3000);
                            }
                        }
                    }
                }
                if (data.status == true) {
                    notificaciontoast('info', data.mensaje, 'Éxito!')
                    $("#modalCreateUpdate").modal("hide");
                    list_forums(idsubject);
                } else if (data.status == false) {
                    notificaciontoast('error', data.mensaje, 'Error!')
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function update(idforum) {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/docente/foros/update/' + idforum,
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                if (data.status == true) {
                    // formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                    list_forums(idsubject);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function destroy(idforum) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/docente/foros/delete/' + idforum,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    list_forums(idsubject);
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function clearForm() {
        $("#dt-idforum").val("");
        $("#dt-titulo").val("");
        $("#dt-descripcion").val("");
        $("#dt-fecinicio").val("");
        $("#dt-fecfin").val("");
    }
});
