//"use strict";
import { notificaciontoast } from '../common/method_toast.js'
import { confirmation_sweetAlert } from '../common/method_sweetAlert.js'

$(document).ready(function () {
  const tableName = 'General de Horarios'

  //LISTAR DATATABLE
  var dt_idsemester = 0,
    dt_idsubject = 0,
    dt_idclass = 0

  var table = $('#datatableGeneral').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    ajax: {
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: 'POST',
      url: '/docente/asistencias/list_students',
      data: function (d) {
        d.idsemester = dt_idsemester,
				d.idsubject = dt_idsubject,
				d.idsubjectclass = dt_idclass
      }
    },
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacia.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    buttons: [
      {
        extend: 'excel',
        title: function () {
          return 'Reporte de Horarios ' + semester
        },
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'pdf',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded ',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'print',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'colvis',
        text: 'Seleccionar celdas',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      }
    ],
    columns: [
      { data: 'identificacion', className: 'text-center bg-primary' },
      { data: 'estudiante', className: 'text-center bg-primary' },
      {
        data: 'estado_asistencia',
        sortable: false,
        className: 'text-center',
        render: function (data, type, all, meta) {
          if (all.estado_asistencia == '0') {
            return `<span class="badge light badge-dark">Sin evaluar</span>`
          } else if (all.estado_asistencia == '1') {
            return `<span class="badge light badge-success">Asistio</span>`
          } else if (all.estado_asistencia == '2') {
            return `<span class="badge light badge-warning">Tardanza</span>`
          } else if (all.estado_asistencia == '3') {
            return `<span class="badge light badge-danger">No Asistio</span>`
          }
        }
      },
      {
        data: 'estado_clase',
        sortable: false,
        className: 'text-center noExport',
        render: function (data, type, all, meta) {
          if (all.estado_asistencia == '0') {
            return `
							<i class="fa-solid fa-circle" aria-hidden="true"></i>
							<select class="editBtn default-select"
								data-idattendance="${all.idattendance}"
								data-idsubjectenrollment="${all.idsubjectenrollment}"
								data-idsubjectclass="${all.idsubjectclass}"
								data-estado_asistencia="0"
							>
								<option selected value="0">Seleccionar</option>
								<option value="1">Asistió</option>
								<option value="2">Tardanza</option>
								<option value="3">No Asistió</option>
							</select>
							`
          } else if (all.estado_asistencia == '1') {
            return `
							<i class="fa-solid fa-circle text-success" aria-hidden="true"></i>
							<select class="editBtn default-select"
								data-idattendance="${all.idattendance}"
								data-idsubjectenrollment="${all.idsubjectenrollment}"
								data-idsubjectclass="${all.idsubjectclass}"
								data-estado_asistencia="1"
							>
								<option selected value="1">Asistió</option>
								<option value="2">Tardanza</option>
								<option value="3">No Asistió</option>
							</select>
							`
          } else if (all.estado_asistencia == '2') {
            return `
							<i class="fa-solid fa-circle text-warning" aria-hidden="true"></i>
							<select class="editBtn default-select"
								data-idattendance="${all.idattendance}"
								data-idsubjectenrollment="${all.idsubjectenrollment}"
								data-idsubjectclass="${all.idsubjectclass}"
								data-estado_asistencia="2"
							>
								<option value="1">Asistió</option>
								<option selected value="2">Tardanza</option>
								<option value="3">No Asistió</option>
							</select>
							`
          } else if (all.estado_asistencia == '3') {
            return `
							<i class="fa-solid fa-circle text-danger" aria-hidden="true"></i>
							<select class="editBtn default-select"
								data-idattendance="${all.idattendance}"
								data-idsubjectenrollment="${all.idsubjectenrollment}"
								data-idsubjectclass="${all.idsubjectclass}"
								data-estado_asistencia="3"
							>
								<option value="1">Asistió</option>
								<option value="2">Tardanza</option>
								<option selected value="3">No Asistió</option>
							</select>
							`
          }
        }
      }
    ]
  })

  //--------- F U N C I O N E S --------------//
  function tl_subjects(idsemester) {
    $.ajax({
      type: 'GET',
      url: '/docente/materiales_recursos/ajax_all/asignaturas/' + idsemester,
      dataType: 'json',
      beforeSend: function () {},
      success: function (response) {
        response.forEach((elemento) => {
          document.getElementById('tlsubject').innerHTML += `
            <li>
              <div class='divsubject timeline-badge primary'></div>
              <a class='btnSubject timeline-panel text-muted px-2 py-1 mr-4 ml-2'
                href='javascript:void(0);'
                data-idsubject='${elemento.id}'
                data-codcurso='${elemento.codcurso}'
                data-curso='${elemento.namecurso}'
                data-seccion='${elemento.seccion}'>
                <h6 class='mb-0 fs-14'>
                  <strong class='text-dark'>${elemento.namecurso}</strong>
                  <br>Sección: ${elemento.seccion}
                </h6>
              </a>
            </li>
          `
        })
      },
      error: function (error) {
        console.log('Error', error)
      }
    })
  }

  // Variable para almacenar el controlador de abortar
  let abortController = null

  // listar subjectclasses con cancelación de la solicitud anterior
  function tl_subjectclasses(idsubject) {
    if (abortController) {
      abortController.abort()
    }

    abortController = new AbortController()
    const signal = abortController.signal

    $('.btnSubject').prop('disabled', true).addClass('disabled')

    $('#login-loader').show()
    $('#login-loader').css('display', '')
    $('#login-loader').css('display', 'flex')
    $('#tlsubjectclass-container').addClass('loading')

    $.ajax({
      type: 'GET',
      url: '/ajax_all/teachers/subjectclasses/' + idsubject,
      dataType: 'json',
      signal: signal,
      success: function (response) {
        $('#tlsubjectclass').html('')
        const promises = response.map((elemento) => {
          let zoomButtons =
            elemento.id_zoom_meeting && elemento.id_zoom_meeting.trim() !== ''
              ? `
								<button class="btn btn-success btn-sm mx-1"
										onclick="joinZoomMeeting('${elemento.id_zoom_meeting}')"
										title="Unirse a la reunión">
									<i class="fas fa-play"></i>
								</button>
								<button class="btn btn-danger btn-sm mx-1"
										data-toggle="modal"
										data-target="#deleteConfirmationModal"
										onclick="confirmDeleteZoomMeeting('${elemento.id_zoom_meeting}', '${elemento.idclass}', '${elemento.idsubject}')"
										title="Eliminar esta reunión">
									<i class="fas fa-trash-alt"></i>
								</button>`
              : `
								<button class="btn btn-light btn-sm mx-1"
										onclick="preFillCreateMeetingModal('${elemento.fecha}', '${elemento.horaini}', '${elemento.duracion}',
										'${elemento.account_id}', '${elemento.client_id}', '${elemento.client_secret}', '${elemento.id}',
										'${elemento.apellido_pa}', '${elemento.apellido_ma}', '${elemento.nombres}', '${elemento.clase}',
										'${elemento.dia}', '${elemento.nombre_curso}', '${elemento.idclass}')"
										title="Crear una nueva reunión">
									<i class="bi bi-camera-video-fill"></i><i class="bi bi-plus"></i>
								</button>`

          return `
						<li class="d-flex flex-wrap align-items-center mb-3">
							<div class='divsubjectclass timeline-badge primary'></div>
							<a class='btnSubjectclass timeline-panel text-muted px-2 py-1 mr-4 ml-2 d-flex flex-wrap align-items-center w-100'
								href='javascript:void(0);'
								data-idclass='${elemento.idclass}'
								data-dia='${elemento.dia}'
								data-horaini='${elemento.horaini}'
								data-horafin='${elemento.horafin}'>
								<h6 class='mb-0 fs-14'>
									<strong class='text-dark'>${elemento.clase} - ${elemento.dia}</strong><br>
									${elemento.horaini2} - ${elemento.horafin2}
								</h6>
								<div class="zoom-card d-flex flex-column justify-content-center align-items-center p-2 ml-auto"
									style="margin-left: auto; background-color: #2D8CFF; border-radius: 10px; min-width: 120px;">
									<p class="text-white font-weight-bold mb-2">Zoom</p>
									<div class="d-flex justify-content-around w-100">
										${zoomButtons}
									</div>
								</div>
							</a>
						</li>`
        })

        Promise.all(promises).then((results) => {
          $('#tlsubjectclass').html(results.join(''))
          $('#login-loader').hide()
          $('#login-loader').css('display', '')
          $('#login-loader').css('display', 'none')

          $('#tlsubjectclass-container').removeClass('loading')

          $('.btnSubject').prop('disabled', false).removeClass('disabled')
        })
      },
      error: function (error) {
        if (error.name !== 'AbortError') {
          console.error('Error en la solicitud AJAX de clases', error)
        }
        $('#login-loader').hide()
        $('#login-loader').css('display', '')
        $('#login-loader').css('display', 'none')
        $('#tlsubjectclass-container').removeClass('loading')

        $('.btnSubject').prop('disabled', false).removeClass('disabled')
      }
    })
  }

  // on change semestres
  $(document).on('click', '.btnSemester', function () {
    dt_idsemester = $(this).attr('data-idsemester')
    $('.divsemester').removeClass('dark').addClass('primary')
    $(this).prev('div').removeClass('primary').addClass('dark')
    notificaciontoast('info', 'Consultando a la base de datos!', 'Mensaje!')

    // Limpiar los cursos antes de agregar los nuevos
    document.getElementById('tlsubject').innerHTML = '' // Limpiar la lista de cursos

    tl_subjects(dt_idsemester) // Cargar los nuevos cursos para el periodo
    table.ajax.reload() // Recargar la tabla
  })

  // on change asignaturas
  let currentSubjectId = null

  $(document).on('click', '.btnSubject', function () {
    currentSubjectId = $(this).data('idsubject') // Guardamos el idsubject
    $('.divsubject').removeClass('dark').addClass('primary')
    $(this).prev('div').removeClass('primary').addClass('dark')
    document.getElementById('tlsubjectclass').innerHTML = ''
    tl_subjectclasses(currentSubjectId) // Pasamos el idsubject cuando se selecciona
    table.ajax.reload() // Recargar la tabla
  })

  // on change clases_asignaturas
  $(document).on('click', '.btnSubjectclass', function () {
    dt_idclass = $(this).attr('data-idclass')
    $('.divsubjectclass').removeClass('dark').addClass('primary')
    $(this).prev('div').removeClass('primary').addClass('dark')
    // limpiar tabla
    table.ajax.reload()
  })

  $('#datatableGeneral tbody').on('change', '.editBtn', async function (e) {
    document.getElementById('txt-idsubjectclass').value = $(this).attr('data-idsubjectclass')
    document.getElementById('txt-idsubjectenrollment').value = $(this).attr('data-idsubjectenrollment')
    document.getElementById('txt-estado_asistencia').value = $(this).val()

    var id = $(this).attr('data-idattendance')

    var formData = $('#formModal').serialize()
    $.ajax({
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: 'PUT',
      url: '/docente/asistencias/update/' + id,
      data: formData,
      dataType: 'json',
      beforeSend: function () {},
      success: function (data) {
        if (data.status == true) {
          table.ajax.reload()
          notificaciontoast('info', data.mensaje, 'Éxito!')
        } else {
          notificaciontoast('error', data.mensaje.txt_idrol_name[0], 'Error!')
        }
      },
      error: function (error) {
        console.log('Error', error)
      }
    })
  })

  //on delete metting
  $(document).ready(function () {
    // Configurar un intervalo para monitorear el estado de la eliminación
    setInterval(function () {
      if (window.deleteSuccess) {
        // Restablecer el estado de eliminación para evitar llamadas repetidas
        window.deleteSuccess = false

        // Llamar a la función para actualizar la lista de clases
        if (typeof tl_subjectclasses === 'function') {
          tl_subjectclasses(currentSubjectId)
        }
      }
    }, 1000) // Revisar cada segundo
  })

  //on success create meeting
  window.createSuccess = false

  $(document).ready(function () {
    // Monitorear el estado de creación exitosa
    setInterval(function () {
      if (window.createSuccess) {
        window.createSuccess = false // Resetear el estado para evitar repeticiones

        // Ejecutar la actualización de clases
        if (typeof tl_subjectclasses === 'function') {
          tl_subjectclasses(currentSubjectId)
        } else {
          console.warn('La función tl_subjectclasses no está definida.')
        }
      }
    }, 1000) // Revisión cada segundo
  })
})
