//"use strict";
import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../common/schemas.js";


$(document).ready(function () {
    const tableName = "Notas ";
    var dt_idsubject = "null",
        dt_idstudent = "null";

    // LISTAR DATATABLE CURSOS
    var table_cursos = $("#datatableGeneralCursos").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/docente/notas/list_cursos",
        },

        searching: false,
        // dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        columns: [
            { data: "programa", className: "text-center bg-primary", sortable: false },
            { data: "plan", className: "text-center bg-primary", sortable: false },
            { data: "periodo", className: "text-center bg-primary", sortable: false },
            { data: "codcurso", className: "text-center bg-primary", sortable: false },
            { data: "curso", className: "text-center bg-primary", sortable: false },
            { data: "tipo", className: "text-center bg-primary", sortable: false },
            { data: "creditos_horas", className: "text-center bg-primary", sortable: false },
            { data: "condicion", className: "text-center bg-primary", sortable: false },
            { data: "seccion", className: "text-center bg-primary", sortable: false },
            { data: "turno", className: "text-center bg-primary", sortable: false },
            { data: "accion", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">
                                <a href="javascript:void(0);" class="viewsSchedulingCalendarBtn btn btn-info shadow btn-xs sharp me-1"
                                data-idsubject="${all.idsubject}"
                                data-idteacher="${all.idteacher}"
                                data-programa="${all.programa}"
                                data-plan="${all.plan}"
                                data-periodo="${all.periodo}"
                                data-curso="${all.curso}"
                                data-bs-placement="top"
                                title="Ver Evaluaciones">
                                <i class="fa-solid fa-eye fa-fade fa-xl"></i>
                                </a>
                            </div>
                            `;
                },
            },
        ],
    });


    // Ver cursos
    $("#datatableGeneralCursos tbody").on("click", ".viewsSchedulingCalendarBtn", function (e) {
        dt_idsubject = $(this).data("idsubject");
        $("#data-programa").val($(this).data("programa"));
        $("#data-plan").val($(this).data("plan"));
        $("#data-periodo").val($(this).data("periodo"));
        $("#data-curso").val($(this).data("curso"));
        table_promedios.ajax.reload();
    });


    // LISTAR DATATABLE NOTAS
    var table_promedios = $("#datatableGeneralPromedios").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [], 
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/docente/promedios/list_promedios",
            data: function (d) {
                d.idsubject = dt_idsubject;
            }
        },
        searching: true,
        // dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        columns: [
            { data: "idstudent", className: "text-center bg-primary", sortable: false },
            { data: "identificacion", className: "text-center bg-primary", sortable: false },
            { data: "estudiante", className: "text-center bg-primary", sortable: false },
            { data: "idstudent", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return `
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btnViewEvaluations btn btn-success shadow btn-xs sharp"
                            data-idstudent="${all.idstudent}"
                            data-estudiante="${all.estudiante}"
                            data-idsubject="${all.idsubject}"
                            data-bs-placement="top"
                            title="Ver Evaluaciones">
                            <i class="fa-solid fa-eye fa-fade fa-xl"></i>
                        </a>
                    </div>
                    `;
                },
            },
            { data: "promedio_final", className: "text-center bg-primary", sortable: false },
            { data: "promedio_final", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    if (all.promedio_final == 0) {
                        return `<span class="badge light badge-dark">Sin Evaluar</span>`;
                    } else if (all.promedio_final < 12.5) {
                        return `<span class="badge light badge-danger">Desaprobado</span>`;
                    } else if (all.promedio_final >= 12.5){
                        return `<span class="badge light badge-success">Aprobado</span>`;
                    }
                },
            },
        ],
    });


    // Agregar una columna de números automáticos
    table_promedios.on('order.dt search.dt', function () {
        table_promedios.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();


    // INICIO - MODAL VER CURSOS
    $("#datatableGeneralPromedios tbody").on("click", ".btnViewEvaluations", function (e) {
        dt_idstudent = $(this).data("idstudent");
        document.getElementById("modalDetalleNotasLabel").innerHTML = "Detalle notas del alumno: " + $(this).data("estudiante")
        // cargar tabla
        table_evaluations.ajax.reload();
        setTimeout(function () { $("#modalDetalleNotas").modal("show"); }, 500); // mostrar despues de x sec
        // mostrar modal
    });
    // FIN - MODAL VER CURSOS


    // LISTAR DATATABLE 2
    var table_evaluations = $('#datatableGeneralEvaluaciones').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/docente/promedios/list_promedio_estudiante',
            data: function (d) {
                d.idstudent = dt_idstudent,
                d.idsubject = dt_idsubject;
            },
        },
        searching: false,
        paging: false, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 12, // 12 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            { data: "prom_final", sortable: false, className: "text-center", name: 'primero',
                render: function (data, type, all, meta) {
                    return `
                        <h4>Promedio Final</h4>
                        <h4>${all.prom_final}</h4>
                    `;
                },
            },
            { data: "indicador", sortable: false, className: "text-center", name: 'primero',
                render: function (data, type, all, meta) {
                    return `
                        <h6>${all.indicador}</h6>
                        <b>Promedio: ${all.prom_indicador}</b>
                    `;
                },
            },
            { data: "actividad", sortable: false, className: "text-center", name: 'segundo',
                render: function (data, type, all, meta) {
                    if (all.actividad == "--") {
                        return `
                            --
                        `;
                    } else {
                        return `
                            <h6>${all.actividad}</h6>
                            <b>Promedio: ${all.prom_actividad}</b>
                        `;
                    }
                },
            },
            { data: "porcentaje", sortable: false, className: "text-center", name: 'tercero',
                render: function (data, type, all, meta) {
                    if (all.nombre_nota == "--") {
                        return `
                            --
                        `;
                    } else {
                        return `
                            <h6>${all.nombre_nota} (${all.porcentaje*100}%)</h6>
                            <b>Promedio: ${all.nota_estudiante}</b>
                        `;
                    }
                },
            },
        ],
        rowsGroup: [
            'primero:name',
            'segundo:name',
            'tercero:name',
        ],
    });


    // // Agregar una columna de números automáticos
    // table_evaluations.on('order.dt search.dt', function () {
    //     table_evaluations.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
    //         cell.innerHTML = i + 1;
    //     });
    // }).draw();


    $(document).on("click", "#btnCertificado", function () {
        setTimeout(function () {
            window.open('/reportes/certificado', '_blank');
        }, 2000);
    });

    // REPORTE DE LOS CURSOS LLEVADOS DEL ALUMNO POR PERIODO LECTIVO
    $(document).on("click", "#btnPromedioAsignatura", function () {
        setTimeout(function () {
            window.open('/reportes/acta_oficial_notas/'+ dt_idsubject, '_blank');
        }, 2000);
    });

        // REPORTE DE LOS CURSOS LLEVADOS DEL ALUMNO POR PERIODO LECTIVO
        $(document).on("click", "#btnActaAuxiliar", function () {
            setTimeout(function () {
                window.open('/reportes/acta_auxiliar_notas/'+ dt_idsubject, '_blank');
            }, 2000);
        });

    //REPORTE DE LOS CURSOS LLEVADOS DEL ALUMNO POR PERIODO LECTIVO
    $(document).on("click", "#btnPromedioAlumno", function () {
        setTimeout(function () {
            window.open('/reportes/promedio_asignaturas/'+dt_idstudent+'/'+dt_idsemester, '_blank');
        }, 2000);
    });

});
