//"use strict";
import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../common/schemas.js";

$(document).ready(function () {
    const tableName = "Notas ";
    var dt_idsubject = 0,
        dt_idgrade = 0,
        dt_idteacher = 0;


    // LISTAR DATATABLE CURSOS
    var table_cursos = $("#datatableGeneralCursos").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/docente/notas/list_cursos",
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "programa", className: "text-center bg-primary", sortable: false },
            { data: "plan", className: "text-center bg-primary", sortable: false },
            { data: "periodo", className: "text-center bg-primary", sortable: false },
            { data: "codcurso", className: "text-center bg-primary", sortable: false },
            { data: "curso", className: "text-center bg-primary", sortable: false },
            { data: "tipo", className: "text-center bg-primary", sortable: false },
            { data: "creditos_horas", className: "text-center bg-primary", sortable: false },
            { data: "condicion", className: "text-center bg-primary", sortable: false },
            { data: "seccion", className: "text-center bg-primary", sortable: false },
            { data: "turno", className: "text-center bg-primary", sortable: false },
            { data: "accion", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">
                                <a href="javascript:void(0);" class="viewIndicatorsBtn btn btn-info shadow btn-xs sharp me-1"
                                data-idsubject="${all.idsubject}"
                                data-idteacher="${all.idteacher}"
                                data-programa="${all.programa}"
                                data-plan="${all.plan}"
                                data-periodo="${all.periodo}"
                                data-curso="${all.curso}"
                                data-bs-placement="top"
                                title="Editar nota">
                                <i class="fa-solid fa-eye fa-fade fa-xl"></i>
                                </a>
                            </div>
                            `;
                },
            },
        ],
    });



    // Ver cursos
    $("#datatableGeneralCursos tbody").on("click", ".viewIndicatorsBtn", function (e) {
        dt_idsubject = $(this).data("idsubject");
        dt_idteacher = $(this).data("idteacher");
        $("#data-programa").val($(this).data("programa"));
        $("#data-plan").val($(this).data("plan"));
        $("#data-periodo").val($(this).data("periodo"));
        $("#data-curso").val($(this).data("curso"));
        table_indicadores.ajax.reload();
    });







// LISTAR DATATABLE CURSOS
var table_indicadores = $("#datatableGeneralIndicadores").DataTable({
    createdRow: function (row, data, index) {
        $(row).addClass("selected");
    },
    order: [],
    ajax: {
        headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
        type: "POST",
        url: "/docente/notas/list_indicadores",
        data: function (d) {
            d.idsubject = dt_idsubject;
        },
    },
    searching: true,
    dom: "Bfrtip",
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
        search: 'Buscar',
        info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
        zeroRecords: 'No hay registros para mostrar.',
        infoFiltered: '(Filtrados de _MAX_ Registros)',
        emptyTable: 'La tabla está vacia.',
        infoEmpty: 'No hay registros',
        paginate: {
            next: '<i class="fa-solid fa-angle-right"></i>',
            previous: '<i class="fa-solid fa-angle-left"></i>'
        }
    },
    buttons: [
        {
            extend: "excel",
            title: function () {
                return (
                    "Reporte de Horarios " + semester
                );
            },
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                orthogonal: "print",
            },
        },
        {
            extend: "pdf",
            title: "Reporte de " + tableName,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded ",
            exportOptions: {
                columns: ":visible",
                orthogonal: "print",
            },
        },
        {
            extend: "print",
            title: "Reporte de " + tableName,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                orthogonal: "print",
            },
        },
        {
            extend: "colvis",
            text: "Seleccionar celdas",
            title: "Reporte de " + tableName,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                orthogonal: "print",
            },
        },
    ],
    columns: [
        { data: "indicador", className: "text-center", name: "primero",
            render: function (data, type, all, meta) {
                return "<h6>" + all.indicador + "</h6>"
            },
        },
        { data: "actividad", className: "text-center bg-dark", name: "tercero",
            render: function (data, type, all, meta) {
                return "<h6>" + all.actividad + "</h6>"
            },
        },
        { data: "nota", className: "text-center",
            render: function (data, type, all, meta) {
                if (all.idgrade != 0) {
                return "<h6>" + all.nota + " - " + (all.porcentaje * 100) + "%</h6>";
                } else {
                    return ``;
                }
            },
        },
        { data: "accion", className: "text-center noExport", sortable: false, searchable: false,
            render: function (data, type, all, meta) {
                return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="viewStudentsBtn btn btn-info shadow btn-xs sharp me-1"
                            data-idcourse="${all.idcourse}"
                            data-idsubject="${all.idsubject}"
                            data-idteacher="${all.idteacher}"
                            data-idindicator="${all.idindicator}"
                            data-indicador="${all.indicador}"
                            data-idactivity="${all.idactivity}"
                            data-actividad="${all.actividad}"
                            data-idgrade="${all.idgrade}"
                            data-nota="${all.nota}"
                            data-idgradetype="${all.idgradetype}"
                            data-tipo_nota="${all.tipo_nota}"
                            data-bs-placement="top"
                            title="Ver Alumno">
                            <i class="fa-solid fa-eye fa-fade fa-xl"></i>
                            </a>
                        </div>
                    `;
            },
        },
    ],
    rowsGroup: [
        'primero:name',
        'tercero:name'
    ],
});

// table_estudiantes.on('order.dt search.dt', function () {
//     table_estudiantes.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
//         cell.innerHTML = i + 1;
//     });
// }).draw();

// Ver cursos
$("#datatableGeneralIndicadores tbody").on("click", ".viewStudentsBtn", function (e) {
    dt_idgrade = $(this).data("idgrade");
    $("#data-indicador").val($(this).data("indicador"));
    $("#data-actividad").val($(this).data("actividad"));
    $("#data-tipo_nota").val($(this).data("tipo_nota"));
    $("#data-nota").val($(this).data("nota"));
    table_estudiantes.ajax.reload();
    });











    // LISTAR DATATABLE NOTAS
    var table_estudiantes = $("#datatableGeneralEstudiantes").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/docente/notas/list_estudiantes",
            data: function (d) {
                d.idgrade = dt_idgrade;
                d.idteacher = dt_idteacher;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: [
            {
                extend: "excel",
                title: function () {
                    return (
                        "Reporte de Horarios " + semester
                    );
                },
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                text: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            // { data: "n", className: "text-center bg-primary", sortable: false },
            { data: "identificacion", className: "text-center bg-primary", sortable: false },
            { data: "estudiante", className: "text-center bg-primary", sortable: false },
            { data: "nota_estudiante", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.nota_estudiante == null) {
                        return "<h6>Sin nota</h6>"
                    } else {
                        return "<h6>" + all.nota_estudiante + "</h6>"
                    }
                },
            },
            { data: "idstudentgrade", className: "text-center noExport", sortable: false,
                searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                    data-identificacion="${all.identificacion}"
                                    data-estudiante="${all.estudiante}"
                                    data-curso="${all.curso}"
                                    data-idstudentgrade="${all.idstudentgrade}"
                                    data-idsubjectenrollment="${all.idsubjectenrollment}"
                                    data-idgrade="${all.idgrade}"
                                    data-nombre_nota="${all.nombre_nota}"
                                    data-nota_estudiante="${all.nota_estudiante}"
                                    data-bs-placement="top"
                                    title="Editar nota">
                                    <i class="fas fa-pencil-alt"></i>
                                </a>

                            </div>

                            `;
                },
            },
        ],
    });


    // Editar Nota
    $("#datatableGeneralEstudiantes tbody").on("click", ".editBtn", function (e) {

        $("#txt-idstudentgrade").val($(this).data("idstudentgrade"));
        $("#txt-idgrade").val($(this).data("idgrade"));
        $("#txt-idsubjectenrollment").val($(this).data("idsubjectenrollment"));
        $("#txt-curso").val($(this).data("curso"));
        $("#txt-estudiante").val($(this).data("estudiante"));
        $("#txt-nombre_nota").val($(this).data("nombre_nota"));
        $("#txt-nota_estudiante").val($(this).data("nota_estudiante"));

        // show form
        $("#modalCreateUpdate").modal("show");
    });



    var formCheck;

    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
        } else {
            // actualizar
            update_nota();
        }
    });
    // FIN - FUNCION CREATE O UPDATE

    var formModal;

    function update_nota() {
        formModal = $('#formModal');
        var idstudentgrade = document.getElementById("txt-idstudentgrade").value;
        var idsubjectenrollment = document.getElementById("txt-idsubjectenrollment").value;
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/docente/notas/gestionar_nota/update_nota/' + idstudentgrade + '/' + idsubjectenrollment,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () {
                $('#btnCreateUpdate').addClass('disabled');
            },
            success: function (data) {
                if (data.status == true) {
                    table_estudiantes.ajax.reload();
                    formModal.addClass("was-validated");
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                        $('#btnCreateUpdate').removeClass('disabled');
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    $('#btnCreateUpdate').removeClass('disabled');
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        });
    }

});
