let calendar = null
let dt_idsemester = 0

$(document).ready(function () {
  // 1. Inicializar calendario
  const calendarEl = document.getElementById('calendar')

  calendar = new FullCalendar.Calendar(calendarEl, {
    locale: 'es',
    initialView: 'timeGridWeek',
    height: 'auto',
    allDaySlot: false,

    headerToolbar: {
      left: 'prev,next today',
      center: 'title',
      right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
    },

    buttonText: {
      today: 'Hoy',
      month: 'Mes',
      week: 'Semana',
      day: 'Día',
      list: 'Lista'
    },

    slotMinTime: '00:00:00',
    slotMaxTime: '24:00:00',

    events: [],

    eventClick(info) {
      const e = info.event
      const props = e.extendedProps || {}

      // Siempre mostramos título y fechas
      $('#event-title').text(e.title)
      $('#event-start').text(e.start ? e.start.toLocaleString() : '--')
      $('#event-end').text(e.end ? e.end.toLocaleString() : '--')

      // Reset: mostrar todo lo de curso y ocultar la parte de foro
      $('#group-programa').show()
      $('#group-plan-aula').show()
      $('#group-turno-seccion').show()
      $('#group-condicion').show()
      $('#group-foro-descripcion').addClass('d-none')
      $('#event-descripcion-foro').text('')

      if (props.tipoEvento === 'foro') {
        // 👉 Evento de FORO
        $('#event-modal-title').text('Detalle del foro')

        // Estos datos no aplican a foros, los escondemos
        $('#group-programa').hide()
        $('#group-plan-aula').hide()
        $('#group-turno-seccion').hide()

        // Condición: simplemente mostramos "Foro"
        $('#event-condicion').text('Foro')

        // Mostrar descripción del foro, si existe
        $('#group-foro-descripcion').removeClass('d-none')
        $('#event-descripcion-foro').text(props.descripcion ?? '')
      } else {
        // 👉 Evento de CLASE (como ya lo tenías)
        $('#event-modal-title').text('Detalle del curso')

        $('#event-programa').text(props.programa ?? '')
        $('#event-plan').text(props.plan ?? '')
        $('#event-aula').text(props.aula ?? '')
        $('#event-turno').text(props.turno ?? '')
        $('#event-seccion').text(props.seccion ?? '')
        $('#event-condicion').text(props.condicion ?? '')
      }

      const modalEl = document.getElementById('eventDetailModal')
      const modal = new bootstrap.Modal(modalEl)
      modal.show()
    },

    selectable: false,
    editable: false
  })

  calendar.render()

  // 2. Cargar combo de semestres
  cb_semesters()

  $('#txt_semestre').on('change', function () {
    toastr.info('Consultando en la base de datos ....', 'Mensaje', {
      positionClass: 'toast-bottom-right',
      timeOut: 2000,
      closeButton: !0,
      debug: !1,
      newestOnTop: !0,
      progressBar: !0,
      preventDuplicates: !0,
      onclick: null,
      showDuration: '300',
      hideDuration: '1000',
      extendedTimeOut: '1000',
      showEasing: 'swing',
      hideEasing: 'linear',
      showMethod: 'fadeIn',
      hideMethod: 'fadeOut',
      tapToDismiss: !1
    })

    dt_idsemester = $(this).val()
    loadSchedule(dt_idsemester)
  })
})

// ----------- FUNCIONES ------------- //

function cb_semesters() {
  $('#txt_semestre').find('option').remove().end()
  $.ajax({
    type: 'GET',
    url: '/ajax_all/semestersDocentes',
    dataType: 'json',
    success: function (response) {
      $('#txt_semestre').append(
        '<option selected disabled value="">Seleccione Periodo Lectivo</option>'
      )
      response.forEach((elemento) => {
        $('#txt_semestre').append(
          '<option' +
            ' value="' +
            elemento.id +
            '" ' +
            ' data-anho="' +
            elemento.anho +
            '" ' +
            ' data-numero="' +
            elemento.numero +
            '" ' +
            ' data-fecinicio="' +
            elemento.fecinicio +
            '" ' +
            ' data-fecfin="' +
            elemento.fecfin +
            '" ' +
            '>' +
            elemento.anho +
            ' - ' +
            elemento.numero +
            '</option>'
        )
      })
      $('#txt_semestre').selectpicker('refresh')
    },
    error: function (error) {
      console.log('Error', error)
    }
  })
}

/**
 * Carga el horario del docente y lo pasa al calendario
 */
function loadSchedule(idSemester) {
  if (!idSemester) return

  $.ajax({
    type: 'GET',
    url: '/docente/horarios/list/',
    data: {
      idsemester: idSemester
    },
    dataType: 'json',
    success: function (response) {
      // Horarios (clases)
      const rows = response.data ?? response

      // Foros agregados desde el backend (DataTables::of()->with('foros', $foros))
      const foros = response.foros ?? []

      const eventsClases = buildEventsFromRows(rows)
      const eventsForos = buildEventsFromForos(foros)

      calendar.removeAllEvents()
      calendar.addEventSource(eventsClases)
      calendar.addEventSource(eventsForos)
    },
    error: function (error) {
      console.log('Error al cargar horarios', error)
    }
  })
}

/**
 * Convierte la fila del horario en eventos FullCalendar
 * Se asume que las columnas Lunes, Martes, etc. traen algo como:
 * "08:00 - 10:00, 15:00 - 17:00" o "-" si no hay.
 */
function buildEventsFromRows(rows) {
  if (!Array.isArray(rows)) return []

  const dayMap = {
    Lunes: 1,
    Martes: 2,
    Miercoles: 3,
    Jueves: 4,
    Viernes: 5,
    Sabado: 6
  }

  const events = []

  rows.forEach((row) => {
    const titleBase = `${row.codcurso} - ${row.curso} (${
      row.aula ?? ''
    })`.trim()

    Object.keys(dayMap).forEach((dayName) => {
      const dayNum = dayMap[dayName]
      const value = row[dayName]

      if (!value || value === '-' || value === '') return

      // Puede haber varios rangos separados por coma
      const ranges = value.split(',')
      ranges.forEach((rangeRaw) => {
        const range = rangeRaw.trim()
        if (!range) return

        // formato "HH:MM - HH:MM"
        const [start, end] = range.split('-').map((s) => s.trim())

        if (!start || !end) return

        events.push({
          title: titleBase,
          daysOfWeek: [dayNum], // evento recurrente semanal
          startTime: start,
          endTime: end,
          extendedProps: {
            programa: row.programa,
            plan: row.plan,
            periodo: row.periodo,
            tipo: row.tipo,
            condicion: row.condicion,
            turno: row.turno,
            seccion: row.seccion,
            aula: row.aula,
            descripcion: `Programa: ${row.programa} | Plan: ${
              row.plan
            } | Aula: ${row.aula ?? ''}`
          }
        })
      })
    })
  })

  return events
}

function buildEventsFromForos(foros) {
  if (!Array.isArray(foros)) return []

  return foros.map((f) => ({
    // Título del evento en el calendario
    title: `[Foro] ${f.codcurso} - ${f.titulo}`,

    // Estas fechas vienen del backend:
    // start_calendar = DATE_SUB(fecfin, INTERVAL 59 MINUTE)
    // end_calendar   = fecfin
    start: f.start_calendar, // ej: "2025-01-09 23:00:00"
    end: f.end_calendar, // ej: "2025-01-09 23:59:00"

    allDay: false,

    // Props extra para el modal
    extendedProps: {
      tipoEvento: 'foro',
      descripcion: f.descripcion,
      curso: f.curso,
      codcurso: f.codcurso,
      fecinicio: f.fecinicio,
      fecfin: f.fecfin
    }
  }))
}
