export const languageSchema = {
    search: "Buscar",
    info: "Mostrando _START_ a _END_ de _TOTAL_ Registros",
    zeroRecords: "No hay registros para mostrar.",
    infoFiltered: "(Filtrados de _MAX_ Registros)",
    emptyTable: "La tabla está vacia.",
    infoEmpty: "No hay registros",
    paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>',
    },
};

export function getButtonsSchema(tableName) {
    return [
        {
            extend: "excel",
            title: "Reporte de " + tableName,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                orthogonal: "print",
            },
        },
        {
            extend: "pdf",
            title: "Reporte de " + tableName,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded ",
            exportOptions: {
                columns: ":visible",
                orthogonal: "print",
            },
        },
        {
            extend: "print",
            title: "Reporte de " + tableName,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                orthogonal: "print",
            },
        },
        {
            extend: "colvis",
            text: "Seleccionar celdas",
            title: "Reporte de " + tableName,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                orthogonal: "print",
            },
        },
    ];
}
