// resources/js/common/combobox/periodos.js
export function cb_periods_all(semesterId = null) {
    const $sel = $("#txt-periods");

    // Deshabilitar y refrescar visualmente mientras carga
    $sel.prop("disabled", true);
    if ($sel.hasClass("selectpicker") && $.fn.selectpicker) {
        $sel.selectpicker("refresh");
    }

    // Mostrar estado "cargando"
    $sel.empty().append('<option value="" disabled selected>Cargando periodos...</option>');
    if ($sel.hasClass("selectpicker") && $.fn.selectpicker) {
        $sel.selectpicker("refresh");
    }

    $.ajax({
        type: "GET",
        url: (window.routes && window.routes.periods) || "/alumno/matricula/periods",
        data: semesterId ? { semester_id: semesterId } : {},
        dataType: "json",
    })
        .done(function (response) {
            $sel.empty().append('<option value="" disabled selected>Seleccione periodo</option>');
            (response || []).forEach((el) => {
                const id = String(el?.id ?? "").trim();
                const numero = String(el?.numero ?? "").trim();
                $sel.append(`<option value="${id}" data-numero="${numero}">${numero}</option>`);
            });
        })
        .fail(function () {
            $sel.empty().append('<option value="" disabled selected>Error al cargar</option>');
        })
        .always(function () {
            // Habilitar y refrescar el picker para que deje de verse deshabilitado
            $sel.prop("disabled", false);
            if ($sel.hasClass("selectpicker") && $.fn.selectpicker) {
                $sel.selectpicker("refresh");
                $sel.selectpicker("render"); // opcional
            }
        });
}
