// resources/js/common/combobox/itemstitulacion.js

export function cb_itemstitulacion(selectedId = null) {
    const select = $("#txt-item_titulacion");

    $.ajax({
        type: "GET",
        url: "/admin/seguimiento_egresado/documentos_titulacion/list_itemstitulacion",
        dataType: "json",
        success: function (response) {
            console.log("items titulacion =>", response);

            if (!response.status || !Array.isArray(response.itemsTitulacion)) {
                console.warn("Respuesta inválida en items titulacion");
                return;
            }

            // Limpiar y poblar combo
            select.empty();
            select.append('<option value="" disabled selected>Seleccione ítem</option>');

            response.itemsTitulacion.forEach((item) => {
                select.append(
                    `<option value="${item.id}">${item.concepto}</option>`
                );
            });

            // Inicializar / refrescar selectpicker
            select.selectpicker("refresh");

            // Si viene un id seleccionado (modo editar)
            if (selectedId !== null && selectedId !== undefined && selectedId !== "") {
                const valStr = String(selectedId);
                select.selectpicker("val", valStr);
                select.selectpicker("refresh");
            }
        },
        error: function (error) {
            console.log("Error items titulacion", error);
        },
    });
}
