'use strict';
cb_exoneraciones()
// Exporta la función para poder importarla en otros archivos.
export function cb_exoneraciones() {
    // Vacía las opciones existentes antes de hacer la llamada AJAX.
    $("#txt-exoneration_id").find("option").remove().end();

    $.ajax({
        type: "GET",
        url: '/ajax_all/exoneraciones',
        dataType: 'json',
        success: function (response) {
            // Añade una opción por defecto para "sin exoneración".
            $("#txt-exoneration_id").append('<option selected value="">Sin exoneración</option>');

            // Itera sobre la respuesta y crea las opciones para el select.
            response.forEach((elemento) => {
                $("#txt-exoneration_id").append(
                    `<option
                        value="${elemento.id}"
                        data-descuento="${elemento.porcentaje_descuento}"
                    >
                        ${elemento.nombre} (${elemento.porcentaje_descuento}%)
                    </option>`
                );
            });

            // Refresca el plugin selectpicker para mostrar las nuevas opciones.
            $("#txt-exoneration_id").selectpicker("refresh");
        },
        error: function (error) {
            console.log("Error cargando exoneraciones:", error);
        },
    });
}