import { notificaciontoast } from "../common/method_toast.js";

document.addEventListener("DOMContentLoaded", () => {
    const form = document.getElementById("reset-form");

    form.addEventListener("submit", async (e) => {
        e.preventDefault();
        const btn = document.getElementById("btn-reset");
        btn.disabled = true;

        const formData = new FormData(form);

        try {
            const response = await fetch(form.action, {
                method: "POST",
                body: formData,
            });

            const data = await response.json();

            if (data.status) {
                notificaciontoast("info", data.mensaje, "Éxito!");
                setTimeout(() => (window.location.href = "/login"), 2000);
            } else {
                notificaciontoast("error", data.mensaje, "Error!");
            }
        } catch (error) {
            notificaciontoast(
                "error",
                "Ocurrió un error en el servidor.",
                "Error!"
            );
        } finally {
            btn.disabled = false;
        }
    });

    document.querySelectorAll(".toggle-password").forEach((btn) => {
        btn.addEventListener("click", function () {
            const input = document.querySelector(
                this.getAttribute("data-target")
            );
            const isPassword = input.type === "password";
            input.type = isPassword ? "text" : "password";
            this.classList.toggle("showing", isPassword);
        });
    });
});
