import { notificaciontoast } from "../common/method_toast.js";

document.addEventListener("DOMContentLoaded", () => {
    const form = document.getElementById("recover-form");

    form.addEventListener("submit", async (e) => {
        e.preventDefault();

        const formData = new FormData(form);
        const btn = document.getElementById("btn-recover");
        btn.disabled = true;

        try {
            const response = await fetch(form.action, {
                method: "POST",
                body: formData,
            });

            const data = await response.json();

            if (data.status) {
                notificaciontoast("info", data.mensaje, "Éxito!");
                form.reset();
            } else {
                notificaciontoast("error", data.mensaje, "Error!");
            }
        } catch (error) {
            notificaciontoast("error", "Error en el servidor.", "Error!");
        } finally {
            btn.disabled = false;
        }
    });
});
