
$(document).ready(function () {

    // REFERENCIAS
    const selectPeriodo = $("#cbo_periodo");
    const selectCurso = $("#cbo_curso");
    const containerTareas = $("#lista_tareas_contenido");
    const lblCurso = $("#lbl_nombre_curso_seleccionado");

    // INICIO
    cargarPeriodos();

    // --- 1. CARGAR PERIODOS ---
    function cargarPeriodos() {
        limpiarSelectVisual(selectPeriodo);
        selectPeriodo.append('<option selected disabled value="0">Cargando...</option>');
        reconstruirSelectVisual(selectPeriodo);

        $.ajax({
            type: "GET",
            url: "/alumno/tareas/get-periodos",
            dataType: "json",
            success: function (response) {
                limpiarSelectVisual(selectPeriodo);
                selectPeriodo.empty();
                selectPeriodo.append('<option selected disabled value="0">Seleccione un Periodo</option>');

                response.forEach((p) => {
                    let textoOption = `Periodo ${p.numero} - ${p.anho}`;
                    selectPeriodo.append(`<option value="${p.id}">${textoOption}</option>`);
                });

                reconstruirSelectVisual(selectPeriodo);
            },
            error: function (error) {
                console.error("Error cargando periodos:", error);
                selectPeriodo.html('<option>Error al cargar</option>');
                reconstruirSelectVisual(selectPeriodo);
            }
        });
    }

    // EVENTO PERIODO
    selectPeriodo.on("change", function () {
        let periodoId = $(this).val();
        cargarCursos(periodoId);
    });

    // --- 2. CARGAR CURSOS ---
    function cargarCursos(periodId) {
        limpiarSelectVisual(selectCurso);
        selectCurso.empty();
        selectCurso.append('<option selected disabled value="0">Cargando...</option>');
        reconstruirSelectVisual(selectCurso);

        containerTareas.html('<div class="text-center mt-5"><h5 class="text-muted">Seleccione un curso</h5></div>');
        lblCurso.text("Ningún curso seleccionado");

        $.ajax({
            type: "GET",
            url: "/alumno/tareas/get-cursos/" + periodId,
            dataType: "json",
            success: function (response) {
                limpiarSelectVisual(selectCurso);
                selectCurso.empty();
                selectCurso.append('<option selected disabled value="0">Seleccione un Curso</option>');

                if (response.length > 0) {
                    response.forEach((c) => {
                        // SOLO NOMBRE (como solicitaste)
                        let texto = c.curso_nombre;
                        selectCurso.append(`<option value="${c.asignatura_id}">${texto}</option>`);
                    });
                } else {
                    selectCurso.append('<option value="0" disabled>No hay cursos</option>');
                }

                reconstruirSelectVisual(selectCurso);
            },
            error: function (error) {
                console.error("Error cargando cursos:", error);
            }
        });
    }

    // EVENTO CURSO
    selectCurso.on("change", function () {
        let asignaturaId = $(this).val();
        let nombreCurso = $("#cbo_curso option:selected").text();
        lblCurso.text(nombreCurso);

        cargarTareas(asignaturaId);
    });

    function cargarTareas(asignaturaId) {
    containerTareas.html(`
        <div class="text-center mt-5 pt-5">
            <div class="spinner-border text-primary" role="status"></div>
            <p class="mt-2">Cargando notas del curso...</p>
        </div>
    `);

    $.ajax({
        type: "GET",
        url: "/alumno/tareas/get-actividades/" + asignaturaId,
        dataType: "json",
        success: function (response) {
            containerTareas.empty();

            if (response.length === 0) {
                containerTareas.html(`
                    <div class="text-center mt-5">
                        <i class="material-icons fs-1 text-muted">assignment_late</i>
                        <h5 class="mt-2">No hay evaluaciones registradas.</h5>
                    </div>
                `);
                return;
            }

            let html = '<div class="row">';
            // Obtenemos fecha actual del sistema
            let fechaActual = new Date();

            response.forEach((tarea) => {

                let htmlNota = '<span class="badge badge-light text-dark border">Sin nota</span>';
                if (tarea.nota_obtenida !== null && tarea.nota_obtenida !== undefined) {
                    let nota = parseFloat(tarea.nota_obtenida);
                    let color = nota >= 13 ? 'badge-success' : 'badge-danger';
                    htmlNota = `<span class="badge ${color}">Nota: ${nota}</span>`;
                }

                let fechaTexto = 'Sin fecha límite';
                let fechaLimiteObj = null;
                let estaVencido = false;

                if (tarea.fecha_entrega) {
                    fechaLimiteObj = new Date(tarea.fecha_entrega);
                    fechaTexto = fechaLimiteObj.toLocaleDateString() + ' ' +
                        fechaLimiteObj.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });

                    // Comparamos fecha actual vs fecha limite
                    if (fechaActual > fechaLimiteObj) {
                        estaVencido = true;
                    }
                }

                let valorBase = parseFloat(tarea.porcentaje || 0);
                let porcentajeTexto = Math.round(valorBase * 100) + '%';

                let nombreEvaluacion = tarea.nombre_nota ? tarea.nombre_nota : '';

                let btnSubir = '';
                let msgEstado = '';

                if (tarea.documento) {
                    btnSubir = `
                        <button class="btn btn-success btn-sm w-100 mt-2" disabled style="cursor: not-allowed; opacity: 1;">
                            <i class="fa fa-check-double me-1"></i> Tarea Entregada
                        </button>
                    `;
                    msgEstado = `<small class="d-block text-success mt-1"><i class="fa fa-check-circle"></i> Archivo subido correctamente</small>`;

                } else if (estaVencido) {
                    btnSubir = `
                        <button class="btn btn-danger btn-sm w-100 mt-2" disabled style="cursor: not-allowed; opacity: 1;">
                            <i class="fa fa-clock me-1"></i> Plazo Vencido
                        </button>
                    `;
                    msgEstado = `<small class="d-block text-danger mt-1">La fecha límite ha expirado.</small>`;

                } else {
                    btnSubir = `
                        <button class="btn btn-outline-primary btn-sm w-100 mt-2 btn-open-modal" 
                            data-asignatura="${asignaturaId}"
                            data-notaid="${tarea.id_definicion_nota}" 
                            data-nom-actividad="${tarea.actividad_nombre}"
                            data-nom-nota="${nombreEvaluacion}">
                            <i class="fa fa-upload me-1"></i> Subir Tarea
                        </button>
                    `;
                }

                // --- NUEVO BLOQUE: Lógica para mostrar la retroalimentación ---
                let htmlRetro = '';
                // Verificamos si existe y si no está vacío
                if (tarea.retroalimentacion && tarea.retroalimentacion.trim() !== '') {
                    htmlRetro = `
                        <div class="mt-3 p-3 border rounded" style="background-color: #f8f9fa;">
                            <h6 class="text-primary mb-1" style="font-size: 0.85rem; font-weight: bold;">
                                <i class="fa fa-comment-dots me-1"></i> Retroalimentación del Docente:
                            </h6>
                            <p class="mb-0 text-dark small" style="white-space: pre-wrap; font-style: italic; line-height: 1.4;">"${tarea.retroalimentacion}"</p>
                        </div>
                    `;
                }
                // -------------------------------------------------------------

                html += `
                <div class="col-xl-6 col-lg-12 col-sm-12 mb-4">
                    <div class="card h-100 shadow-sm border-0">
                        <div class="card-header bg-primary text-white py-2">
                            <h6 class="card-title text-white mb-0" style="font-size: 0.9rem;">
                                <i class="fa fa-bookmark me-1"></i> ${tarea.indicador_nombre || 'General'}
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div>
                                    <h4 class="card-title text-primary mb-1">${tarea.actividad_nombre}</h4>
                                    <span class="d-block text-dark mb-2 font-w600">${nombreEvaluacion}</span>
                                    <small class="text-muted ${estaVencido && !tarea.documento ? 'text-danger fw-bold' : ''}">
                                        <i class="fa fa-calendar-alt me-1"></i> Vence: ${fechaTexto}
                                    </small>
                                </div>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mt-4 pt-2 border-top">
                                <div class="d-flex align-items-center">
                                    <span class="badge badge-warning light me-2">Peso: ${porcentajeTexto}</span>
                                </div>
                                <div style="font-size: 1.1em;">${htmlNota}</div>
                            </div>
                            
                            <div class="mt-3 pt-2">
                                ${btnSubir}
                                ${msgEstado}
                            </div>

                            <!-- --- NUEVO: Aquí insertamos la variable htmlRetro --- -->
                            ${htmlRetro}

                        </div>
                    </div>
                </div>`;
            });

            html += '</div>';
            containerTareas.html(html);
        },
        error: function (error) {
            console.error("Error cargando tareas:", error);
            containerTareas.html('<div class="alert alert-danger">Error al cargar las tareas.</div>');
        }
    });
}

    // UTILIDADES VISUALES
    function limpiarSelectVisual(elementoSelect) {
        if ($.fn.niceSelect) elementoSelect.niceSelect('destroy');
        if ($.fn.selectpicker) elementoSelect.selectpicker('destroy');
        elementoSelect.next('.nice-select').remove();
        elementoSelect.empty();
    }

    function reconstruirSelectVisual(elementoSelect) {
        if ($.fn.niceSelect) elementoSelect.niceSelect();
    }

    $(document).on("click", ".btn-open-modal", function (e) {
        e.preventDefault();

        let asigId = $(this).data('asignatura');
        let notaId = $(this).data('notaid');
        let nombreAct = $(this).data('nom-actividad');
        let nombreNota = $(this).data('nom-nota');

        console.log("ID Nota a enviar:", notaId);

        $("#hdn_asignatura_id").val(asigId);
        $("#hdn_nota_id").val(notaId);
        $("#txt_nombre_mostrar").val(nombreAct + ' - ' + (nombreNota || ''));

        $("#file_tarea").val('');
        $("#upload-progress").addClass('d-none');
        $("#modalSubirTarea").modal("show");
    });

    $("#formSubirTarea").on("submit", function (e) {
        e.preventDefault();

        let formData = new FormData(this);
        let btnSubmit = $(this).find("button[type='submit']");

        btnSubmit.prop('disabled', true).text('Subiendo...');
        $("#upload-progress").removeClass('d-none');

        $.ajax({
            type: "POST",
            url: "/alumno/tareas/upload",
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {
                if (response.status) {
                    $("#modalSubirTarea").modal("hide");

                    if (typeof Swal !== 'undefined') {
                        Swal.fire("¡Éxito!", response.message, "success");
                    } else {
                        alert(response.message);
                    }

                    let currentAsignatura = $("#cbo_curso").val();
                    cargarTareas(currentAsignatura);

                } else {
                    alert("Error: " + response.message);
                }
            },
            error: function (error) {
                console.error("Error subiendo:", error);
                alert("Ocurrió un error al subir el archivo.");
            },
            complete: function () {
                btnSubmit.prop('disabled', false).text('Guardar Tarea');
                $("#upload-progress").addClass('d-none');
            }
        });
    });
});