"use strict";

document.addEventListener("DOMContentLoaded", async function () {
    const container = document.querySelector("#publicacionesContainer");

    try {
        const response = await fetch("/alumno/publicaciones/list", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute("content")
            },
            body: JSON.stringify({})
        });

        const publicaciones = await response.json();

        if (!publicaciones.length) {
            container.innerHTML = `
                <div class="alert alert-info">
                    No hay publicaciones disponibles por el momento.
                </div>
            `;
            return;
        }

        let html = "";
        publicaciones.forEach(pub => {
            html += `
                <div class="col-md-6">
                    <div class="card card-custom h-100 shadow-sm">
                        <img src="/alumno/publicaciones/viewimg/${pub.id}/${pub.carpeta}/${pub.imagen}" 
     alt="Imagen" 
     class="card-img-top" 
     style="object-fit: cover; height: 250px;">
                        <div class="card-body">
                            <h5 class="card-title">${pub.titulo}</h5>
                            <p class="card-text text-muted">
                                ${pub.contenido.replace(/<[^>]*>?/gm, '').substring(0, 150)}...
                            </p>
                            <button class="btn btn-primary btn-sm" data-bs-toggle="modal"
                                    data-bs-target="#modalPublicacion${pub.id}">
                                Ver más
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Modal -->
                <div class="modal fade" id="modalPublicacion${pub.id}" tabindex="-1"
                     aria-labelledby="modalLabel${pub.id}" aria-hidden="true">
                    <div class="modal-dialog modal-lg modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="modalLabel${pub.id}">${pub.titulo}</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <img src="/alumno/publicaciones/viewimg/${pub.id}/${pub.carpeta}/${pub.imagen}" 
     class="img-fluid mb-3 rounded" 
     alt="${pub.titulo}">
                                <div>${pub.contenido}</div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        });

        container.innerHTML = `<div class="row g-4">${html}</div>`;
    } catch (error) {
        console.error("Error cargando publicaciones:", error);
        container.innerHTML = `
            <div class="alert alert-danger">
                Ocurrió un error al cargar las publicaciones.
            </div>
        `;
    }
});
