import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../common/schemas.js";

var cantidad_ofertas, pagina_seleccionada = 1;
// Obtener la URL actual
var url = new URL(window.location.href);

// Obtener el valor del parámetro 'orden'
var pagina = url.searchParams.get('pagina');
var orden = url.searchParams.get('orden');
var departamento = url.searchParams.get('ciudad');
var categoria = url.searchParams.get('categoria');
var empresa = url.searchParams.get('empresa');
var buscar = url.searchParams.get('buscar');

// Comprobar si el parámetro 'orden' tiene un valor
if (pagina == null) { pagina = '1'; }
if (orden == null) { orden = 'desc'; }
if (departamento == null) { departamento = 'all'; }
if (categoria == null) { categoria = 'all'; }
if (empresa == null) { empresa = 'all'; }
if (buscar == null) { buscar = 'default'; }

// Listar ofertas
obtener_cantidad();
listar_ofertas_laborales();
actualizarURL();

function actualizarURL() {
    let opciones = '';
    let filtros = '';
    let divisor = '<strong>  <i class="fa-solid fa-grip-lines-vertical fa-flip fa-xl"></i>  </strong>';

    if (pagina != '1') {
        opciones += '?pagina=' + pagina;
        filtros += 'Pagina: ' + pagina;
    }

    if (orden != 'desc') {
        if (opciones == '') {
            opciones += '?orden=' + orden;
        }
        else {
            opciones += '&orden=' + orden;
            filtros += divisor;
        }
        filtros += 'Orden: ' + orden;
    }

    if (departamento != 'all') {
        if (opciones == '') {
            opciones += '?ciudad=' + departamento;
        }
        else {
            opciones += '&ciudad=' + departamento;
            filtros += divisor;
        }
        filtros += 'Ciudad: ' + departamento;
    }

    if (categoria != 'all') {
        if (opciones == '') {
            opciones += '?categoria=' + categoria;
        }
        else {
            opciones += '&categoria=' + categoria;
            filtros += divisor;
        }
        filtros += 'Categoria: ' + categoria;
    }

    if (empresa != 'all') {
        if (opciones == '') {
            opciones += '?empresa=' + empresa;
        }
        else {
            opciones += '&empresa=' + empresa;
            filtros += divisor;
        }
        filtros += 'Empresa: ' + empresa;
    }

    if (buscar != 'default') {
        if (opciones == '') {
            opciones += '?buscar=' + buscar;
        }
        else {
            opciones += '&buscar=' + buscar;
            filtros += divisor;
        }
        filtros += 'Puesto: ' + buscar;
    }

    // cambiar URL
    if (history.pushState) {
        var newurl = window.location.protocol + "//" + window.location.host + window.location.pathname + opciones;
        window.history.pushState({ path: newurl }, '', newurl);
    }

    // cambiar texto filtros
    if (filtros == '') {
        $('#info-filtros').html('Sin filtros aplicados');
    } else {
        $('#info-filtros').html(filtros);
    }

}

// on change select orden
$("#orden_ofertas").on('change', function () {
    clean_infopreview();
    orden = $(this).val();
    obtener_cantidad();             // actualizar navegacion
    listar_ofertas_laborales();     // actualizar ofertas
    actualizarURL();                // actualizar url
});


var sl_attributes;

// on change select departamentos
const selectDepartamento = document.querySelector('#txt-departamentos');
selectDepartamento.addEventListener('change', (e) => {
    e.preventDefault();
    sl_attributes = selectDepartamento.options[selectDepartamento.selectedIndex];
    departamento = sl_attributes.getAttribute('namedepartamento');
    obtener_cantidad();             // actualizar navegacion
    listar_ofertas_laborales();     // actualizar ofertas
    actualizarURL();                // actualizar url
});

// on change select categorias
const selectCategoria = document.querySelector('#txt-categorias');
selectCategoria.addEventListener('change', (e) => {
    e.preventDefault();
    sl_attributes = selectCategoria.options[selectCategoria.selectedIndex];
    categoria = sl_attributes.getAttribute('namecategoria');
    obtener_cantidad();             // actualizar navegacion
    listar_ofertas_laborales();     // actualizar ofertas
    actualizarURL();                // actualizar url
});

// on change select empresas
const selectEmpresa = document.querySelector('#txt-empresas');
selectEmpresa.addEventListener('change', (e) => {
    e.preventDefault();
    sl_attributes = selectEmpresa.options[selectEmpresa.selectedIndex];
    empresa = sl_attributes.getAttribute('nameempresa');
    obtener_cantidad();             // actualizar navegacion
    listar_ofertas_laborales();     // actualizar ofertas
    actualizarURL();                // actualizar url
});

$('#btnBuscarTexto').on('click', function (e) {
    e.preventDefault();
    buscar = $('#txt-buscartexto').val();
    if (buscar == '') {
        buscar = 'default';
    }
    obtener_cantidad();             // actualizar navegacion
    listar_ofertas_laborales();     // actualizar ofertas
    actualizarURL();                // actualizar url
});

$('#btnLimpiarTexto').on('click', function (e) {
    e.preventDefault();
    $('#txt-buscartexto').val('');
    buscar = 'default';
    obtener_cantidad();             // actualizar navegacion
    listar_ofertas_laborales();     // actualizar ofertas
    actualizarURL();                // actualizar url
});

// on click pagina
$("#nro_pagina").on("click", ".btnNavegacion", function (e) {
    clean_infopreview();
    let nropagina = $(this).data("nropagina");
    // pagina_seleccionada = nropagina;
    pagina = nropagina;
    obtener_cantidad();
    listar_ofertas_laborales();
    actualizarURL();
});



//
function obtener_cantidad() {
    $.ajax({
        type: "GET",
        url: '/alumno/ofertas_laborales/cantidad_ofertas?pagina=' + pagina + '&orden=' + orden + '&departamento=' + departamento + '&categoria=' + categoria + '&empresa=' + empresa + '&buscar=' + buscar,
        dataType: 'json',
        beforeSend: function () { },
        success: function (response) {
            cantidad_ofertas = response;
            // NAVEGACION NUMERO 1
            $('#info_total_bot').html('Total: ' + cantidad_ofertas + ' ofertas laborales')
            let totalPaginas = Math.ceil(cantidad_ofertas / 12);
            $('#nro_pagina').html('');
            for (let index = 1; index <= totalPaginas; index++) {
                if (index == pagina) {
                    $('#nro_pagina').append(`<li class="page-item active"><a class="btnNavegacion page-link" data-nropagina="${index}" href="javascript:void(0)">${index}</a></li>`);
                }
                else {
                    $('#nro_pagina').append(`<li class="page-item"><a class="btnNavegacion page-link" data-nropagina="${index}" href="javascript:void(0)">${index}</a></li>`);
                }
            }
        },
        error: function (error) {
            console.log("Error", error);
        },
    });
}



function listar_ofertas_laborales() {
    let contador = 0;
    // limpiar ofertas
    $('#lista_ofertas_laborales').html('');
    $('#lista2_ofertas_laborales').html('');
    $.ajax({
        type: "GET",
        url: '/alumno/ofertas_laborales/listar?pagina=' + pagina + '&orden=' + orden + '&departamento=' + departamento + '&categoria=' + categoria + '&empresa=' + empresa + '&buscar=' + buscar,
        dataType: 'json',
        beforeSend: function () { notificaciontoast("info", "Consultando ofertas laborales", "Mensaje", "bottom-right", "1600"); },
        success: function (response) {
            response.forEach((elemento) => {
                contador++;
                // lista 1
                $('#lista_ofertas_laborales').append(
                    `
                        <div class="col-xl-3 col-xxl-4  col-md-4 col-sm-6">
                                <div class="card">
                                        <div class="jobs2 card-body">
                                                <div class="text-center">
                                                        <span class="mb-2">
                                                            <img src="../storage/companies/default/logo.png"
                                                                width="71" height="71" class="rounded-pill">
                                                        </span>
                                                        <h4 class="mb-0">
                                                            <a class="btninfo_to_preview" href="javascript:void(0);">${elemento.puesto}</a>
                                                        </h4>
                                                        <span class="fw-bold mb-3 d-block">${elemento.nombrecompany}</span>
                                                </div>
                                                <div class="text-center mb-1">
                                                    <a href="javascript:void(0);" class="btninfo_to_preview btn btn-sm btn-outline-primary rounded me-2"
                                                        data-idjob="${elemento.idjob}"
                                                        data-puesto="${elemento.puesto}"
                                                        data-vacantes="${elemento.vacantes}"
                                                        data-tipo="${elemento.tipo}"
                                                        data-modalidad="${elemento.modalidad}"
                                                        data-experiencia="${elemento.experiencia}"
                                                        data-fecpublicacion="${elemento.fecpublicacion}"
                                                        data-feccierre="${elemento.feccierre}"
                                                        data-salariomin="${elemento.salariomin}"
                                                        data-salariomax="${elemento.salariomax}"
                                                        data-rangosalarial="S/ ${elemento.salariomin} - S/ ${elemento.salariomax}"
                                                        data-nivel_educativo="${elemento.nivel_educativo}"
                                                        data-estado="${elemento.estado}"
                                                        data-idcompany="${elemento.idcompany}"
                                                        data-nombrecompany="${elemento.nombrecompany}"
                                                        data-idcategory="${elemento.idcategory}"
                                                        data-nombrecategory="${elemento.nombrecategory}"
                                                        data-idubigeo="${elemento.idubigeo}"
                                                        data-iddepartamento="${elemento.iddepartamento}"
                                                        data-idprovincia="${elemento.idprovincia}"
                                                        data-iddistrito="${elemento.iddistrito}"
                                                        data-departamento="${elemento.departamento}"
                                                        data-provincia="${elemento.provincia}"
                                                        data-distrito="${elemento.distrito}"
                                                        data-ubicacion="${elemento.departamento}, ${elemento.provincia}"
                                                    >Ver detalle</a>
                                                </div>
                                                <div class="text-center">
                                                        <span class="d-block mb-1"><i
                                                                class="fas fa-map-marker-alt me-2"></i>${elemento.departamento},
                                                                ${elemento.provincia}</span>
                                                        <span><i class="fas fa-comments-dollar me-2"></i>S/ ${elemento.salariomin} - S/
                                                        ${elemento.salariomax}</span>
                                                </div>
                                        </div>
                                </div>
                        </div>
                        `
                );
                // lista 2
                $('#lista2_ofertas_laborales').append(
                    `
                        <div class="col-xl-12">
						<div class="card">
                        <div class="card-body pb-0 pt-0">
                        <div class="row">
                        <div class="d-flex flex-wrap search-row p-3 mb-0 rounded justify-content-between align-items-center">
                            <div class="d-flex col-xl-3 col-xxl-4 col-lg-4 col-sm-6 align-items-center">
                                <span class="me-3 ml-lg-0 ml-sm-auto ms-0 mt-sm-0 mt-3">
                                    <img src="../storage/companies/default/logo.png" width="54"
                                        height="54" class="rounded-pill">
                                </span>
                                <div>
                                    <h3 class="title"><a href="javascript:void(0);"
                                            class="">${elemento.puesto}</a></h3>
                                    <span class="">${elemento.nombrecompany}</span>
                                </div>
                            </div>
                            <div class="d-flex col-xl-3 col-xxl-4 col-lg-4 col-sm-6 align-items-center">
                                <svg class="me-3 ml-lg-0 ml-sm-auto ms-0 mt-sm-0 mt-3" width="54" height="54" viewBox="0 0 54 54" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect width="54" height="54" rx="15" fill="#2BC155"></rect>
                                    <g clip-path="url(#clip6)">
                                        <path d="M27.0001 19.84C23.5987 19.84 20.6536 22.2024 19.9157 25.5229L17.4992 36.397C17.4815 36.4768 17.4725 36.5583 17.4725 36.64C17.4725 37.2585 17.974 37.76 18.5925 37.76H35.4077C35.4894 37.76 35.5709 37.751 35.6507 37.7333C36.2545 37.5991 36.6352 37.0008 36.501 36.397L34.0846 25.5229C33.3467 22.2024 30.4016 19.84 27.0001 19.84ZM27.0001 17.6C31.4515 17.6 35.3056 20.6916 36.2712 25.037L38.6877 35.9111C39.0902 37.7226 37.9481 39.5174 36.1366 39.92C35.8973 39.9731 35.6529 40 35.4077 40H18.5925C16.7369 40 15.2325 38.4956 15.2325 36.64C15.2325 36.3948 15.2594 36.1504 15.3126 35.9111L17.729 25.037C18.6947 20.6916 22.5488 17.6 27.0001 17.6Z"
                                            fill="white"></path>
                                        <path d="M29.2402 24.32C29.8588 24.32 30.3602 24.8214 30.3602 25.44C30.3602 26.0585 29.8588 26.56 29.2402 26.56H26.4402C26.1309 26.56 25.8802 26.8107 25.8802 27.12C25.8802 27.4292 26.1309 27.68 26.4402 27.68H27.5602C29.1066 27.68 30.3602 28.9336 30.3602 30.48C30.3602 32.0264 29.1066 33.28 27.5602 33.28H24.7602C24.1416 33.28 23.6402 32.7785 23.6402 32.16C23.6402 31.5414 24.1416 31.04 24.7602 31.04H27.5602C27.8695 31.04 28.1202 30.7892 28.1202 30.48C28.1202 30.1707 27.8695 29.92 27.5602 29.92H26.4402C24.8938 29.92 23.6402 28.6664 23.6402 27.12C23.6402 25.5736 24.8938 24.32 26.4402 24.32H29.2402Z"
                                            fill="white"></path>
                                        <path d="M25.8802 23.2C25.8802 22.5814 26.3817 22.08 27.0002 22.08C27.6188 22.08 28.1203 22.5814 28.1203 23.2V25.44C28.1203 26.0586 27.6188 26.56 27.0002 26.56C26.3817 26.56 25.8802 26.0586 25.8802 25.44V23.2Z"
                                            fill="white"></path>
                                        <path d="M28.1203 34.4C28.1203 35.0186 27.6188 35.52 27.0002 35.52C26.3817 35.52 25.8802 35.0186 25.8802 34.4V32.16C25.8802 31.5414 26.3817 31.04 27.0002 31.04C27.6188 31.04 28.1203 31.5414 28.1203 32.16V34.4Z"
                                            fill="white"></path>
                                        <path d="M25.8001 18.304C26.0298 18.8784 25.7504 19.5302 25.1761 19.7599C24.6018 19.9896 23.95 19.7103 23.7203 19.136L21.4803 13.536C21.1163 12.626 22.0141 11.7204 22.9272 12.0766C23.7659 12.4037 24.391 12.56 24.7602 12.56C24.8521 12.56 24.9283 12.5404 25.0946 12.4697C25.1387 12.4509 25.1906 12.428 25.3122 12.3742C25.8915 12.1203 26.3491 12 27.0002 12C27.6497 12 28.1146 12.1206 28.6957 12.3721C28.8432 12.4366 28.9021 12.4623 28.9542 12.4838C29.0978 12.5429 29.1669 12.56 29.2402 12.56C29.5878 12.56 30.2185 12.4023 31.0812 12.0735C31.9932 11.7258 32.8825 12.6298 32.5201 13.536L30.2801 19.136C30.0503 19.7103 29.3985 19.9896 28.8242 19.7599C28.2499 19.5302 27.9705 18.8784 28.2003 18.304L29.6096 14.7807C29.4808 14.7936 29.3578 14.8 29.2402 14.8C28.8314 14.8 28.4927 14.7162 28.1013 14.5551C28.0241 14.5232 27.9394 14.4863 27.8064 14.4279C27.4822 14.2877 27.2985 14.24 27.0002 14.24C26.7048 14.24 26.5313 14.2856 26.2114 14.4258C26.1015 14.4745 26.0319 14.5052 25.9706 14.5313C25.5512 14.7095 25.2002 14.8 24.7602 14.8C24.6419 14.8 24.5189 14.7939 24.3911 14.7816L25.8001 18.304Z" fill="white"></path>
                                    </g>
                                    <defs>
                                        <clipPath>
                                            <rect width="28" height="28" fill="white"
                                                transform="translate(13 12)"></rect>
                                        </clipPath>
                                    </defs>
                                </svg>
                                <div>
                                    <h4 class="sub-title text-black">S/ ${elemento.salariomin} - S/
                                    ${elemento.salariomax}</h4>
                                    <span>Rango salarial</span>
                                </div>
                            </div>
                            <div
                                class="d-flex col-xl-3 col-xxl-4 col-lg-4 col-sm-6 mt-lg-0 mt-3 align-items-center">
                                <svg class="me-3" width="54" height="54" viewBox="0 0 54 54" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect width="54" height="54" rx="15" fill="#FBA556"></rect>
                                    <path d="M27 15C21.934 15 17.8125 19.1215 17.8125 24.1875C17.8125 25.8091 18.2409 27.4034 19.0515 28.7979C19.2404 29.123 19.4516 29.4398 19.6793 29.7396L26.6008 39H27.3991L34.3207 29.7397C34.5483 29.4398 34.7595 29.1231 34.9485 28.7979C35.7591 27.4034 36.1875 25.8091 36.1875 24.1875C36.1875 19.1215 32.066 15 27 15ZM27 27.2344C25.32 27.2344 23.9531 25.8675 23.9531 24.1875C23.9531 22.5075 25.32 21.1406 27 21.1406C28.68 21.1406 30.0469 22.5075 30.0469 24.1875C30.0469 25.8675 28.68 27.2344 27 27.2344Z" fill="white"></path>
                                </svg>
                                <div>
                                    <h4 class="sub-title text-black">${elemento.departamento},
                                    ${elemento.provincia}</h4>
                                    <span>Ubicación</span>
                                </div>
                            </div>
                            <div
                                class="col-xl-2 col-xxl-12 text-xl-right text-lg-left text-sm-right col-lg-12 col-sm-6  mt-2">
                                <a href="javascript:void(0);" class="btninfo_to_preview btn btn-sm btn-outline-primary rounded me-2"
                                            data-idjob="${elemento.idjob}"
                                            data-puesto="${elemento.puesto}"
                                            data-vacantes="${elemento.vacantes}"
                                            data-tipo="${elemento.tipo}"
                                            data-modalidad="${elemento.modalidad}"
                                            data-experiencia="${elemento.experiencia}"
                                            data-fecpublicacion="${elemento.fecpublicacion}"
                                            data-feccierre="${elemento.feccierre}"
                                            data-salariomin="${elemento.salariomin}"
                                            data-salariomax="${elemento.salariomax}"
                                            data-rangosalarial="S/ ${elemento.salariomin} - S/ ${elemento.salariomax}"
                                            data-nivel_educativo="${elemento.nivel_educativo}"
                                            data-estado="${elemento.estado}"
                                            data-idcompany="${elemento.idcompany}"
                                            data-nombrecompany="${elemento.nombrecompany}"
                                            data-idcategory="${elemento.idcategory}"
                                            data-nombrecategory="${elemento.nombrecategory}"
                                            data-idubigeo="${elemento.idubigeo}"
                                            data-iddepartamento="${elemento.iddepartamento}"
                                            data-idprovincia="${elemento.idprovincia}"
                                            data-iddistrito="${elemento.iddistrito}"
                                            data-departamento="${elemento.departamento}"
                                            data-provincia="${elemento.provincia}"
                                            data-distrito="${elemento.distrito}"
                                            data-ubicacion="${elemento.departamento}, ${elemento.provincia}"
                                    >Ver detalle</a>
                            </div>
                        </div>
                        </div>
                        </div>
                        </div>
                        </div>
                        `
                );
            })
            let registroini = ((pagina - 1) * 12) + 1;
            let registrofin = registroini + contador - 1;
            $('#info_cantidad_bot').html('Mostrando del ' + registroini + ' a ' + registrofin)
        },
        error: function (error) {
            console.log("Error", error);
        },
    });
}



var formCheck, formData;

// INICIO - MODAL POSTULAR
$("#btnModalPostular").click(function () {
    // limpiar validaciones
    formCheck = $("#formModal")[0];
    $(formCheck).removeClass('was-validated'); // remover validaciones
    $('#txt-documento').val('');
    // show form
    $("#modalPostular").modal("show");
});
// FIN - MODAL POSTULAR

$("#btnPostular").click(function () {
    store();
    $(formCheck).addClass('was-validated'); // añadir validaciones
});
// FIN - MODAL POSTULAR

function store() {
    formData = new FormData(document.getElementById('formModal'));
    $.ajax({
        headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
        type: "POST",
        url: 'ofertas_laborales/store',
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            $('#btnPostular').addClass('disabled');
        },
        success: function (data) {
            // validators
            if (data.status == 'validators') {
                for (var campo in data.mensaje) {
                    if (data.mensaje.hasOwnProperty(campo)) {
                        var mensajes = data.mensaje[campo];
                        for (var i = 0; i < mensajes.length; i++) {
                            var mensaje = mensajes[i];
                            // console.log("campo: " + campo + ", mensaje: " + mensaje);
                            notificaciontoast("error", mensaje, "Error!", "bottom-right", 3000);
                        }
                    }
                }
                $('#btnPostular').removeClass('disabled');
            }
            else if (data.status == true) {
                setTimeout(function () {
                    notificaciontoast("info", data.mensaje, "Éxito!", "bottom-right", 3000);
                    $("#modalPostular").modal("hide");
                }, 1000); // ocultar despues de 1 sec
                $('#btnPostular').removeClass('disabled');
            } else {
                notificaciontoast("error", data.mensaje, "Error!", "bottom-right", 3000);
                $('#btnPostular').removeClass('disabled');
            }
        },
        error: function (error) {
            console.log("Error", error);
        },
    });
}







// on click card
$("#lista_ofertas_laborales").on("click", ".btninfo_to_preview", function (e) {
    $('#txt-idjob').val($(this).data("idjob"));
    $('#txt-idcompany').val($(this).data("idcompany"));
    $('#preview-puesto').html($(this).data("puesto"));
    $('#preview-nombrecompany').html($(this).data("nombrecompany"));
    $('#preview-descripcion').html($(this).data("descripcion"));
    $('#preview-vacantes').html($(this).data("vacantes"));
    $('#preview-tipo').html($(this).data("tipo"));
    $('#preview-modalidad').html($(this).data("modalidad"));
    $('#preview-experiencia').html($(this).data("experiencia"));
    $('#preview-fecpublicacion').html($(this).data("fecpublicacion"));
    $('#preview-feccierre').html($(this).data("feccierre"));
    $('#preview-rangosalarial').html($(this).data("rangosalarial"));
    $('#preview-nivel_educativo').html($(this).data("nivel_educativo"));
    $('#preview-nombrecategory').html($(this).data("nombrecategory"));
    $('#preview-ubicacion').html($(this).data("ubicacion"));
});
$("#lista2_ofertas_laborales").on("click", ".btninfo_to_preview", function (e) {
    $('#txt-idjob').val($(this).data("idjob"));
    $('#txt-idcompany').val($(this).data("idcompany"));
    $('#preview-puesto').html($(this).data("puesto"));
    $('#preview-nombrecompany').html($(this).data("nombrecompany"));
    $('#preview-descripcion').html($(this).data("descripcion"));
    $('#preview-vacantes').html($(this).data("vacantes"));
    $('#preview-tipo').html($(this).data("tipo"));
    $('#preview-modalidad').html($(this).data("modalidad"));
    $('#preview-experiencia').html($(this).data("experiencia"));
    $('#preview-fecpublicacion').html($(this).data("fecpublicacion"));
    $('#preview-feccierre').html($(this).data("feccierre"));
    $('#preview-rangosalarial').html($(this).data("rangosalarial"));
    $('#preview-nivel_educativo').html($(this).data("nivel_educativo"));
    $('#preview-nombrecategory').html($(this).data("nombrecategory"));
    $('#preview-ubicacion').html($(this).data("ubicacion"));
});




function clean_infopreview() {
    $('#txt-idjob').val('');
    $('#txt-idcompany').val('');
    $('#preview-puesto').html('Puesto');
    $('#preview-nombrecompany').html('Empresa');
    $('#preview-descripcion').html('Descripción de la oferta laboral');
    $('#preview-vacantes').html('?');
    $('#preview-tipo').html('?');
    $('#preview-modalidad').html('?');
    $('#preview-experiencia').html('?');
    $('#preview-fecpublicacion').html('?');
    $('#preview-feccierre').html('?');
    $('#preview-rangosalarial').html('?');
    $('#preview-nivel_educativo').html('?');
    $('#preview-nombrecategory').html('?');
    $('#preview-ubicacion').html('?');
}



set_selected_departamento();
cb_categories();
cb_companies();

function set_selected_departamento() {
    if (departamento != 'all') {

        // Nombre del atributo que deseas seleccionar
        let nombreAtributoDeseado = departamento;

        // Iterar sobre las opciones del select
        $("#txt-departamentos option").each(function () {
            // Obtener el valor del atributo data-nombre-atributo
            let nombreAtributo = $(this).attr("namedepartamento");

            // Verificar si el nombre del atributo coincide
            if (nombreAtributo === nombreAtributoDeseado) {
                // Establecer la opción como seleccionada
                $(this).prop("selected", true);

                // Si estás utilizando un selectpicker de Bootstrap, actualiza el selectpicker
                $('#txt-departamentos').selectpicker('refresh');

                // Romper el bucle porque ya encontramos la opción deseada
                return false;
            }
        });
    }
}

function set_selected_categoria() {
    if (categoria != 'all') {

        // Nombre del atributo que deseas seleccionar
        let nombreAtributoDeseado = categoria;

        // Iterar sobre las opciones del select
        $("#txt-categorias option").each(function () {
            // Obtener el valor del atributo data-nombre-atributo
            let nombreAtributo = $(this).attr("namecategoria");

            // Verificar si el nombre del atributo coincide
            if (nombreAtributo === nombreAtributoDeseado) {
                // Establecer la opción como seleccionada
                $(this).prop("selected", true);

                // Si estás utilizando un selectpicker de Bootstrap, actualiza el selectpicker
                $('#txt-categorias').selectpicker('refresh');

                // Romper el bucle porque ya encontramos la opción deseada
                return false;
            }
        });
    }
}

function set_selected_empresa() {
    if (empresa != 'all') {

        // Nombre del atributo que deseas seleccionar
        let nombreAtributoDeseado = empresa;

        // Iterar sobre las opciones del select
        $("#txt-empresas option").each(function () {
            // Obtener el valor del atributo data-nombre-atributo
            let nombreAtributo = $(this).attr("nameempresa");

            // Verificar si el nombre del atributo coincide
            if (nombreAtributo === nombreAtributoDeseado) {
                // Establecer la opción como seleccionada
                $(this).prop("selected", true);

                // Si estás utilizando un selectpicker de Bootstrap, actualiza el selectpicker
                $('#txt-empresas').selectpicker('refresh');

                // Romper el bucle porque ya encontramos la opción deseada
                return false;
            }
        });
    }
}

function cb_categories() {
    $("#txt-categorias").find("option").remove().end() // delete options
    $.ajax({
        type: "GET",
        url: '/alumno/postulaciones/categorias',
        dataType: 'json',
        beforeSend: function () { },
        success: function (response) {
            $("#txt-categorias").append('<option selected value="all" namecategoria="all">Todas las categorías</option>');
            response.forEach((elemento) => {
                $("#txt-categorias").append('<option' +
                    ' value="' + elemento.idcategory + '" ' +
                    ' namecategoria="' + elemento.nombre + '" ' +
                    '>' + elemento.nombre + '</option>');
            })
            $("#txt-categorias").selectpicker("refresh");
            set_selected_categoria();   // set selected categoria
        },
        error: function (error) {
            console.log("Error", error);
        },
    });
}


function cb_companies() {
    $("#txt-empresas").find("option").remove().end() // delete options
    $.ajax({
        type: "GET",
        url: '/alumno/postulaciones/empresas',
        dataType: 'json',
        beforeSend: function () { },
        success: function (response) {
            $("#txt-empresas").append('<option selected value="all" nameempresa="all">Todas las empresas</option>');
            response.forEach((elemento) => {
                $("#txt-empresas").append('<option' +
                    ' value="' + elemento.idcompany + '" ' +
                    ' nameempresa="' + elemento.nombre + '" ' +
                    '>' + elemento.nombre + '</option>');
            })
            $("#txt-empresas").selectpicker("refresh");
            set_selected_empresa();     // set selected empresa
        },
        error: function (error) {
            console.log("Error", error);
        },
    });
}

$('#modo-vista-1').click(function (e) {
    e.preventDefault();
    clean_infopreview();
});
$('#modo-vista-2').click(function (e) {
    e.preventDefault();
    clean_infopreview();
});


// this function will be executed on click of X (clear button)
$('input[type=search]').on('search', function () {
    buscar = 'default';
    obtener_cantidad();             // actualizar navegacion
    listar_ofertas_laborales();     // actualizar ofertas
    actualizarURL();                // actualizar url
});
