// resources/js/alumno/matricula.js
import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";
import { languageSchema } from "../common/schemas.js";
import { tl_semesters } from "../common/timeline/semesters.js";
import { cb_periods_all } from "../common/combobox/periodos.js";

$(document).ready(function () {

    let dt_idsemester = "0";
    let formData;

    // LISTAR DATATABLE (matriculados)
    const table = $("#datatableGeneral").DataTable({
        createdRow: function (row) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/alumno/matricula/list",
            data: function (d) {
                d.idsemester = dt_idsemester;
            },
        },
        searching: false,
        pageLength: 10,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        buttons: [],
        language: languageSchema,
        columns: [
            { data: "idsubject", className: "text-center" },
            {
                data: "periodo",
                className: "text-center",
                render: function (_d, _t, all) {
                    return integer_to_roman(all.periodo);
                },
            },
            { data: "curso", className: "text-center" },
            { data: "seccion", className: "text-center" },
            { data: "turno", className: "text-center" },
            { data: "tipo_asignatura", className: "text-center" },
            {
                data: "idsubjectenrollment",
                sortable: false,
                className: "text-center",
                render: function (_d, _t, all) {
                    if (all.idsubjectenrollment != "0") {
                        return `
              <div class="d-flex justify-content-center">
                <a href="javascript:void(0);" class="btnDesmatricular btn btn-danger shadow btn-xs sharp"
                   data-idsubjectenrollment="${all.idsubjectenrollment}"
                   title="Desmatricular">
                   <i class="fas fa-user-xmark fa-lg"></i>
                </a>
              </div>`;
                    }
                    return `<div class="d-flex justify-content-center">--</div>`;
                },
            },
        ],
    });

    // Primera columna numerada
    table.on("order.dt search.dt", function () {
        table
            .column(0, { search: "applied", order: "applied" })
            .nodes()
            .each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
    }).draw();

    // Tarjeta info: estado inicial
    $("#cardInformacionContent").hide();
    $("#defaultMessage").show();


    // Seleccionar periodo lectivo
    $("#tlsemester").on("click", ".btnSemester", function () {
        const isActive = String($(this).attr("data-estado")) === "1"; // activo = true, inactivo = false
        const $btn = $("#btnCreateModal"); // botón prematricular
        $btn.prop("disabled", !isActive); // deshabilitar si el periodo lectivo inactivo
        $btn.attr("title", isActive ? "Prematricular en el periodo seleccionado" : "Seleccione un periodo ACTIVO para prematricular");

        dt_idsemester = String($(this).data("idsemester"));
        $("#txt-idsemester").val(dt_idsemester);

        // Visual
        $(".divsemester").removeClass("dark").addClass("primary");
        $(this).prev(".divsemester").removeClass("primary").addClass("dark");

        notificaciontoast("info", "Consultando a la base de datos!", "Mensaje!");
        table.ajax.reload();

        cargarInformacion(dt_idsemester);

        if (!isActive) {
            notificaciontoast(
                "warning",
                "Este semestre está INACTIVO. No puedes prematricular.",
                "Aviso"
            );
        }
    });


    // Cargar información de periodo (tarjeta)
    function cargarInformacion(semestreId) {
        $("#cardLoader").show();
        $("#cardInformacionContent").hide();
        $("#defaultMessage").hide();

        $.ajax({
            url: "/semestre/" + semestreId + "/informacion",
            type: "GET",
            beforeSend: function () {
                $("#cardLoader").show();
                $("#cardInformacionContent").hide();
                $("#defaultMessage").hide();
            },
            success: function (response) {
                if (response.status === "success" && response.informacion) {
                    $("#cardInformacionContent").html(response.informacion);
                } else {
                    $("#cardInformacionContent").html("No hay información disponible.");
                }
                $("#cardLoader").hide();
                $("#cardInformacionContent").show();
            },
            error: function () {
                $("#cardInformacionContent").html(
                    "Hubo un error al cargar la información. Intenta nuevamente."
                );
                $("#cardLoader").hide();
                $("#cardInformacionContent").show();
            },
        });
    }

    // Desmatricular
    $("#datatableGeneral tbody").on("click", ".btnDesmatricular", function () {
        const idsubjectenrollment = $(this).data("idsubjectenrollment");
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a desmatricular al alumno del curso",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) destroy(idsubjectenrollment);
        });
    });

    // Doble seguro: abrir modal solo si está habilitado
    $("#btnCreateModal").on("click", function (event) {
        if ($(this).prop("disabled")) {
            event.preventDefault();
            notificaciontoast(
                "warning",
                "Debes seleccionar un periodo ACTIVO.",
                "Aviso"
            );
            return;
        }
        table2.ajax.reload();
        $("#modalCursos").modal("show");
    });

    function store() {
        formData = new FormData(document.getElementById("formModal"));
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/alumno/matricula/store",
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                if (data.status) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy(idsubjectenrollment) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/alumno/matricula/destroy/" + idsubjectenrollment,
            success: function (data) {
                if (data.status) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LISTAR DATATABLE (cursos disponibles para prematricular)
    const table2 = $("#datatableGeneral2").DataTable({
        createdRow: function (row) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/alumno/matricula/list_available_courses",
            data: function (d) {
                d.idsemester = dt_idsemester;                 // semestre seleccionado
                d.period_id = $('#txt-periods').val() || null; // ⬅️ filtro por periodo
            },
        },
        searching: false,
        paging: false,
        info: false,
        pageLength: 10,
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: [],
        columns: [
            { data: "idsubject", className: "text-center" },
            {
                data: "periodo",
                className: "text-center",
                render: function (_d, _t, all) {
                    return integer_to_roman2(all.periodo);
                },
            },
            { data: "curso", className: "text-center" },
            { data: "seccion", className: "text-center" },
            { data: "turno", className: "text-center" },
            { data: "tipo_asignatura", className: "text-center" },
            {
                data: "idsubjectenrollment",
                sortable: false,
                className: "text-center",
                render: function (_d, _t, all) {
                    return `
                <div class="d-flex justify-content-center">
                  <a href="javascript:void(0);" class="btnMatricular btn btn-success shadow btn-xs sharp me-2"
                     data-idsubject="${all.idsubject}"
                     title="Prematricular">
                     <i class="fa-solid fa-check fa-lg"></i>
                  </a>
                </div>`;
                },
            },
        ],
    });

    // Numeración en tabla 2
    table2.on("order.dt search.dt", function () {
        table2
            .column(0, { search: "applied", order: "applied" })
            .nodes()
            .each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
    }).draw();

    $('#txt-periods')
        .on('changed.bs.select', function () {
            table2.ajax.reload();   // recarga con el nuevo period_id
        })
        .on('change', function () { // respaldo por si no dispara el de bootstrap-select
            table2.ajax.reload();
        });

    $(function () {
        if ($('.selectpicker').length && $.fn.selectpicker) {
            $('.selectpicker').selectpicker();
        }
    });

    $('#modalCursos').on('shown.bs.modal', function () {
        cb_periods_all(dt_idsemester); // ← filtra por periodo actual
        const $sel = $('#txt-periods');
        if ($sel.hasClass('selectpicker') && $.fn.selectpicker) {
            $sel.selectpicker('render');
        }
    });

    // Matricular (prematricular)
    $("#datatableGeneral2 tbody").on("click", ".btnMatricular", function () {
        const idsubject = $(this).data("idsubject");
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a matricular al alumno al curso",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                $("#txt-idsubject").val(idsubject);
                // #txt-idsemester ya se setea al seleccionar el periodo
                store();
            }
        });
    });

    // Utils: números romanos
    function integer_to_roman(num) {
        if (typeof num !== "number") return false;
        const digits = String(+num).split("");
        const key = [
            "",
            "C",
            "CC",
            "CCC",
            "CD",
            "D",
            "DC",
            "DCC",
            "DCCC",
            "CM",
            "",
            "X",
            "XX",
            "XXX",
            "XL",
            "L",
            "LX",
            "LXX",
            "LXXX",
            "XC",
            "",
            "I",
            "II",
            "III",
            "IV",
            "V",
            "VI",
            "VII",
            "VIII",
            "IX",
        ];
        let roman_num = "",
            i = 3;
        while (i--) roman_num = (key[+digits.pop() + i * 10] || "") + roman_num;
        return Array(+digits.join("") + 1).join("M") + roman_num;
    }

    function integer_to_roman2(num) {
        return integer_to_roman(num);
    }
});
