let calendar = null
let dt_idsemester = 0

$(document).ready(function () {
  // 1. Inicializar FullCalendar
  const calendarEl = document.getElementById('calendar')

  calendar = new FullCalendar.Calendar(calendarEl, {
    locale: 'es',
    initialView: 'timeGridWeek',
    height: 'auto',
    allDaySlot: false,

    headerToolbar: {
      left: 'prev,next today',
      center: 'title',
      right: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
    },

    buttonText: {
      today: 'Hoy',
      month: 'Mes',
      week: 'Semana',
      day: 'Día',
      list: 'Lista'
    },

    // Horario completo de 00 a 24
    slotMinTime: '00:00:00',
    slotMaxTime: '24:00:00',

    events: [],

    eventClick(info) {
      const e = info.event
      const props = e.extendedProps || {}

      // Siempre: título y fechas
      $('#event-title').text(e.title)
      $('#event-start').text(e.start ? e.start.toLocaleString() : '--')
      $('#event-end').text(e.end ? e.end.toLocaleString() : '--')

      // Reset de visibilidad
      $('#group-curso').show()
      $('#group-fechas').show()
      $('#group-aula-docente').show()
      $('#group-turno-seccion').show()
      $('#group-condicion').show()
      $('#group-foro-descripcion').addClass('d-none')
      $('#event-descripcion-foro').text('')

      if (props.tipoEvento === 'foro') {
        // 👉 Evento de FORO
        $('#event-modal-title').text('Detalle del foro')

        // Para el foro solo nos interesa la descripción
        $('#group-aula-docente').hide()
        $('#group-turno-seccion').hide()
        $('#group-condicion').hide()

        $('#group-foro-descripcion').removeClass('d-none')
        $('#event-descripcion-foro').text(props.descripcion ?? '')
      } else {
        // 👉 Evento de CLASE
        $('#event-modal-title').text('Detalle del curso')

        $('#event-aula').text(props.aula ?? '')
        $('#event-docente').text(props.docente ?? '')
        $('#event-turno').text(props.turno ?? '')
        $('#event-seccion').text(props.seccion ?? '')
        $('#event-condicion').text(props.condicion ?? '')
      }

      const modalEl = document.getElementById('eventDetailModal')
      const modal = new bootstrap.Modal(modalEl)
      modal.show()
    },

    selectable: false,
    editable: false
  })

  calendar.render()

  // 2. Cargar combo de semestres (para estudiantes)
  cb_semesters()

  // 3. Cambio de semestre → cargar horario en el calendario
  $('#txt_semestre').on('change', function () {
    toastr.info('Consultando en la base de datos ....', 'Mensaje', {
      positionClass: 'toast-bottom-right',
      timeOut: 2000,
      closeButton: !0,
      debug: !1,
      newestOnTop: !0,
      progressBar: !0,
      preventDuplicates: !0,
      onclick: null,
      showDuration: '300',
      hideDuration: '1000',
      extendedTimeOut: '1000',
      showEasing: 'swing',
      hideEasing: 'linear',
      showMethod: 'fadeIn',
      hideMethod: 'fadeOut',
      tapToDismiss: !1
    })

    dt_idsemester = $(this).val()
    $('#txt-idsemester').val(dt_idsemester)

    loadSchedule(dt_idsemester)
  })
})

// ----------- FUNCIONES ------------- //

function cb_semesters() {
  $('#txt_semestre').find('option').remove().end()
  $.ajax({
    type: 'GET',
    url: '/ajax_all/semestersStudent',
    dataType: 'json',
    success: function (response) {
      $('#txt_semestre').append(
        '<option selected disabled value="">Seleccione Periodo Lectivo</option>'
      )
      response.forEach((elemento) => {
        $('#txt_semestre').append(
          '<option' +
            ' value="' +
            elemento.id +
            '" ' +
            ' data-anho="' +
            elemento.anho +
            '" ' +
            ' data-numero="' +
            elemento.numero +
            '" ' +
            ' data-fecinicio="' +
            elemento.fecinicio +
            '" ' +
            ' data-fecfin="' +
            elemento.fecfin +
            '" ' +
            '>' +
            elemento.anho +
            ' - ' +
            elemento.numero +
            '</option>'
        )
      })
      $('#txt_semestre').selectpicker('refresh')
    },
    error: function (error) {
      console.log('Error', error)
    }
  })
}

/**
 * Carga el horario del estudiante y lo pasa al calendario
 */
function loadSchedule(idSemester) {
  if (!idSemester) return

  $.ajax({
    type: 'POST',
    url: '/alumno/horarios/list_horario',
    headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
    data: {
      idsemester: idSemester
    },
    dataType: 'json',
    success: function (response) {
      // Horarios (clases) vienen en response.data (por DataTables)
      const rows = response.data ?? response

      // Foros agregados desde el backend con ->with('foros', $foros)
      const foros = response.foros ?? []

      const eventsClases = buildEventsFromRowsAlumno(rows)
      const eventsForos = buildEventsFromForosAlumno(foros)

      calendar.removeAllEvents()
      calendar.addEventSource(eventsClases)
      calendar.addEventSource(eventsForos)
    },
    error: function (error) {
      console.log('Error al cargar horarios', error)
    }
  })
}

/**
 * Convierte la fila del horario de estudiante en eventos FullCalendar
 * Columnas por día: Lunes, Martes, Miercoles, Jueves, Viernes, Sabado
 * Valores: "08:00 - 10:00, 15:00 - 17:00" o "-" si no hay.
 */
function buildEventsFromRowsAlumno(rows) {
  if (!Array.isArray(rows)) return []

  const dayMap = {
    Lunes: 1,
    Martes: 2,
    Miercoles: 3,
    Jueves: 4,
    Viernes: 5,
    Sabado: 6
  }

  const events = []

  rows.forEach((row) => {
    const titleBase = `${row.codcurso} - ${row.curso}`.trim()

    Object.keys(dayMap).forEach((dayName) => {
      const dayNum = dayMap[dayName]
      const value = row[dayName]

      if (!value || value === '-' || value === '') return

      // Puede haber varios rangos separados por coma
      const ranges = value.split(',')
      ranges.forEach((rangeRaw) => {
        const range = rangeRaw.trim()
        if (!range) return

        // formato "HH:MM - HH:MM"
        const [start, end] = range.split('-').map((s) => s.trim())

        if (!start || !end) return

        events.push({
          title: titleBase,
          daysOfWeek: [dayNum], // evento recurrente semanal
          startTime: start,
          endTime: end,
          extendedProps: {
            periodo: row.periodo,
            tipo: row.tipo,
            condicion: row.condicion,
            turno: row.turno,
            seccion: row.seccion,
            aula: row.aula,
            docente: row.docente
          }
        })
      })
    })
  })

  return events
}

/**
 * Convierte los foros del estudiante en eventos FullCalendar
 * Usa start_calendar y end_calendar preparados en el backend.
 */
function buildEventsFromForosAlumno(foros) {
  if (!Array.isArray(foros)) return []

  return foros.map((f) => ({
    title: `[Foro] ${f.codcurso} - ${f.titulo}`,
    start: f.start_calendar, // ej: "2025-01-09 23:00:00"
    end: f.end_calendar, // ej: "2025-01-09 23:59:00"
    allDay: false,
    extendedProps: {
      tipoEvento: 'foro',
      descripcion: f.descripcion,
      curso: f.curso,
      codcurso: f.codcurso,
      fecinicio: f.fecinicio,
      fecfin: f.fecfin
    }
  }))
}
