"use strict";
import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../common/schemas.js";

$(document).ready(function () {

    $.ajax({
        type: "GET",
        url: '/home/student/dataAsignaturas',
        dataType: 'json',
        success: function (response) {
            if (response.status === true) {
                if (response.data.length > 0) {
                    let html = '';
                    let count = 1;
                    response.data.forEach((e) => {
                        html += `<li>
                                    <div class="timeline-badge info">
                                    </div>
                                    <a class="timeline-panel text-muted" href="#">
                                        <h4 class="mb-0">${e.curso}</h4>
                                        <h6 class="mb-0">Código: <strong class="text-primary">${e.codcurso}</strong> </h6>
                                        <span><strong class="text-info"> Periodo: ${e.periodo} - Créditos: ${e.creditos} </strong></span>
                                        <p class="mb-0">Periodo Lectivo: ${e.semestro} - Tipo: ${e.tipo}</p>
                                    </a>
                                </li>`;
                                count++;
                    });
                    document.getElementById("total_asign").innerHTML = "Total: "+count;
                    document.getElementById("list_asignaturas").innerHTML = html;
                }
            }
        },
        error: function (error) {
            console.log("Error", error);
        },
    });

    let tableName = "Historial de asignaturas de estudiante";
    var datatableGeneral = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            type: 'GET',
            url: '/home/student/list_history_cursos',
        },
        pageLength: 12, // 12 filas
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "semestre", className: "text-start",
                render: function (data, type, all, meta) {
                    return `<div class="timeline-panel text-muted">
                                <span><strong class="text-info">Periodo Lectivo: ${all.semestre}</strong></span>
                            </div>`
                },
                name: "primero",
            },
            { data: "periodo", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return (all.periodo);
                },
            },
            { data: "codcurso", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return (all.codcurso);
                },
            },
            { data: "curso", sortable: false, className: "text-start",
                render: function (data, type, all, meta) {
                    return (all.curso);
                },
            },
            { data: "docente", sortable: false, className: "text-start",
                render: function (data, type, all, meta) {
                    return (all.docente);
                },
            },
            { data: "seccion", sortable: false, className: "text-start",
                render: function (data, type, all, meta) {
                    return (all.seccion);
                },
            },
            { data: "turno", sortable: false, className: "text-start",
                render: function (data, type, all, meta) {
                    return (all.turno);
                },
            },
            { data: "creditos", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return (all.creditos);
                },
            },
            { data: "horas", sortable: false, className: "text-start",
                render: function (data, type, all, meta) {
                    return (all.horas);
                },
            },
            { data: "silabo", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.silabo == null) {
                        return "--";
                    } else if (all.silabo == "--") {
                        return `<div class="d-flex justify-content-center"> -- </div>`;
                        return all.silabo;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verSilabo/${all.idsubject}" class="btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Documento">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            { data: "instrumentos_evaluacion", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.instrumentos_evaluacion == null) {
                        return "--";
                    } else if (all.instrumentos_evaluacion == "--") {
                        return `
                        <div class="d-flex justify-content-center">
                            ${all.instrumentos_evaluacion}
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verInstrumentosEvaluacion/${all.idsubject}" class="btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Documento">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            // { data: "notalumno", sortable: false, className: "text-center",
            //     render: function (data, type, all, meta) {
            //         return (all.notalumno);
            //     },
            // },
            // { data: "notalumno", sortable: false, className: "text-center",
            //     render: function (data, type, all, meta) {
            //         if (parseInt(all.notalumno) === 0) {
            //             return `<span class="badge light badge-secondary">Sin nota</span>`;
            //         } else if (parseInt(all.notalumno) >= 5 && parseInt(all.notalumno) <= 10.4) {
            //             return `<span class="badge light badge-danger">Desaprobado</span>`;
            //         } else if (parseInt(all.notalumno) >= 10.5 && parseInt(all.notalumno) <= 20) {
            //             return `<span class="badge light badge-primary">Aprobado</span>`;
            //         }
            //     },
            // }
        ],
        rowsGroup: [
            'primero:name',
        ],
        orderFixed: [0, 'asc'], // Fija el orden por defecto de la primera columna
    });

});

