import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";

$(document).ready(function () {

    $('#modalfinalizado').modal({
        backdrop: 'static', // Evita que se cierre al hacer clic fuera del modal
        keyboard: false     // Evita que se cierre al presionar la tecla ESC
    });

    let formRespuestas;
    // Crear o actualizar publicación
    function SendEncuesta() {
        formRespuestas = $("#formRespuestas");

        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/guardar-respuestas", // Verifica que esta URL esté correcta
            data: formRespuestas.serialize(),
            dataType: "json",
            beforeSend: () => {
                console.log("Enviando datos...");
            },
            success: (data) => {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalfinalizado").modal("show");
                    }, 1150);
                    setTimeout(function () {
                        window.location = '/home/student'
                    }, 2150);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: (jqXHR, textStatus, errorThrown) => {
                console.log(jqXHR, textStatus, errorThrown);
                if (jqXHR.status === 422) {
                    // Manejo de errores de validación
                    const errors = jqXHR.responseJSON.errors;
                    for (const key in errors) {
                        notificaciontoast(
                            "error",
                            errors[key][0],
                            "Error de Validación"
                        );
                    }
                } else if (jqXHR.status === 0) {
                    // Error de red (por ejemplo, conexión fallida)
                    notificaciontoast(
                        "error",
                        "Error de conexión. Verifica tu red o el servidor.",
                        "Error de Red"
                    );
                } else {
                    // Manejo de errores generales
                    console.error("Error inesperado:", jqXHR);
                    notificaciontoast(
                        "error",
                        "Ocurrió un error inesperado. Inténtalo nuevamente.",
                        "Error!"
                    );
                }
            },
        });
    }

    $("#btn_ResponseQuestions").on("click", function (e) {
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a enviar la encuesta",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                SendEncuesta();
            } else {
                console.log("Cancelado");
            }
        });
    });
});
