import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../common/schemas.js";

$(document).ready(function () {
    $("#btn-querydata").on("click", function (event) {
        event.preventDefault();

        if (document.getElementById("txt_nroidenti").value == "") {
            notificaciontoast(
                "error",
                "Ingrese # de identificación",
                "Mensaje!"
            );
            // setear data de programa
            $("#txt_nroidenti").addClass("border border-danger shadow");
            setTimeout(function () {
                document.getElementById("txt_nroidenti").focus();
                $("#txt_nroidenti").removeClass("border border-danger shadow");
            }, 1500);
        } else {
            var nroidenti = $("#txt_nroidenti").val();
            $.ajax({
                type: "GET",
                url: "/modulo/page/egresado/query_data/" + nroidenti,
                dataType: "json",
                beforeSend: function () {
                    notificaciontoast("warning", "Consultando!", "Mensaje!");
                },
                success: function (response) {
                    if (response.status === true) {
                        notificaciontoast("info", response.mensaje, "Éxito!");
                        $("#txt_nombres").val(response.data[0].nombres);
                        $("#txt_apellido_pa").val(response.data[0].apellido_pa);
                        $("#txt_apellido_ma").val(response.data[0].apellido_ma);
                        $("#txt_dni").val(response.data[0].nroidenti);
                        $("#txt_carrera").val(response.data[0].programa);
                        $("#txt_ingreso").val(response.data[0].anho_ingreso);
                        $("#txt_domicilio").val(response.data[0].direccion);
                        $("#txt_correo").val(response.data[0].correo);
                        $("#txt_celular").val(response.data[0].celular);
                        $("#txt_direccion").val(response.data[0].direccion);

                        $("#txt_trabaja").selectpicker(
                            "val",
                            response.data[0].flg_trabaja
                        );
                        $("#txt_rubro").val(response.data[0].rubro_empresa);
                        $("#txt_jefe").val(response.data[0].nombre_jefe);
                        $("#txt_formacontrato").val(
                            response.data[0].forma_contrato
                        );
                        $("#txt_tipoempresa").val(
                            response.data[0].forma_contrato
                        );
                        $("#txt_nomempresa").val(response.data[0].empresa);
                        $("#txt_remuneracion").val(
                            response.data[0].ingreso_mensual
                        );
                        $("#txt_civil").val(response.data[0].estado_civil);
                        $("#txt_numhijos").val(response.data[0].nro_hijos);
                        $("#txt_tipovivienda").val(
                            response.data[0].tipovivienda
                        );
                        $("#txt_cargo").val(response.data[0].ocupacion);
                        $("#txt_gastos").val(response.data[0].gastos_mensuales);
                        
                        $("#txt_anteriormente").val(
                            response.data[0].flg_antes_trabajaba
                        );
                        $("#txt_negativopositivo").val(
                            response.data[0].meses_no_trabaja
                        );
                        $("#txt_porque").val(response.data[0].explicacion);
                        $("#txt_explicacionlaboral").val(
                            response.data[0].form_prof_recibida
                        );
                        $("#txt_satisface").val(
                            response.data[0].carrera_satis_necesi
                        );
                        $("#txt_beneficiado").val(
                            response.data[0].area_carrera_profesiona_beneficiado
                        );
                        $("#txt_conforme").val(
                            response.data[0].satisfecho_form_institu_brindo
                        );
                        $("#txt_motivos").val(
                            response.data[0]
                                .motivos_satisfecho_form_institu_brindo
                        );
                        $("#txt_motivos_razon").val(
                            response.data[0].razon_form_institu_brindo
                        );

                        $("#hidden_student").val(response.data[0].id);

                        // setear data de programa
                        $("#txt_tipoUser_consulta").addClass("text-primary");
                        $("#txt_nombres").addClass("border border-info shadow");
                        $("#txt_apellido_pa").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_apellido_ma").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_dni").addClass("border border-info shadow");
                        $("#txt_carrera").addClass("border border-info shadow");
                        $("#txt_ingreso").addClass("border border-info shadow");
                        $("#txt_domicilio").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_correo").addClass("border border-info shadow");
                        $("#txt_celular").addClass("border border-info shadow");

                        $("#txt_trabaja").addClass("border border-info shadow");
                        $("#txt_rubro").addClass("border border-info shadow");
                        $("#txt_jefe").addClass("border border-info shadow");
                        $("#txt_formacontrato").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_tipoempresa").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_nomempresa").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_remuneracion").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_civil").addClass("border border-info shadow");
                        $("#txt_numhijos").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_tipovivienda").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_cargo").addClass("border border-info shadow");
                        $("#txt_gastos").addClass("border border-info shadow");

                        $("#txt_anteriormente").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_negativopositivo").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_porque").addClass("border border-info shadow");
                        $("#txt_explicacionlaboral").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_satisface").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_beneficiado").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_conforme").addClass(
                            "border border-info shadow"
                        );
                        $("#txt_motivos").addClass("border border-info shadow");
                        $("#txt_gastos").addClass("border border-info shadow");
                        $("#txt_motivos_razon").addClass(
                            "border border-info shadow"
                        );

                        setTimeout(function () {
                            clearClasses();
                        }, 1000);
                    } else {
                        console.log(response.data);
                        notificaciontoast("error", response.mensaje, "Error!");
                    }
                },
                error: function (error) {
                    console.log("Error", error);
                },
            });
        }
    });

    // store
    $("#btnSavetramitedoc").on("click", function (event) {
        event.preventDefault();
        var formData = new FormData(document.getElementById("form"));
        console.log(formData);
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/modulo/page/egresado/store",
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                notificaciontoast(
                    "warning",
                    "Validando información!",
                    "Mensaje!"
                );
            },
            success: function (response) {
                console.log(response.status);
                console.log(response);
                if (response.status == true) {
                    notificaciontoast("info", response.mensaje, "Éxitos!");
                    $("#hidden_student").val("");
                }
            },
            error: function (error) {
                notificaciontoast("error", error, "Error!");
            },
        });
    });

    function clearClasses() {
        // limpiar clases
        $("#txt_nombres").removeClass("border border-info shadow");
        $("#txt_apellido_pa").removeClass("border border-info shadow");
        $("#txt_apellido_ma").removeClass("border border-info shadow");
        $("#txt_dni").removeClass("border border-info shadow");
        $("#txt_carrera").removeClass("border border-info shadow");
        $("#txt_ingreso").removeClass("border border-info shadow");
        $("#txt_domicilio").removeClass("border border-info shadow");
        $("#txt_correo").removeClass("border border-info shadow");
        $("#txt_celular").removeClass("border border-info shadow");
        $("#txt_trabaja")
            .closest(".bootstrap-select")
            .removeClass("border border-info shadow");
        $("#txt_rubro").removeClass("border border-info shadow");
        $("#txt_jefe").removeClass("border border-info shadow");
        $("#txt_formacontrato").removeClass("border border-info shadow");
        $("#txt_tipoempresa").removeClass("border border-info shadow");
        $("#txt_nomempresa").removeClass("border border-info shadow");
        $("#txt_remuneracion").removeClass("border border-info shadow");
        $("#txt_civil").removeClass("border border-info shadow");
        $("#txt_numhijos").removeClass("border border-info shadow");
        $("#txt_tipovivienda").removeClass("border border-info shadow");
        $("#txt_cargo").removeClass("border border-info shadow");
        $("#txt_gastos").removeClass("border border-info shadow");

        $("#txt_anteriormente").removeClass("border border-info shadow");
        $("#txt_negativopositivo").removeClass("border border-info shadow");
        $("#txt_porque").removeClass("border border-info shadow");
        $("#txt_explicacionlaboral").removeClass("border border-info shadow");
        $("#txt_satisface").removeClass("border border-info shadow");
        $("#txt_beneficiado").removeClass("border border-info shadow");
        $("#txt_conforme").removeClass("border border-info shadow");
        $("#txt_motivos").removeClass("border border-info shadow");
        $("#txt_gastos").removeClass("border border-info shadow");
        $("#txt_motivos_razon").removeClass("border border-info shadow");

        // $("#txt_rubro").siblings('button[type="button"]').removeClass("border border-info shadow");
        // $("#txt_provincia").closest('.bootstrap-select').removeClass("border border-info shadow");
    }
});
