import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../common/schemas.js";

$(document).ready(function () {

    var valbtn, formCheck, formModal;
    var iduser, identificacion, user, fecnac, correo, telefono, celular, 
        genero, direccion, iddepartamento, departamento, provincia, distrito;

    // INICIO - MODAL UPDATE
    $("#editBtn").on("click", function (e) {
        clearCheck();
        // setear data de usuario
        $("#txt_iduser").val(iduser);
        $("#txt_identificacion").val(identificacion);
        $("#txt_user").val(user);
        $("#txt_fecnac").val(fecnac);
        $("#txt_correo").val(correo);
        $("#txt_telefono").val(telefono);
        $("#txt_celular").val(celular);
        $("#txt_genero").val(genero);
        $("#txt_direccion").val(direccion);

        // ubigeo
        $("#txt_departamento").selectpicker("val", iddepartamento);
        let sl_departamento = departamento;
        let sl_provincia = provincia;
        let sl_distrito = distrito;
        ubigeo_for_update(sl_departamento, sl_provincia, sl_distrito);
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        $("#btnCreateUpdate").attr("value", "Update");
    });
    // FIN - MODAL UPDATE


    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
        } else {
            update();
        }
    });
    // FIN - FUNCION CREATE O UPDATE


    // INICIO - MODAL UPDATE PASSWORD
    $("#passwordBtn").on("click", function (e) {
        // borrar validaciones
        formCheck = $("#formModal2")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        // setear data de usuario
        $("#txt_iduser2").val(iduser);
        $("#txt_identificacion2").val(identificacion);
        $("#txt_user2").val(user);
        $("#txt_password1").val("");
        $("#txt_password2").val("");
        // show form
        $("#modalUpdatePassword").modal("show");
    });
    // FIN - MODAL UPDATE PASSWORD


    // INICIO - FUNCION UPDATE PASSWORD
    $("#btnUpdatePassword").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal2")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            update_password($("#txt_iduser2").val());
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION UPDATE PASSWORD


    data_user();
    function data_user() {
        $.ajax({
            type: "GET",
            url: '/student/profile/data',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("data-apnom").innerHTML = elemento.user;
                    document.getElementById("data-programa").innerHTML = elemento.programa;
                    document.getElementById("data-nivel_formativo").innerHTML = elemento.nivel_formativo;
                    document.getElementById("data-plan").innerHTML = elemento.plan;
                    document.getElementById("data-tipo").innerHTML = elemento.tipo;
                    document.getElementById("data-anho_ingreso").innerHTML = elemento.anho_ingreso;
                    $("#data-tipoidenti").val(elemento.tipoidenti);
                    $("#data-nroidenti").val(elemento.nroidenti);
                    $("#data-fecnac").val(elemento.fecnac);
                    $("#data-genero").val(elemento.genero);
                    $("#data-correo").val(elemento.correo);
                    $("#data-telefono").val(elemento.telefono);
                    $("#data-celular").val(elemento.celular);
                    $("#data-direccion").val(elemento.direccion);
                    $("#data-departamento").val(elemento.departamento);
                    $("#data-provincia").val(elemento.provincia);
                    $("#data-distrito").val(elemento.distrito);


                    iduser = elemento.iduser;
                    identificacion = elemento.identificacion;
                    user = elemento.user;
                    fecnac = elemento.fecnac;
                    correo = elemento.correo;
                    telefono = elemento.telefono;
                    celular = elemento.celular;
                    genero = elemento.genero;
                    direccion = elemento.direccion;

                    // ubigeo
                    iddepartamento = elemento.iddepartamento;
                    departamento = elemento.departamento;
                    provincia = elemento.provincia;
                    distrito = elemento.distrito;
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update() {
        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/student/profile/update',
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    data_user();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    // const password = document.getElementById('txt_password1').value;
    function update_password() {
        formModal = $('#formModal2');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/student/profile/update_password',
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalUpdatePassword").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
    }

});


