import { notificaciontoast } from '../common/method_toast.js'

$(document).ready(function () {
  const tableName = 'Historial Asistencias'

  //LISTAR DATATABLE
  var dt_idsemester = 0,
    dt_idsubject = 0

  // 1. CARGAR SEMESTRE ACTIVO
  loadCurrentSemester()

  function loadCurrentSemester() {
    $.ajax({
      type: 'GET',
      url: '/current_active/semesters',
      dataType: 'json',
      success: function (sem) {
        if (!sem || !sem.id) {
          $('#currentSemesterLabel').html(
            ` <span class="text-danger">No se encontró un periodo activo</span>`
          )
          return
        }

        // Asignar ID al filtro global
        dt_idsemester = sem.id

        // Mostrar periodo (ya viene concatenado)
        $('#currentSemesterLabel').html(
          ` <span class="text-primary">${sem.semestre}</span>`
        )

        // Cargar asignaturas
        tl_subjects()

        // Recargar tabla
        table.ajax.reload()
      },
      error: function (error) {
        console.log('Error cargando semestre activo:', error)
      }
    })
  }

  // 2. DATATABLE
  var table = $('#datatableGeneral').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    pageLength: 16,
    ajax: {
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: 'POST',
      url: '/alumno/asistencias/list_attendances',
      data: function (d) {
        ;(d.idsemester = dt_idsemester), (d.idsubject = dt_idsubject)
      }
    },
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacia.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    buttons: [
      {
        extend: 'excel',
        title: function () {
          return 'Reporte de Horarios ' + semester
        },
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'pdf',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded ',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'print',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'colvis',
        text: 'Seleccionar celdas',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      }
    ],
    columns: [
      { data: 'clase', className: 'text-center bg-primary' },
      { data: 'fecha', className: 'text-center bg-primary' },
      {
        data: 'estado',
        sortable: false,
        className: 'text-center',
        render: function (data, type, all, meta) {
          if (all.estado == 0) {
            return `<span class="badge light badge-dark">Sin evaluar</span>`
          } else if (all.estado == 1) {
            return `<span class="badge light badge-success">Asistió</span>`
          } else if (all.estado == 2) {
            return `<span class="badge light badge-warning">Tardanza</span>`
          } else if (all.estado == 3) {
            return `<span class="badge light badge-danger">No Asistió</span>`
          }
        }
      },
      {
        data: 'id_zoom_meeting, account_id, client_id, client_secret',
        orderable: false,
        className: 'text-center',
        sortable: false,
        searchable: false,
        render: function (data, type, row) {
          // Verificar si los datos necesarios están presentes en la fila (row)
          if (row.id_zoom_meeting == null || row.id_zoom_meeting == undefined) {
            return `<span class="badge light badge-dark">Sin reunión registrada</span>`
          } else {
            return `
							<button class="btn btn-success btn-sm mx-1"
								onclick="joinZoomMeeting('${row.id_zoom_meeting}', '${row.account_id}', '${row.client_id}', '${row.client_secret}')">
								<i class="fas fa-play"></i>
							</button>`
          }
        }
      }
    ]
  })

  // --------- RESUMEN DE ASISTENCIAS -------------- //
	resetAttendanceSummary()

	function resetAttendanceSummary() {
    $('#att-total-classes').text('--')
    $('#att-total-asistencias').text('--')
    $('#att-total-tardanzas').text('--')
    $('#att-total-faltas').text('--')
    $('#att-percent-asistencia').text('--')
  }

  function loadAttendanceSummary() {
    if (!dt_idsemester || !dt_idsubject) {
      return
    }

    const csrfToken = $('meta[name="csrf-token"]').attr('content')

    $.ajax({
      type: 'POST',
      url: '/alumno/asistencias/resumen_asistencias',
      headers: { 'X-CSRF-TOKEN': csrfToken },
      dataType: 'json',
      data: {
        idsemester: dt_idsemester,
        idsubject: dt_idsubject
      },
      beforeSend: function () {},
      success: function (response) {
        if (!response.status) {
          resetAttendanceSummary(
            response.mensaje || 'No se pudo obtener el resumen de asistencias.'
          )
          return
        }

        const d = response.data

				$('#att-total-classes').text(d.total_clases)
				$('#att-total-asistencias').text(d.total_asistencias)
				$('#att-total-tardanzas').text(d.total_tardanzas)
				$('#att-total-faltas').text(d.total_faltas)
				$('#att-percent-asistencia').text(d.porcentaje_asistencia + '%')
      },
      error: function (error) {
        console.log('Error al obtener resumen de asistencias:', error)
      }
    })
  }

  //--------- F U N C I O N E S --------------//
  function tl_subjects() {
    $('#tlsubject').empty()

    $.ajax({
      type: 'GET',
      url: '/ajax_all/students/subjects/' + dt_idsemester,
      dataType: 'json',
      beforeSend: function () {},
      success: function (response) {
        response.forEach((elemento) => {
					document.getElementById("tlsubject").innerHTML +=
						"<li class=''>" +
						"<div class='divsubject timeline-badge primary'></div>" +
						"<a class='btnSubject timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
							"data-idsubject='" + elemento.idsubject + "'" +
							"data-codcurso='" + elemento.codcurso + "'" +
							"data-curso='" + elemento.curso + "'" +
							"data-seccion='" + elemento.seccion + "'" + ">" +
							"<h6 class='mb-0 fs-14'>" + "<strong class='text-dark'>" + elemento.curso +
							" - sec: " + elemento.seccion + "</strong>" +
							"<br>" + elemento.curso  + "</h6>" +
						"</a>" +
						"</li>"
        })
      },
      error: function (error) {
        console.log('Error', error)
      }
    })
  }

  // on change asignaturas
  $(document).on('click', '.btnSubject', function () {
    dt_idsubject = $(this).attr('data-idsubject')
    $('.divsubject').removeClass('dark').addClass('primary')
    $(this).prev('div').removeClass('primary').addClass('dark')
    notificaciontoast('info', 'Consultando a la  base de datos!', 'Mensaje!')
    // limpiar tabla
    table.ajax.reload()
    // cargar resumen de asistencias
    loadAttendanceSummary()
  })
})
