//"use strict";
import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../common/schemas.js";

$(document).ready(function () {
    const tableName = "General de Horarios ";
    var dt_idsemester = "null",
        dt_idstudent = "null",
        dt_idsubject = "null",
        semester = "";

    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/alumno/horarios/list_nota",
            data: function (d) {
                d.idsemester = dt_idsemester;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "plan", className: "text-center bg-info", sortable: false,
                render: function (data, type, all, meta) {
                    return (
                        `<h5 class="badge light badge-info">` +
                        all.plan +
                        `</h5>`
                    );
                },
            },
            { data: "periodo", className: "text-center bg-info", sortable: false,
                render: function (data, type, all, meta) {
                    return `<h5>` + all.periodo + `</h5>`;
                },
            },
            { data: "curso", className: "text-center bg-primary", sortable: false,
                render: function (data, type, all, meta) {
                    return `<h5>` + all.curso + `</h5>`;
                },
            },
            { data: "creditos_horas", className: "text-center bg-primary", sortable: false,
                render: function (data, type, all, meta) {
                    return `<h5>` + all.creditos_horas + `</h5>`;
                },
            },
            { data: "condicion", className: "text-center bg-primary", sortable: false,
                render: function (data, type, all, meta) {
                    return `<h5>` + all.condicion + `</h5>`;
                },
            },
            { data: "idstudent", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnViewEvaluations btn btn-success shadow btn-xs sharp"
                                data-idstudent="${all.idstudent}"
                                data-estudiante="${all.estudiante}"
                                data-idsubject="${all.idsubject}"
                                data-bs-placement="top"
                                title="Ver Evaluaciones">
                                <i class="fa-solid fa-eye fa-fade fa-xl"></i>
                            </a>
                        </div>
                        `;
                },
            },
            { data: "nota", className: "text-center bg-dark", sortable: false,
                render: function (data, type, all, meta) {
                    return `<h5>` + all.nota + `</h5>`;
                },
            },
            { data: "nota", className: "text-center text-center bg-dark", sortable: false,
                render: function (data, type, all, meta) {
                    if (all.nota == 0) {
                        return `<span class="badge light badge-dark">Sin evaluar</span>`;
                    } else if (all.nota >= 12.5) {
                        return `<span class="badge light badge-success">Aprobado</span>`;
                    } else if (all.nota < 12.5 && all.nota > 0) {
                        return `<span class="badge light badge-danger">Desaprobado</span>`;
                    }
                },
            },
        ],
    });

    // LISTAR DATATABLE 2
    var table_evaluations = $("#datatableGeneralEvaluaciones").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/alumno/promedios/list_promedio_estudiante",
            data: function (d) {
                (d.idstudent = dt_idstudent), (d.idsubject = dt_idsubject);
            },
        },
        searching: false,
        paging: false, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 20, // 20 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            { data: "prom_final", sortable: false, className: "text-center", name: 'primero',
                render: function (data, type, all, meta) {
                    return `
                        <h4>Promedio Final</h4>
                        <h4>${all.prom_final}</h4>
                    `;
                },
            },
            { data: "indicador", sortable: false, className: "text-center", name: 'primero',
                render: function (data, type, all, meta) {
                    return `
                        <h6>${all.indicador}</h6>
                        <b>Promedio: ${all.prom_indicador}</b>
                    `;
                },
            },
            { data: "actividad", sortable: false, className: "text-center", name: 'segundo',
                render: function (data, type, all, meta) {
                    if (all.actividad == "--") {
                        return `
                            --
                        `;
                    } else {
                        return `
                            <h6>${all.actividad}</h6>
                            <b>Promedio: ${all.prom_actividad}</b>
                        `;
                    }
                },
            },
            { data: "porcentaje", sortable: false, className: "text-center", name: 'tercero',
                render: function (data, type, all, meta) {
                    if (all.nombre_nota == "--") {
                        return `
                            --
                        `;
                    } else {
                        return `
                            <h6>${all.nombre_nota} (${all.porcentaje*100}%)</h6>
                            <b>Promedio: ${all.nota_estudiante}</b>
                        `;
                    }
                },
            },
        ],
        rowsGroup: ["primero:name", "segundo:name", "tercero:name"],
    });

    // INICIO - MODAL VER CURSOS
    $("#datatableGeneral tbody").on(
        "click",
        ".btnViewEvaluations",
        function (e) {
            dt_idstudent = $(this).data("idstudent");
            dt_idsubject = $(this).data("idsubject");
            table_evaluations.ajax.reload();
            setTimeout(function () {
                $("#modalDetalleNotas").modal("show");
            }, 500); // mostrar despues de x sec
            // mostrar modal
        }
    );
    // FIN - MODAL VER CURSOS

    $(document).on("click", "#btnPromedioAlumno", function () {
        setTimeout(function () {
            window.open(
                "/reportes/promedio_asignaturas2/" + dt_idsemester,
                "_blank"
            );
        }, 2000);
    });

    //--------- F U N C I O N E S --------------//
    cb_semesters();
    function cb_semesters() {
        $("#txt-semestre").find("option").remove().end(); // delete options
        $.ajax({
            type: "GET",
            url: "/ajax_all/semestersStudent",
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                $("#txt-semestre").append(
                    '<option selected disabled value="">Seleccione Periodo</option>'
                );
                response.forEach((elemento) => {
                    $("#txt-semestre").append(
                        "<option" +
                            ' value="' +
                            elemento.id +
                            '" ' +
                            ' data-anho="' +
                            elemento.anho +
                            '" ' +
                            ' data-numero="' +
                            elemento.numero +
                            '" ' +
                            ' data-fecinicio="' +
                            elemento.fecinicio +
                            '" ' +
                            ' data-fecfin="' +
                            elemento.fecfin +
                            '" ' +
                            ">" +
                            elemento.anho +
                            " - " +
                            elemento.numero +
                            "</option>"
                    );
                });
                $("#txt-semestre").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    var selectedOption;
    $("#txt-semestre").on("change", function () {
        toastr.info("Consultando en la base de datos ....", "Mensaje", {
            positionClass: "toast-bottom-right",
            timeOut: 2000,
            closeButton: !0,
            debug: !1,
            newestOnTop: !0,
            progressBar: !0,
            preventDuplicates: !0,
            onclick: null,
            showDuration: "300",
            hideDuration: "1000",
            extendedTimeOut: "1000",
            showEasing: "swing",
            hideEasing: "linear",
            showMethod: "fadeIn",
            hideMethod: "fadeOut",
            tapToDismiss: !1,
        });

        dt_idsemester = $(this).val();
        selectedOption = $(this).find("option:selected");
        $("#txt-fecinicio").html(selectedOption.data("fecinicio"));
        $("#txt-fecfin").html(selectedOption.data("fecfin"));

        table.ajax.reload();
    });

    list_info();
    function list_info() {
        $.ajax({
            type: "GET",
            url: "/alumno/horarios/list_info",
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                response.forEach((elemento) => {
                    $("#txt-codprograma").html(elemento.codprograma);
                    $("#txt-programa").html(elemento.programa);
                    $("#txt-nivel_formativo").html(elemento.nivel_formativo);
                    $("#txt-plan").html(elemento.plan);
                    $("#txt-tipo").html(elemento.tipo);
                    $("#txt-modalidad_enfoque").html(
                        elemento.modalidad + "-" + elemento.enfoque
                    );
                    // $('#txt-semestre').html(elemento.semestre);
                    // $('#txt-fecinicio').html(elemento.fecinicio);
                    // $('#txt-fecfin').html(elemento.fecfin);
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
});
