import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';

$(document).ready(function () {

    // setear fecha de documento
    $('#txt_fechadoc').val(getActualDate())

    $("#btnRegistrarTD").on("click", function (event) {
        event.preventDefault();

        const formCheck = $("#form")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
            return;
        }

        confirmation_sweetAlert("Deseas continuar?", "Se procederá a registrar tu solicitud de trámite documentario", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    store();
                }
            });
    });

});

function getActualDate() {
    const fechaActual = new Date();
    // Formatear la fecha (puedes personalizar el formato según tus necesidades)
    const formatoFecha = { year: 'numeric', month: '2-digit', day: '2-digit' };
    const fechaFormateada = fechaActual.toLocaleDateString('es-ES', formatoFecha);
    return fechaFormateada;

}

function store() {
    const btnTrigger = $('#btnRegistrarTD');
    const formData = new FormData(document.getElementById('form'));

    $.ajax({
        headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
        type: "POST",
        url: '/tramite_documentario/registrar',
        data: formData,
        processData: false,
        contentType: false,
        beforeSend: function () {
            btnTrigger.addClass('disabled');
        },
        success: function (data) {
            if (data.status == true) {
                notificaciontoast("info", data.mensaje, "Éxito!");
                swal_message_success(`Código: ${data.nt}`, 'En "Mis trámites" puedes consultar el estado!', 'success');
                btnTrigger.removeClass('disabled');
                clearForm();
            }
            else {
                notificaciontoast("error", data.mensaje, "Error!");
                btnTrigger.removeClass('disabled');
            }
        },
        error: function (error) {
            console.log("Error", error);
            btnTrigger.removeClass('disabled');
        },
    });
}

// - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
const clearForm = () => {
    $("#txt_td_tipo").selectpicker("val", "");
    $("#txt_area").selectpicker("val", "");
    $('#txt_asunto').val('');
    $('#txt_documentos').val('');
    $('#txt_folios').val('');
    $('#txt_fechadoc').val(getActualDate())
    $('#documento').val('');
    $('#check_tyc').prop('checked', false);
}
