'use strict';
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';

$(document).ready(function () {

    const tableName = "Estados de Trámite Documentario";
    var number = 0;
    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: '/tramite_documentario/mis_tramites/datatable',
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "id", className: "text-center" },
            {
                data: "fecha", className: "text-center", sortable: true,
                render: function (data, type, all, meta) {
                    const fechaFormat = all.fecha.slice(0, 10)
                    return `${fechaFormat}`;
                },
            },
            {
                data: "codigo", className: "text-center", sortable: true,
                render: function (data, type, all, meta) {
                    return `${all.serie}-${all.numero}`;
                },
            },
            { data: "td_tipo.nombre", className: "text-center" },
            { data: "area.nombre", className: "text-center" },
            {
                data: "td_estado.nombre", className: "text-center", sortable: true,
                render: function (data, type, all, meta) {
                    return `
                    <span style="display: inline-block; padding: 5px 10px; font-size: 12px; font-weight:600; color: #fff; background-color: ${all.td_estado.color}; border-radius: 12px;">
                        ${all.td_estado.nombre}
                    </span>
                    `;
                },
            },
            {
                data: "user", className: "text-center", sortable: true,
                render: function (data, type, all, meta) {
                    return `${all.user.apellido_pa} ${all.user.apellido_ma}, ${all.user.nombres} `;
                },
            },
            {
                data: "documentos",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    let divReturn = '<div class="d-flex justify-content-center gap">';
                    divReturn += `
                        <a href="/tramite_documentario/documento?id=${all.id}&tipo=recibido" class="btn btn-info shadow btn-xs sharp me-2"
                        target="_blank"
                        data-bs-placement="top"
                        title="Ver Documento Recibido">
                        <i class="fas fa-file-pdf fa-lg"></i>
                        </a>
                    `;
                    if (all.pdf_respuesta === null || all.pdf_respuesta === '') {
                        divReturn += `
                            <a href="javascript:void(0);" class="btn btn-primary shadow btn-xs sharp disabled"
                            data-bs-placement="top"
                            title="No hay documento">
                            <i class="fas fa-file-pdf fa-lg"></i>
                            </a>
                        `;
                    } else {
                        divReturn += `
                        <a href="/tramite_documentario/documento?id=${all.id}&tipo=respuesta" class="btn btn-success shadow btn-xs sharp me-2"
                        target="_blank"
                        data-bs-placement="top"
                        title="Ver Documento Respuesta">
                        <i class="fas fa-file-pdf fa-lg"></i>
                        </a>
                    `;
                    }
                    divReturn += '</div>';
                    return divReturn;
                },
            },
            {
                data: "accion", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnVerInfo btn btn-info shadow btn-xs sharp me-2"
                            data-id="${all.id}"
                            data-codigo="${all.serie}-${all.numero}"
                            data-area="${all.area.nombre}"
                            data-estado="${all.td_estado.nombre}"
                            data-estado-color="${all.td_estado.color}"
                            data-tipo="${all.td_tipo.nombre}"
                            data-asunto="${all.info_asunto}"
                            data-documentos="${all.info_documentos}"
                            data-folios="${all.info_folios}"
                            data-fecha="${all.fecha}"
                            data-nota_respuesta="${all.nota_respuesta}"
                            data-bs-placement="top"
                            title="Ver info">
                            <i class="fas fa-eye fa-lg"></i>
                            </a>

                            <a href="javascript:void(0);" class="btnVerDerivacion btn btn-info shadow btn-xs sharp"
                            data-id="${all.id}"
                            data-bs-placement="top"
                            title="Ver derivaciones">
                            <i class="fas fa-clock-rotate-left fa-lg"></i>
                            </a>

                        </div>
                    `;
                },
            },
        ]
    });

    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();


    // LISTAR DATATABLE 2
    const tableNameMovimientos = "Movimientos";
    var td_id = 0;
    var table_movimientos = $('#datatableMovimientos').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: 'POST',
            url: `/tramite_documentario/movimientos/datatable`,
            data: function (d) {
                d.td_id = td_id;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableNameMovimientos),
        columns: [
            { data: "id", className: "text-center" },
            {
                data: "fecha", className: "text-center", sortable: true,
                render: function (data, type, all, meta) {
                    const fechaFormat = all.fecha.slice(0, 10)
                    return `${fechaFormat}`;
                },
            },
            { data: "area_origen.nombre", className: "text-center" },
            { data: "area_destino.nombre", className: "text-center" },
            { data: "nota", className: "text-center" },
        ]
    });

    // Agregar una columna de números automáticos
    table_movimientos.on('order.dt search.dt', function () {
        table_movimientos.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    // LISTAR DATATABLE 2


    // - - - - - - - - - - M O D A L S - - - - - - - - - -

    // INICIO - MODAL
    $("#datatableGeneral tbody").on("click", ".btnVerInfo", function (e) {
        // setear data de cargo
        $('#td_id').val($(this).attr("data-id"))
        $('#codigo').val($(this).attr("data-codigo"))

        $('#estado').val($(this).attr("data-estado"))
        $('#estado').css({ 'color': `${$(this).attr("data-estado-color")}` });

        $('#tipo').val($(this).attr("data-tipo"))
        $('#area').val($(this).attr("data-area"))
        $('#asunto').val($(this).attr("data-asunto"))
        $('#documentos').val($(this).attr("data-documentos"))
        $('#folios').val($(this).attr("data-folios"))
        $('#fecha').val($(this).attr("data-fecha"))
        const info_nota_respuesta = $(this).attr("data-nota_respuesta")
        if (info_nota_respuesta === null || info_nota_respuesta === 'null') {
            $('#info_nota_respuesta').val('')
        } else {
            $('#info_nota_respuesta').val($(this).attr("data-nota_respuesta"))
        }
        // show form
        $("#modalCreateUpdate").modal("show");
    });
    // FIN - MODAL


    // INICIO - MODAL
    $("#datatableGeneral tbody").on("click", ".btnVerDerivacion", function (e) {
        td_id = $(this).attr("data-id")
        console.log(td_id);

        table_movimientos.ajax.reload();
        // show form
        $("#modalMovimientos").modal("show");
    });
    // FIN - MODAL


});

