'use strict';
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';

$(document).ready(function () {

    // combobox
    cb_areas();

    const tableName = "Estados de Trámite Documentario";
    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: '/tramite_documentario/gestionar/datatable',
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "id", className: "text-center" },
            {
                data: "fecha", className: "text-center", sortable: true,
                render: function (data, type, all, meta) {
                    const fechaFormat = all.fecha.slice(0, 10)
                    return `${fechaFormat}`;
                },
            },
            {
                data: "codigo", className: "text-center", sortable: true,
                render: function (data, type, all, meta) {
                    return `${all.serie}-${all.numero}`;
                },
            },
            { data: "td_tipo.nombre", className: "text-center" },
            { data: "area.nombre", className: "text-center" },
            {
                data: "td_estado.nombre", className: "text-center", sortable: true,
                render: function (data, type, all, meta) {
                    return `
                    <span style="display: inline-block; padding: 5px 10px; font-size: 12px; font-weight:600; color: #fff; background-color: ${all.td_estado.color}; border-radius: 12px;">
                        ${all.td_estado.nombre}
                    </span>
                    `;
                },
            },
            { data: "user", className: "text-center", sortable: true,
                render: function (data, type, all, meta) {
                    if (all.ruc != null) {
                        return `${all.user.apellido_pa} ${all.user.apellido_ma}, ${all.user.nombres} `;
                    } else {
                        return `${all.ruc} - ${all.razon_social}`;
                    }
                },
            },
            {
                data: "documentos",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    let divReturn = '<div class="d-flex justify-content-center gap">';
                    divReturn += `
                        <a href="/tramite_documentario/documento?id=${all.id}&tipo=recibido" class="btn btn-info shadow btn-xs sharp me-2"
                        target="_blank"
                        data-bs-placement="top"
                        title="Ver Documento Recibido">
                        <i class="fas fa-file-pdf fa-lg"></i>
                        </a>
                    `;
                    if (all.pdf_respuesta === null || all.pdf_respuesta === '') {
                        divReturn += `
                            <a href="javascript:void(0);" class="btn btn-primary shadow btn-xs sharp disabled"
                            data-bs-placement="top"
                            title="No hay documento">
                            <i class="fas fa-file-pdf fa-lg"></i>
                            </a>
                        `;
                    } else {
                        divReturn += `
                        <a href="/tramite_documentario/documento?id=${all.id}&tipo=respuesta" class="btn btn-success shadow btn-xs sharp me-2"
                        target="_blank"
                        data-bs-placement="top"
                        title="Ver Documento Respuesta">
                        <i class="fas fa-file-pdf fa-lg"></i>
                        </a>
                    `;
                    }
                    divReturn += '</div>';
                    return divReturn;
                },
            },
            {
                data: "accion", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    let isCancelarDisabled = "";
                    let isResponderDisabled = "";
                    let isDerivarDisabled = "";

                    if (all.td_estado_id === 2) {
                        isResponderDisabled = "disabled"
                        isCancelarDisabled = "disabled"
                        isDerivarDisabled = "disabled"
                    }
                    if (all.td_estado_id === 3) {
                        isCancelarDisabled = "disabled"
                    }
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnVerInfo btn btn-info shadow btn-xs sharp me-2"
                            data-id="${all.id}"
                            data-codigo="${all.serie}-${all.numero}"
                            data-area="${all.area.nombre}"
                            data-estado="${all.td_estado.nombre}"
                            data-estado-color="${all.td_estado.color}"
                            data-tipo="${all.td_tipo.nombre}"
                            data-asunto="${all.info_asunto}"
                            data-documentos="${all.info_documentos}"
                            data-folios="${all.info_folios}"
                            data-fecha="${all.fecha}"
                            data-nota_respuesta="${all.nota_respuesta}"
                            data-bs-placement="top"
                            title="Ver info">
                            <i class="fas fa-eye fa-lg"></i>
                            </a>

                            <a href="javascript:void(0);" class="btnVerDerivacion btn btn-info shadow btn-xs sharp me-2"
                            data-id="${all.id}"
                            data-bs-placement="top"
                            title="Historial Movimientos">
                            <i class="fas fa-clock-rotate-left fa-lg"></i>
                            </a>

                            <a href="javascript:void(0);" class="btnModalResponder btn btn-success shadow btn-xs sharp me-2 ${isResponderDisabled}"
                            data-id="${all.id}"
                            data-bs-placement="top"
                            title="Responder Trámite">
                            <i class="fas fa-user-check fa-lg"></i>
                            </a>


                            <a href="javascript:void(0);" class="btnModalDerivar btn btn-warning shadow btn-xs sharp me-2 ${isDerivarDisabled}"
                            data-id="${all.id}"
                            data-area_id="${all.area_id}"
                            data-bs-placement="top"
                            title="Derivar Trámite">
                            <i class="fas fa-share-from-square fa-lg"></i>
                            </a>

                            <a href="javascript:void(0);" class="btnCancelar btn btn-danger shadow btn-xs sharp ${isCancelarDisabled}"
                            data-id="${all.id}"
                            data-bs-placement="top"
                            title="Anular Trámite">
                            <i class="fas fa-xmark"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ]
    });

    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();


    // LISTAR DATATABLE 2
    const tableNameMovimientos = "Movimientos";
    var datatable_td_id = 0;
    var table_movimientos = $('#datatableMovimientos').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: 'POST',
            url: `/tramite_documentario/movimientos/datatable`,
            data: function (d) {
                d.td_id = datatable_td_id;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableNameMovimientos),
        columns: [
            { data: "id", className: "text-center" },
            {
                data: "fecha", className: "text-center", sortable: true,
                render: function (data, type, all, meta) {
                    const fechaFormat = all.fecha.slice(0, 10)
                    return `${fechaFormat}`;
                },
            },
            { data: "area_origen.nombre", className: "text-center" },
            { data: "area_destino.nombre", className: "text-center" },
            { data: "nota", className: "text-center" },
        ]
    });

    // Agregar una columna de números automáticos
    table_movimientos.on('order.dt search.dt', function () {
        table_movimientos.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    // LISTAR DATATABLE 2

    // - - - - - - - - - - M O D A L S - - - - - - - - - -

    // INICIO - MODAL
    $("#datatableGeneral tbody").on("click", ".btnVerInfo", function (e) {
        // setear data de cargo
        $('#codigo').val($(this).attr("data-codigo"))

        $('#estado').val($(this).attr("data-estado"))
        $('#estado').css({ 'color': `${$(this).attr("data-estado-color")}` });

        $('#tipo').val($(this).attr("data-tipo"))
        $('#area').val($(this).attr("data-area"))
        $('#asunto').val($(this).attr("data-asunto"))
        $('#documentos').val($(this).attr("data-documentos"))
        $('#folios').val($(this).attr("data-folios"))
        $('#fecha').val($(this).attr("data-fecha"))
        const info_nota_respuesta = $(this).attr("data-nota_respuesta")
        if (info_nota_respuesta === null || info_nota_respuesta === 'null') {
            $('#info_nota_respuesta').val('')
        } else {
            $('#info_nota_respuesta').val($(this).attr("data-nota_respuesta"))
        }
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
    });
    // FIN - MODAL


    // INICIO - MODAL
    $("#datatableGeneral tbody").on("click", ".btnVerDerivacion", function (e) {
        datatable_td_id = $(this).attr("data-id")

        table_movimientos.ajax.reload();
        // show form
        $("#modalMovimientos").modal("show");
    });
    // FIN - MODAL


    // INICIO - MODAL DERIVAR
    $("#datatableGeneral tbody").on("click", ".btnModalDerivar", function (e) {
        // borrar validaciones
        const formCheck = $("#formDerivar")[0];
        $(formCheck).removeClass('was-validated');

        $('#derivar_td_id').val($(this).attr("data-id"))
        $("#area-origen").selectpicker('val', $(this).attr("data-area_id"));
        $("#area-destino").selectpicker('val', '');
        $("#nota").val('');
        // show form
        $("#modalDerivar").modal("show");
    });
    // FIN - MODAL DERIVAR

    // INICIO - DERIVAR
    $("#btnDerivar").on("click", function (event) {
        event.preventDefault();
        const formCheck = $("#formDerivar")[0];
        $(formCheck).addClass('was-validated'); // añadir validaciones

        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            return;
        }

        const td_id = $('#derivar_td_id').val()
        derivarTd(td_id);
    });
    // FIN - DERIVAR


    // INICIO - MODAL RESPUESTA
    $("#datatableGeneral tbody").on("click", ".btnModalResponder", function (e) {
        // borrar validaciones
        const formCheck = $("#formResponder")[0];
        $(formCheck).removeClass('was-validated');

        $('#responder_td_id').val($(this).attr("data-id"))
        $("#documento").val('');
        $("#nota_respuesta").val('');
        // show form
        $("#modalResponder").modal("show");
    });
    // FIN - MODAL RESPUESTA

    // INICIO - RESPUESTA
    $("#btnResponder").on("click", function (event) {
        event.preventDefault();
        const formCheck = $("#formResponder")[0];
        $(formCheck).addClass('was-validated'); // añadir validaciones

        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            return;
        }

        const td_id = $('#responder_td_id').val()

        responderTd(td_id);
    });
    // FIN - RESPUESTA



    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".btnCancelar", function (e) {
        const td_id = $(this).attr("data-id");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a cancelar el trámite documentario", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    cancelarTd(td_id);
                } else {
                    console.log("Cancelado");
                }
            });
    });



    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function responderTd(td_id) {
        const btnTrigger = $('#btnResponder');
        const formData = new FormData(document.getElementById('formResponder'));

        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: `/tramite_documentario/responder/${td_id}`,
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
                btnTrigger.addClass('disabled');
            },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalResponder").modal("hide"); }, 1000); // ocultar despues de 1 sec
                }
                else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
                btnTrigger.removeClass('disabled');
            },
            error: function (error) {
                console.log("Error", error);
                btnTrigger.removeClass('disabled');
            },
        });
    }

    function derivarTd(td_id) {
        const formDerivar = $('#formDerivar');
        $.ajax({
            type: "POST",
            url: `/tramite_documentario/movimientos/${td_id}`,
            data: formDerivar.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalDerivar").modal("hide"); }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function cancelarTd(td_id) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "PUT",
            url: `/tramite_documentario/movimientos/cancelar/${td_id}`,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }



    function cb_areas() {
        $.ajax({
            type: "GET",
            url: '/ajax_all/areas',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                const area_origen = $('#area-origen')
                const area_destino = $('#area-destino')
                // delete options
                area_origen.find("option").remove().end()
                area_destino.find("option").remove().end()
                // new options
                area_origen.append('<option selected disabled value="">Seleccione un área</option>');
                area_destino.append('<option selected disabled value="">Seleccione un área</option>');
                response.forEach((elemento) => {
                    const titulo = `(${elemento.abreviatura}) ${elemento.nombre}`
                    area_origen.append('<option value="' + elemento.id + '" >' + titulo + '</option>');
                    area_destino.append('<option value="' + elemento.id + '" >' + titulo + '</option>');
                })
                // show options
                area_origen.selectpicker("refresh");
                area_destino.selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }




});

