'use strict';
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {

    var dt_idconcepto = "";

    const tableName = "Viático";

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/registros_pagos/viaticos/list',
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: 'idviatico', className: 'text-center' },
            { data: 'fecha2', className: 'text-center' },
            { data: "idusuario", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.tipoidenti_usu + ": " + all.nroidenti_usu + " - " + all.apellido_pa_usu + " " + all.apellido_ma_usu;
                },
            },
            { data: 'descripcion', className: 'text-center' },
            { data: "estado", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado == "1") {
                        return `<span class="badge light badge-success">Pagado</span>`;
                    } else if (all.estado == "2") {
                        return `<span class="badge light badge-warning">Pendiente</span>`;
                    } else if (all.estado == "0") {
                        return `<span class="badge light badge-danger">No Pagado</span>`;
                    } else {
                        return "--";
                    }
                },
            },
            { data: "nombremetodopago", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.nombremetodopago === null) {
                        return `--`;
                    }
                    else {
                        return all.nombremetodopago;
                    }
                },
            },
            { data: "nombrebanco", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.nombrebanco === null) {
                        return `--`;
                    }
                    else {
                        return all.nombrebanco;
                    }
                },
            },
            { data: "nro_operacion", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.nro_operacion === null || all.nro_operacion === '') {
                        return `--`;
                    }
                    else {
                        return all.nro_operacion;
                    }
                },
            },
            { data: "monto", className: "text-center",
                render: function (data, type, all, meta) {
                    return "S/" + all.monto;
                },
            },
            { data: "documento", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.documento == null || all.documento == "--") {
                        return `
                        <div class="d-flex justify-content-center">
                            --
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verDocumentoViatico/${all.idviatico}" class="btnVerBoucher btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Boucher">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            { data: "idadmin", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.tipoidenti_adm + ": " + all.nroidenti_adm + " - " + all.apellido_pa_adm + " " + all.apellido_ma_adm;
                },
            },
            { data: "idviatico", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                data-idviatico="${all.idviatico}"
                                data-idusuario="${all.idusuario}"
                                data-idmetodopago="${all.idmetodopago}"
                                data-idbanco="${all.idbanco}"
                                data-descripcion="${all.descripcion}"
                                data-fecha="${all.fecha}"
                                data-monto="${all.monto}"
                                data-documento="${all.documento}"
                                data-nro_operacion="${all.nro_operacion}"
                                data-estado="${all.estado}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                            </a>

                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-idviatico="${all.idviatico}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ]
    });


    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();


    // - - - - - - - - - - M O D A L S - - - - - - - - - -
    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        document.getElementById("btnCreateUpdate").setAttribute("value", "Create");
        document.getElementById("btnCreateUpdate").innerHTML = "Guardar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Registrar Datos del Viatico";
        clearCheck();
        clearForm();
    });
    // FIN - MODAL CREATE


    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        clearCheck();
        clearForm();
        //cambiar el text del button
        document.getElementById("btnCreateUpdate").innerHTML = "Actualizar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Actualizar Datos del Viatico";
        // setear data de cargo
        document.getElementById("txt-idviatico").value = $(this).attr("data-idviatico");
        $("#txt-usuario_id").selectpicker("val", $(this).attr("data-idusuario"));
        $("#txt-metodo_pago_id").selectpicker("val", $(this).attr("data-idmetodopago"));
        $("#txt-banco_id").selectpicker("val", $(this).attr("data-idbanco"));
        document.getElementById("txt-descripcion").value = $(this).attr("data-descripcion");
        document.getElementById("txt-fecha").value = $(this).attr("data-fecha");
        document.getElementById("txt-monto").value = $(this).attr("data-monto");
        document.getElementById("txt-nro_operacion").value = $(this).attr("data-nro_operacion");
        document.getElementById("txt-estado").value = $(this).attr("data-estado");
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        document.getElementById("btnCreateUpdate").setAttribute("value", "Update");
    });
    // FIN - MODAL UPDATE


    var valbtn = "", formCheck;
    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (e) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
        } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar tabla cargo
                store();
            }

            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar tabla cargo
                update();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE


    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        var idviatico = $(this).attr("data-idviatico");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(idviatico);
                } else {
                    console.log("Cancelado");
                }
            });
    });


    var formModal, formData;

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function store() {
        formModal = $('#formModal');
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            type: "POST",
            url: '/admin/registros_pagos/viaticos/store',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update() {
        formModal = $('#formModal');
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            type: "POST",
            url: '/admin/registros_pagos/viaticos/update',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy(id) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/registros_pagos/viaticos/destroy/' + id,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // listar estudiantes
    cb_usuarios();
    function cb_usuarios() {
        let apenom;
        $("#txt-usuario_id").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/users/admin_docente',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-usuario_id").append('<option selected disabled value="">Buscar Usuario</option>');
                response.forEach((elemento) => {
                    apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                    $("#txt-usuario_id").append('<option' +
                        ' value="' + elemento.iduser + '" ' +
                        ' data-subtext="' + elemento.nroidenti + '" ' +
                        ' data-iduser="' + elemento.iduser + '" ' +
                        ' data-apellido_pa="' + elemento.apellido_pa + '" ' +
                        ' data-apellido_ma="' + elemento.apellido_ma + '" ' +
                        ' data-nombres="' + elemento.nombres + '" ' +
                        ' data-tipoidenti="' + elemento.tipoidenti + '" ' +
                        ' data-nroidenti="' + elemento.nroidenti + '" ' +
                        ' data-celular="' + elemento.celular + '" ' +
                        ' data-anho_ingreso="' + elemento.anho_ingreso + '" ' +
                        ' data-estado="' + elemento.estado + '" ' +
                        '>' + apenom + '</option>');
                })
                $("#txt-usuario_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    cb_bancos();
    // listar bancos
    function cb_bancos() {
        $("#txt-banco_id").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/banco',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-banco_id").append('<option selected value="">Sin Banco</option>');
                response.forEach((elemento) => {
                    $("#txt-banco_id").append('<option ' +
                        'value="' + elemento.id + '"' +
                        'data-nombre="' + elemento.nombre + '"' +
                        ' >' + elemento.nombre + '</option>');
                })
                $("#txt-banco_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    cb_metodos_pagos();
    // listar metodos_pagos
    function cb_metodos_pagos() {
        $("#txt-metodo_pago_id").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/metodo_pago',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-metodo_pago_id").append('<option selected disabled value="">Seleccione Metodo de Pago</option>');
                response.forEach((elemento) => {
                    $("#txt-metodo_pago_id").append('<option ' +
                        'value="' + elemento.id + '"' +
                        'data-nombre="' + elemento.nombre + '"' +
                        ' >' + elemento.nombre + '</option>');
                })
                $("#txt-metodo_pago_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    var selectedOption;

    // on change estado
    $("#txt-estado").on('change', function () {
        if ($(this).val() == "1") {         // 1: pagado
            // metodo_pago
            $('#div-txt-metodo_pago_id').css('display', 'block');
            $('#txt-metodo_pago_id').attr('required', 'true');    // agregar required
            // banco
            $('#div-txt-banco_id').css('display', 'block');
            $('#txt-banco_id').attr('required', 'true');    // agregar required
            // nro_operacion
            $('#div-txt-nro_operacion').css('display', 'block');
            // documento
            $('#div-txt-documento').css('display', 'block');
        }
        else {
            // metodo_pago
            $('#div-txt-metodo_pago_id').css('display', 'none');
            $('#txt-metodo_pago_id').removeAttr('required');  // para poder pasar el check validity
            // banco
            $('#div-txt-banco_id').css('display', 'none');
            $('#txt-banco_id').removeAttr('required');  // para poder pasar el check validity
            // nro_operacion
            $('#div-txt-nro_operacion').css('display', 'none');
            $('#txt-nro_operacion').removeAttr('required');  // para poder pasar el check validity
            // documento
            $('#div-txt-documento').css('display', 'none');
            $('#txt-documento').removeAttr('required');  // para poder pasar el check validity
        }
    });


    // on change estado
    $("#txt-metodo_pago_id").on('change', function () {

        if ($(this).val() == "2") {         // 2: Efectivo
            // banco
            $('#div-txt-banco_id').css('display', 'none');
            $('#txt-banco_id').removeAttr('required');  // para poder pasar el check validity
            // nro_operacion
            $('#div-txt-nro_operacion').css('display', 'none');
            // documento
            $('#div-txt-documento').css('display', 'none');
        }
        else {
            // banco
            $('#div-txt-banco_id').css('display', 'block');
            $('#txt-banco_id').attr('required', 'true');    // agregar required
            // nro_operacion
            $('#div-txt-nro_operacion').css('display', 'block');
            // documento
            $('#div-txt-documento').css('display', 'block');
        }
    });


    // LIMPIAR VALIDACIONES
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
    }

    // LIMPIAR FORMULARIO
    function clearForm() {
        $("#txt-program").selectpicker("val", "");
        vaciar_students();
        $("#txt-semester").selectpicker("val", "");
        //
        $("#txt-monto").val("");
        $("#txt-metodo_pago_id").selectpicker("val", "");
        $("#txt-fecha").val("");
        $("#txt-banco_id").selectpicker("val", "");
        $("#txt-estado").selectpicker("val", "1");
        $("#txt-nro_operacion").val("");
        $("#txt-documento").val("");
        // mostrar nro de operacion y documento por defecto
        // metodo_pago
        $('#div-txt-metodo_pago_id').css('display', 'block');
        $('#txt-metodo_pago_id').attr('required', 'true');    // agregar required
        // banco
        $('#div-txt-banco_id').css('display', 'block');
        $('#txt-banco_id').attr('required', 'true');    // agregar required
        // nro_operacion
        $('#div-txt-nro_operacion').css('display', 'block');
        // documento
        $('#div-txt-documento').css('display', 'block');
    }

    function vaciar_students() {
        $("#txt-student").find("option").remove().end() // delete options
        $("#txt-student").append('<option selected disabled value="">Buscar Usuario</option>');
        $("#txt-student").selectpicker("refresh");
    }
});
