'use strict';
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import Chart from "chart.js/auto";

$(document).ready(function () {

    var anho = 0, mesInicio = 0, mesFin = 0, idstudent = 0;
    let chart1, chart2, chart3, chart4, chart5;

    $(document).on("change", "#txt-anho", function () {
        anho = $(this).val();
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        ingresos_egresos();
        actualizarGrafico1();
        actualizarGrafico2();
        actualizarGrafico3();
        actualizarGrafico4();
        actualizarListado();
        actualizarGrafico5();
    });

    $(document).on("change", "#txt-mesinicio", function () {
        mesInicio = $(this).val();
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        ingresos_egresos();
        actualizarGrafico1();
        actualizarGrafico2();
        actualizarGrafico3();
        actualizarGrafico4();
        actualizarListado();
        actualizarGrafico5();
    });

    $(document).on("change", "#txt-mesfin", function () {
        mesFin = $(this).val();
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        ingresos_egresos();
        actualizarGrafico1();
        actualizarGrafico2();
        actualizarGrafico3();
        actualizarGrafico4();
        actualizarListado();
        actualizarGrafico5();
    });

    $(document).on("change", "#txt-students", function () {
        idstudent = $(this).val();
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        actualizarGrafico2();
    });

    // --------------------------------------------------------------------
    //  FUNCIONES
    // --------------------------------------------------------------------

    function ingresos_egresos() {
        $.ajax({
            type: "GET",
            url: "/admin/registros_pagos/reportes/ingresos_egresos/" + anho + '/' + mesInicio + '/' + mesFin,
            dataType: "json",
            success: function (response) {
                response.forEach((elemento) => {
                    $("#txt-ingresos").val(elemento.ingresos);
                    $("#txt-egresos").val(elemento.egresos);
                    $("#txt-total").val(elemento.total);
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function actualizarGrafico1() {
        console.log("grafico 1");
        $.ajax({
            url: '/admin/registros_pagos/reportes/grafica_1/' + anho + '/' + mesInicio + '/' + mesFin,
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                function getRandomColor() {
                    const r = Math.floor(Math.random() * 17) * 15;
                    const g = Math.floor(Math.random() * 17) * 15;
                    const b = Math.floor(Math.random() * 17) * 15;
                    return `rgba(${r}, ${g}, ${b}, 0.6)`;  // backticks
                }

                const backgroundColors = data.map(() => getRandomColor());
                const labels = data.map(item => item.programa);
                const values = data.map(item => item.total);

                const ctx = document.getElementById('grafico-1').getContext('2d');
                if (chart1) chart1.destroy();

                chart1 = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: labels,
                        datasets: [{
                            data: values,
                            backgroundColor: backgroundColors,
                            borderColor: backgroundColors,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        indexAxis: 'y',
                        responsive: true,
                        scales: {
                            x: {
                                beginAtZero: true
                            }
                        },
                        plugins: {
                            tooltip: {
                                callbacks: {
                                    label: function (context) {
                                        return 'S/. ' + context.parsed.x.toLocaleString('es-PE');
                                    }
                                }
                            },
                            legend: {
                                display: false
                            },
                            title: {
                                display: false
                            }
                        }
                    },
                });
            }
        });
    }

    function actualizarGrafico2() {
        $.ajax({
            url: '/admin/registros_pagos/reportes/grafica_2/' + anho + '/' + mesInicio + '/' + mesFin + '/' + idstudent,
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                function getRandomColor() {
                    const r = Math.floor(Math.random() * 17) * 15;
                    const g = Math.floor(Math.random() * 17) * 15;
                    const b = Math.floor(Math.random() * 17) * 15;
                    return `rgba(${r}, ${g}, ${b}, 0.6)`;
                }

                const backgroundColors = data.map(() => getRandomColor());
                const labels = data.map(item => item.concepto);
                const values = data.map(item => item.total);

                const ctx = document.getElementById('grafico-2').getContext('2d');
                if (chart2) chart2.destroy();

                chart2 = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: labels,
                        datasets: [{
                            data: values,
                            backgroundColor: backgroundColors,
                            borderColor: backgroundColors,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        indexAxis: 'y',
                        responsive: true,
                        scales: {
                            x: {
                                beginAtZero: true
                            }
                        },
                        plugins: {
                            tooltip: {
                                callbacks: {
                                    label: function (context) {
                                        return 'S/. ' + context.parsed.x.toLocaleString('es-PE');
                                    }
                                }
                            },
                            legend: {
                                display: false
                            },
                            title: {
                                display: false
                            }
                        }
                    },
                });
            }
        });
    }

    function actualizarGrafico3() {
        console.log("grafico 3");
        $.ajax({
            url: '/admin/registros_pagos/reportes/grafica_3/' + anho + '/' + mesInicio + '/' + mesFin,
            type: 'GET',
            dataType: 'json',
            success: function (data) {

                function getRandomColor() {
                    const r = Math.floor(Math.random() * 17) * 15;
                    const g = Math.floor(Math.random() * 17) * 15;
                    const b = Math.floor(Math.random() * 17) * 15;
                    return `rgba(${r}, ${g}, ${b}, 0.6)`;   // backticks
                }

                const backgroundColors = data.map(() => getRandomColor());
                const labels = data.map(item => item.metodo_pago);
                const values = data.map(item => item.total);

                const ctx = document.getElementById('grafico-3').getContext('2d');
                if (chart3) chart3.destroy();

                chart3 = new Chart(ctx, {
                    type: 'pie',
                    data: {
                        labels: labels,
                        datasets: [{
                            data: values,
                            backgroundColor: backgroundColors,
                            borderColor: backgroundColors,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            tooltip: {
                                callbacks: {
                                    label: function (context) {
                                        const label = context.label || '';
                                        const value = context.parsed || 0;
                                    }
                                }
                            },
                            legend: {
                                display: true,
                                position: 'top'
                            },
                            title: {
                                display: false
                            }
                        }
                    },
                });
            }
        });
    }

    function actualizarGrafico4() {
        console.log("grafico 4");
        $.ajax({
            url: '/admin/registros_pagos/reportes/grafica_4/' + anho + '/' + mesInicio + '/' + mesFin,
            type: 'GET',
            dataType: 'json',
            success: function (data) {

                function getRandomColor() {
                    const r = Math.floor(Math.random() * 17) * 15;
                    const g = Math.floor(Math.random() * 17) * 15;
                    const b = Math.floor(Math.random() * 17) * 15;
                    return `rgba(${r}, ${g}, ${b}, 0.6)`;
                }

                const backgroundColors = data.map(() => getRandomColor());
                const labels = data.map(item => item.mes_nombre);
                const values = data.map(item => item.cantidad_morosos);

                const ctx = document.getElementById('grafico-4').getContext('2d');
                if (chart4) chart4.destroy();

                chart4 = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: labels,
                        datasets: [{
                            label: 'Estudiantes',
                            data: values,
                            backgroundColor: backgroundColors,
                            borderColor: backgroundColors,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            tooltip: {
                                callbacks: {
                                    label: function (context) {
                                        const label = context.label || '';
                                        const value = context.parsed.y ?? context.parsed ?? 0;
                                        return `${label}: ${value} estudiantes`;
                                    }
                                }
                            },
                            legend: {
                                display: true,
                                position: 'top'
                            },
                            title: {
                                display: false
                            }
                        }
                    }
                });
            }
        });
    }

    function actualizarListado() {
        console.log("listado");
        $.ajax({
            url: '/admin/registros_pagos/reportes/listado/' + anho + '/' + mesInicio + '/' + mesFin,
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                const $container = $('#listado-deudores');
                const $countSpan = $('#cantidad-deudores');

                $container.empty();

                if (!data || data.length === 0) {
                    $countSpan.text(0);
                    $container.html('<p class="text-muted mb-0">No hay deudores para el rango seleccionado.</p>');
                    return;
                }

                // cantidad de deudores
                $countSpan.text(data.length);

                data.forEach((item) => {
                    const alumno = item.alumno ?? 'Sin nombre';

                    const itemHtml = `
                        <div class="mb-2">
                            <p class="mb-1 fw-semibold">${alumno}</p>
                            <hr class="my-1" />
                        </div>
                    `;

                    $container.append(itemHtml);
                });
            },
            error: function (err) {
                console.error('Error listado', err);
                $('#cantidad-deudores').text(0);
                $('#listado-deudores').html('<p class="text-danger mb-0">Ocurrió un error al cargar el listado.</p>');
            }
        });
    }

    function actualizarGrafico5() {
        console.log("grafico 5");
        $.ajax({
            url: '/admin/registros_pagos/reportes/grafica_5/' + anho + '/' + mesInicio + '/' + mesFin,
            type: 'GET',
            dataType: 'json',
            success: function (data) {

                function getRandomColor(alpha = 0.7) {
                    const r = Math.floor(Math.random() * 256);
                    const g = Math.floor(Math.random() * 256);
                    const b = Math.floor(Math.random() * 256);
                    return `rgba(${r}, ${g}, ${b}, ${alpha})`;
                }

                if (!data || data.length === 0) {
                    if (chart5) chart5.destroy();
                    return;
                }

                const labels = data.map(item => item.concepto);
                const values = data.map(item => Number(item.total) || 0);
                const backgroundColors = values.map(() => getRandomColor(0.7));
                const borderColors = backgroundColors; // mismo color para el borde

                const ctx = document.getElementById('grafico-5').getContext('2d');
                if (chart5) chart5.destroy();

                chart5 = new Chart(ctx, {
                    type: 'doughnut',
                    data: {
                        labels: labels,
                        datasets: [{
                            label: 'Montos por concepto',
                            data: values,
                            backgroundColor: backgroundColors,
                            borderColor: borderColors,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        cutout: '60%', // grosor de la dona
                        plugins: {
                            tooltip: {
                                callbacks: {
                                    label: function (context) {
                                        const label = context.label || '';
                                        const value = Number(context.parsed) || 0;

                                        return `${label}: S/. ${value.toLocaleString('es-PE', {
                                            minimumFractionDigits: 2,
                                            maximumFractionDigits: 2
                                        })}`;
                                    }
                                }
                            },
                            legend: {
                                display: true,
                                position: 'top'
                            },
                            title: {
                                display: false
                            }
                        }
                    }
                });
            }
        });
    }
});
