'use strict';
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import { cb_exoneraciones } from "../../common/combobox/exoneraciones.js";

$(document).ready(function () {

    var dt_idconcepto = "all", dt_idstudent = "all", dt_estado_pago = "all";

    const tableName = "Pagos";

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/registros_pagos/pagos/list',
            data: function (d) {
                d.idconcepto = dt_idconcepto;
                d.idstudent = dt_idstudent;
                d.estado_pago = dt_estado_pago;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print"
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print"
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print"
                },
            },
            {
                extend: "colvis",
                text: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print"
                },
            },
        ],
        columns: [
            { data: 'idpago', className: 'text-center' },
            { data: 'fecha2', className: 'text-center' },
            {
                data: "idstudent", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.nroidenti_est + " - " + all.apellido_pa_est + " " + all.apellido_ma_est + " " + all.nombres_est;
                },
            },
            { data: 'concepto_semestre', className: 'text-center' },
            {
                data: "estado", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado == "1") {
                        return `<span class="badge light badge-success">Pagado</span>`;
                    } else if (all.estado == "2") {
                        return `<span class="badge light badge-warning">Pendiente</span>`;
                    } else if (all.estado == "0") {
                        return `<span class="badge light badge-danger">No Pagado</span>`;
                    } else {
                        return "--";
                    }
                },
            },
            // { data: "monto_inicial", className: "text-center",
            //     render: function (data, type, all, meta) {
            //         return "S/" + all.monto_inicial;
            //     },
            // },
            // { data: "descuento", className: "text-center",
            //     render: function (data, type, all, meta) {
            //         return all.descuento + "%";
            //     },
            // },
            {
                data: "nombremetodopago", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.nombremetodopago === null) {
                        return `--`;
                    }
                    else {
                        return all.nombremetodopago;
                    }
                },
            },
            {
                data: "nombrebanco", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.nombrebanco === null) {
                        return `--`;
                    }
                    else {
                        return all.nombrebanco;
                    }
                },
            },
            {
                data: "nro_operacion", className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.nro_operacion === null || all.nro_operacion === '') {
                        return `--`;
                    }
                    else {
                        return all.nro_operacion;
                    }
                },
            },
            {
                data: "monto_final", className: "text-center",
                render: function (data, type, all, meta) {
                    return "S/" + all.monto_final;
                },
            },
            {
                data: "documento", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.documento == null || all.documento == "--") {
                        return `
                        <div class="d-flex justify-content-center">
                            --
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verPagoMatricula/${all.idpago}" class="btnVerBoucher btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Boucher">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            {
                data: "idpago", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    if (all.estado == "1") {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/admin/registros_pagos/boleta_pago/${all.idpago}" target="_blank" class="btn btn-info shadow btn-xs sharp me-1"
                            data-idpago="${all.idpago}"
                            data-bs-placement="top"
                            title="Ver Boleta">
                            <i class="fas fa-eye"></i>
                            </a>
                        </div>
                        `;
                    } else if (all.estado == "0" || all.estado == "2") {
                        return `
                        <div class="d-flex justify-content-center">
                            --
                        </div>
                        `;
                    }
                },
            },
            {
                data: "idadmin", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.nroidenti_adm + " - " + all.apellido_pa_adm + " " + all.apellido_ma_adm;
                },
            },
            {
                data: "idpago", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1" 
                                data-idpago="${all.idpago}"
                                data-idstudent="${all.idstudent}"
                                data-idprogram="${all.idprogram}"
                                data-idsemester="${all.idsemester}"
                                data-idconcepto="${all.idconcepto}"
                                data-idmetodopago="${all.idmetodopago}"
                                data-idbanco="${all.idbanco}"
                                data-estudiante="${all.estudiante}"
                                data-fecha="${all.fecha}"
                                data-documento="${all.documento}"
                                data-nro_operacion="${all.nro_operacion}"
                                data-monto_inicial="${all.monto_inicial}"
                                data-descuento="${all.descuento}"
                                data-monto_final="${all.monto_final}"
                                data-estado="${all.estado}"
                                data-resolucion="${all.resolucion}"
                                data-exoneration_id="${all.exoneration_id || ''}"
                                data-descripcion="${all.descripcion}"
                                data-bs-placement="top" 
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                            </a>
                            
                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp" 
                                data-idpago="${all.idpago}" 
                                data-bs-placement="top" 
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ]
    });


    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    select_students();
    function select_students() {
        let apenom;
        $("#txt-idstudent").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/students',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-idstudent").append('<option selected disabled value="">Buscar estudiante</option>');
                $("#txt-idstudent").append('<option value="all">Todos</option>');
                response.forEach((elemento) => {
                    apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                    $("#txt-idstudent").append('<option' +
                        ' value="' + elemento.idstudent + '" ' +
                        ' data-subtext="' + elemento.nroidenti + '" ' +
                        ' data-apellido_pa="' + elemento.apellido_pa + '" ' +
                        ' data-apellido_ma="' + elemento.apellido_ma + '" ' +
                        ' data-nombres="' + elemento.nombres + '" ' +
                        ' data-nroidenti="' + elemento.nroidenti + '" ' +
                        ' data-celular="' + elemento.celular + '" ' +
                        ' data-anho_ingreso="' + elemento.anho_ingreso + '" ' +
                        ' data-estado="' + elemento.estado + '" ' +
                        '>' + apenom + '</option>');
                })
                $("#txt-idstudent").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    select_conceptos();
    // listar conceptos
    function select_conceptos() {
        $("#txt-idconcepto").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/concepto',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-idconcepto").append('<option selected disabled value="">Seleccione Concepto</option>');
                $("#txt-idconcepto").append('<option value="all">Todos</option>');
                response.forEach((elemento) => {
                    $("#txt-idconcepto").append('<option ' +
                        'value="' + elemento.id + '" ' +
                        'data-nombre="' + elemento.nombre + '" ' +
                        'data-monto="' + elemento.monto + '" ' +
                        ' >' + elemento.nombre + ':  S/ ' + elemento.monto + '</option>');
                })
                $("#txt-idconcepto").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    $(document).on("change", "#txt-idstudent", function () {
        dt_idstudent = $(this).val();
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });

    $(document).on("change", "#txt-idconcepto", function () {
        dt_idconcepto = $(this).val();
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });

    $(document).on("change", "#txt-estado_pago", function () {
        dt_estado_pago = $(this).val();
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        table.ajax.reload();
    });


    // - - - - - - - - - - M O D A L S - - - - - - - - - -
    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        $('#div-txt-programa_id').css('display', 'block');
        $('#div-txt-student_id').css('display', 'block');
        document.getElementById("btnCreateUpdate").setAttribute("value", "Create");
        document.getElementById("btnCreateUpdate").innerHTML = "Guardar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Registrar Datos del Pago";
        clearCheck();
        clearForm();
        // Obtener la fecha actual y formatearla
        const hoy = new Date();
        const año = hoy.getFullYear();
        const mes = String(hoy.getMonth() + 1).padStart(2, '0'); // Mes comienza en 0, sumamos 1
        const día = String(hoy.getDate()).padStart(2, '0');

        // Asignar la fecha actual al input
        $('#txt-fecha').val(`${año}-${mes}-${día}`);
    });
    // FIN - MODAL CREATE


    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        // clearCheck();
        // clearForm();
        $('#div-txt-programa_id').css('display', 'none');
        $('#div-txt-student_id').css('display', 'none');
        //cambiar el text del button
        document.getElementById("btnCreateUpdate").setAttribute("value", "Update");
        document.getElementById("btnCreateUpdate").innerHTML = "Actualizar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Actualizar pago del estudiante: " + $(this).attr("data-estudiante");
        // setear data de cargo
        document.getElementById("txt-idpago").value = $(this).attr("data-idpago");
        $("#txt-semester_id").selectpicker("val", $(this).attr("data-idsemester"));
        $("#txt-concepto_id").selectpicker("val", $(this).attr("data-idconcepto"));
        if ($(this).attr("data-idconcepto") == "1") {
            $('#div-txt-semester_id').css('display', 'block');
            $('#txt-semester_id').attr('required', 'true');
        }
        else {
            $('#div-txt-semester_id').css('display', 'none');
            $('#txt-semester_id').removeAttr('required');
        }
        $("#txt-metodo_pago_id").selectpicker("val", $(this).attr("data-idmetodopago"));
        $("#txt-banco_id").selectpicker("val", $(this).attr("data-idbanco"));
        document.getElementById("txt-fecha").value = $(this).attr("data-fecha");
        document.getElementById("txt-monto_inicial").value = $(this).attr("data-monto_inicial");
        document.getElementById("txt-descuento").value = $(this).attr("data-descuento");
        document.getElementById("txt-monto_final").value = $(this).attr("data-monto_final");
        document.getElementById("txt-nro_operacion").value = $(this).attr("data-nro_operacion");
        document.getElementById("txt-estado").value = $(this).attr("data-estado");
        document.getElementById("txt-descripcion").value = $(this).attr("data-descripcion");
        $("#txt-estado").selectpicker("val", $(this).attr("data-estado"));

        $("#txt-exoneration_id").selectpicker("val", $(this).attr("data-exoneration_id")); // <--- AÑADIR ESTO

        // ----- INICIO: LÓGICA DE VISIBILIDAD AL EDITAR -----
        if ($(this).data("exoneration_id")) {
            $('#div-descuento-fields').show(); // Muestra los campos de descuento
            $('#txt-descuento').prop('readonly', true); // Bloquea el campo
            const docName = $(this).data("documento_descuento");
            $('#doc-descuento-actual').text(docName ? `Archivo actual: ${docName.split('/').pop()}` : '');
        } else {
            $('#div-descuento-fields').hide(); // Oculta los campos
            $('#txt-descuento').prop('readonly', false); // Desbloquea
            $('#doc-descuento-actual').text('');
        }

        $("#txt-programa_id").selectpicker("val", $(this).attr("data-idprogram"));
        let sl_idprogram = $(this).data("idprogram");
        let sl_idstudent = $(this).data("idstudent");
        cb_students(sl_idprogram, sl_idstudent)
        // show form
        $("#modalCreateUpdate").modal("show");
    });
    // FIN - MODAL UPDATE

    // NUEVO EVENTO: AL CAMBIAR LA EXONERACIÓN
    $('#txt-exoneration_id').on('change', function () {
        const selectedOption = $(this).find('option:selected');
        const descuento = selectedOption.data('descuento');
        const exonerationValue = $(this).val();

        if (exonerationValue && descuento !== undefined) {
            $('#div-descuento-fields').show(); // MUESTRA el contenedor
            $('#txt-descuento').val(descuento);
            $('#txt-descuento').prop('readonly', true);
        } else {
            $('#div-descuento-fields').hide(); // OCULTA el contenedor
            $('#txt-descuento').val('');
            $('#txt-descuento').prop('readonly', false);
        }

        // Vuelve a calcular el monto final en cualquier caso
        calcular_monto_final();
    });

    var valbtn = "", formCheck;
    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (e) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
        } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar tabla cargo
                store();
            }

            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar tabla cargo
                update();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE


    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        var id = $(this).attr("data-idpago");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(id);
                } else {
                    console.log("Cancelado");
                }
            });
    });


    var formModal, formData;

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function store() {
        formModal = $('#formModal');
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            type: "POST",
            url: '/admin/registros_pagos/pagos/store',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update() {
        formModal = $('#formModal');
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            type: "POST",
            url: '/admin/registros_pagos/pagos/update',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                    $("#modalCreateUpdate").modal("hide");
                    setTimeout(function () {
                        formModal.classList.remove("was-validated");
                        formModal.reset();
                        document.getElementById("btnCreateUpdate").setAttribute("value", "Registrar");
                    }, 500);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy(id) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/registros_pagos/pagos/destroy/' + id,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    cb_programs();
    // listar programas
    function cb_programs() {
        $("#txt-programa_id").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/programs',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-programa_id").append('<option selected disabled value="">Seleccione programa</option>');
                response.forEach((elemento) => {
                    $("#txt-programa_id").append('<option ' +
                        'value="' + elemento.id + '"' +
                        'data-codprograma="' + elemento.codprograma + '"' +
                        'data-nombre="' + elemento.nombre + '"' +
                        'data-nivel_formativo="' + elemento.nivel_formativo + '"' +
                        ' >' + elemento.nombre + '</option>');
                })
                $("#txt-programa_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    // // INICIO - SELECCIONAR PROGRAMA
    $("#txt-programa_id").on("change", function (e) {
        // dt_idstudent = "0";
        // 
        let idprogram = $(this).val();
        // limpiar alumnos
        $("#txt-student_id").find("option").remove().end() // delete options
        $("#txt-student_id").append('<option selected disabled value="">Buscar alumno</option>');
        $("#txt-student_id").selectpicker("refresh");
        // listar alumnos
        cb_students(idprogram);
    });
    // FIN - SELECCIONAR PROGRAMA


    // cb_students();
    function cb_students(idprogram, sl_student = "no") {
        let apenom;
        $("#txt-student_id").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/student/by_idprogram/' + idprogram,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {

                if (sl_student === "no") {
                    $("#txt-student_id").append('<option selected disabled value="">Buscar alumno</option>');
                    response.forEach((elemento) => {
                        apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                        $("#txt-student_id").append('<option' +
                            ' value="' + elemento.idstudent + '" ' +
                            ' data-subtext="' + elemento.nroidenti + '" ' +
                            ' data-idstudent="' + elemento.idstudent + '" ' +
                            ' data-apellido_pa="' + elemento.apellido_pa + '" ' +
                            ' data-apellido_ma="' + elemento.apellido_ma + '" ' +
                            ' data-nombres="' + elemento.nombres + '" ' +
                            ' data-tipoidenti="' + elemento.tipoidenti + '" ' +
                            ' data-nroidenti="' + elemento.nroidenti + '" ' +
                            ' data-celular="' + elemento.celular + '" ' +
                            ' data-anho_ingreso="' + elemento.anho_ingreso + '" ' +
                            ' data-estado="' + elemento.estado + '" ' +
                            '>' + apenom + '</option>');
                    })
                }
                else {
                    $("#txt-student_id").append('<option disabled value="">Buscar alumno</option>');
                    response.forEach((elemento) => {
                        if (elemento.idstudent == sl_student) {
                            apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                            $("#txt-student_id").append('<option selected ' +
                                ' value="' + elemento.idstudent + '" ' +
                                ' data-subtext="' + elemento.nroidenti + '" ' +
                                ' data-idstudent="' + elemento.idstudent + '" ' +
                                ' data-apellido_pa="' + elemento.apellido_pa + '" ' +
                                ' data-apellido_ma="' + elemento.apellido_ma + '" ' +
                                ' data-nombres="' + elemento.nombres + '" ' +
                                ' data-tipoidenti="' + elemento.tipoidenti + '" ' +
                                ' data-nroidenti="' + elemento.nroidenti + '" ' +
                                ' data-celular="' + elemento.celular + '" ' +
                                ' data-anho_ingreso="' + elemento.anho_ingreso + '" ' +
                                ' data-estado="' + elemento.estado + '" ' +
                                '>' + apenom + '</option>');
                        }
                        else {
                            apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                            $("#txt-student_id").append('<option' +
                                ' value="' + elemento.idstudent + '" ' +
                                ' data-subtext="' + elemento.nroidenti + '" ' +
                                ' data-idstudent="' + elemento.idstudent + '" ' +
                                ' data-apellido_pa="' + elemento.apellido_pa + '" ' +
                                ' data-apellido_ma="' + elemento.apellido_ma + '" ' +
                                ' data-nombres="' + elemento.nombres + '" ' +
                                ' data-tipoidenti="' + elemento.tipoidenti + '" ' +
                                ' data-nroidenti="' + elemento.nroidenti + '" ' +
                                ' data-celular="' + elemento.celular + '" ' +
                                ' data-anho_ingreso="' + elemento.anho_ingreso + '" ' +
                                ' data-estado="' + elemento.estado + '" ' +
                                '>' + apenom + '</option>');
                        }
                    })
                }



                $("#txt-student_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    cb_semesters();
    // listar semestres
    function cb_semesters() {
        $("#txt-semester_id").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/semesters',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-semester_id").append('<option selected disabled value="">Seleccione periodo lectivo</option>');
                response.forEach((elemento) => {
                    $("#txt-semester_id").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-anho="' + elemento.anho + '" ' +
                        ' data-numero="' + elemento.numero + '" ' +
                        ' data-fecinicio="' + elemento.fecinicio + '" ' +
                        ' data-fecfin="' + elemento.fecfin + '" ' +
                        '>' + elemento.anho + " - " + elemento.numero + '</option>');
                })
                $("#txt-semester_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    cb_bancos();
    // listar bancos
    function cb_bancos() {
        $("#txt-banco_id").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/banco',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-banco_id").append('<option selected value="">Sin Banco</option>');
                response.forEach((elemento) => {
                    $("#txt-banco_id").append('<option ' +
                        'value="' + elemento.id + '"' +
                        'data-nombre="' + elemento.nombre + '"' +
                        ' >' + elemento.nombre + '</option>');
                })
                $("#txt-banco_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    cb_conceptos();
    // listar conceptos
    function cb_conceptos() {
        $("#txt-concepto_id").find("option").remove().end()
        $.ajax({
            type: "GET",
            url: '/ajax_all/concepto',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-concepto_id").append('<option selected disabled value="">Seleccione Concepto</option>');
                response.forEach((elemento) => {
                    if (elemento.id !== 1 && elemento.id !== 2) {
                        $("#txt-concepto_id").append('<option ' +
                            'value="' + elemento.id + '" ' +
                            'data-nombre="' + elemento.nombre + '" ' +
                            'data-monto="' + elemento.monto + '" ' +
                            ' >' + elemento.nombre + ':  S/ ' + elemento.monto + '</option>');
                    }

                })
                $("#txt-concepto_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    cb_metodos_pagos();
    // listar metodos_pagos
    function cb_metodos_pagos() {
        $("#txt-metodo_pago_id").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/metodo_pago',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-metodo_pago_id").append('<option selected disabled value="">Seleccione Metodo de Pago</option>');
                response.forEach((elemento) => {
                    $("#txt-metodo_pago_id").append('<option ' +
                        'value="' + elemento.id + '"' +
                        'data-nombre="' + elemento.nombre + '"' +
                        ' >' + elemento.nombre + '</option>');
                })
                $("#txt-metodo_pago_id").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }



    function calcular_monto_final() {
        let minicial = $('#txt-monto_inicial').val();
        let dcto = $('#txt-descuento').val();
        let mfinal = minicial - (dcto / 100) * minicial;
        $('#txt-monto_final').val(mfinal);
    }


    // calcular monto final
    $('#txt-descuento').on('input', function () {
        let minicial = $('#txt-monto_inicial').val();
        if (minicial == "") {
            notificaciontoast("warning", "Ingrese un monto inicial", "Advertencia!");
            $(this).val("");
            $('#txt-monto_final').val("");
            return;
        }
        let dcto = $(this).val();
        if (dcto < 0 || dcto > 100) {
            notificaciontoast("warning", "El descuento debe estar entre 0 y 100", "Advertencia!");
            $(this).val("");
            $('#txt-monto_final').val("");
            return;
        }
        let mfinal = minicial - (dcto / 100) * minicial;
        $('#txt-monto_final').val(mfinal);
    });


    var selectedOption;

    // on change concepto
    $("#txt-concepto_id").on('change', function () {
        if ($(this).val() == "1") {
            $('#div-txt-semester_id').css('display', 'block');
            $('#txt-semester_id').attr('required', 'true');    // agregar required
        }
        else {
            $('#div-txt-semester_id').css('display', 'none');
            $('#txt-semester_id').removeAttr('required');  // para poder pasar el check validity
        }
        // setear monto
        selectedOption = $(this).find('option:selected');
        let monto = selectedOption.data('monto')
        $('#txt-monto_inicial').val(monto);
        calcular_monto_final();
    });

    // on change estado
    $("#txt-estado").on('change', function () {
        if ($(this).val() == "1") {         // 1: pagado
            $('#div-txt-metodo_pago_id').css('display', 'block');
            $('#txt-metodo_pago_id').attr('required', 'true');    // agregar required
            $('#div-txt-banco_id').css('display', 'block');
            $('#txt-banco_id').attr('required', 'true');    // agregar required
            $('#div-txt-nro_operacion').css('display', 'block');
            $('#div-txt-documento').css('display', 'block');
        }
        else {
            $('#div-txt-metodo_pago_id').css('display', 'none');
            $('#txt-metodo_pago_id').removeAttr('required');  // para poder pasar el check validity
            $('#div-txt-banco_id').css('display', 'none');
            $('#txt-banco_id').removeAttr('required');  // para poder pasar el check validity
            $('#div-txt-nro_operacion').css('display', 'none');
            $('#txt-nro_operacion').removeAttr('required');  // para poder pasar el check validity
            $('#div-txt-documento').css('display', 'none');
            $('#txt-documento').removeAttr('required');  // para poder pasar el check validity
        }
    });


    // on change estado
    $("#txt-metodo_pago_id").on('change', function () {
        if ($(this).val() == "2") {         // 2: Efectivo
            // banco
            $('#div-txt-banco_id').css('display', 'none');
            $('#txt-banco_id').removeAttr('required');  // para poder pasar el check validity
            // nro_operacion
            $('#div-txt-nro_operacion').css('display', 'none');
            // documento
            $('#div-txt-documento').css('display', 'none');
        } else {
            // banco
            $('#div-txt-banco_id').css('display', 'block');
            $('#txt-banco_id').attr('required', 'true');    // agregar required
            // nro_operacion
            $('#div-txt-nro_operacion').css('display', 'block');
            // documento
            $('#div-txt-documento').css('display', 'block');
        }
    });


    // LIMPIAR VALIDACIONES
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
    }

    // LIMPIAR FORMULARIO
    function clearForm() {
        $("#txt-programa_id").selectpicker("val", "");
        vaciar_students();
        $("#txt-concepto_id").selectpicker("val", "");
        $("#txt-semester_id").selectpicker("val", "");
        // ocultar periodo lectivo por defecto
        $('#div-txt-semester_id').css('display', 'none');
        $('#txt-semester_id').removeAttr('required');  // para poder pasar el check validity
        $("#txt-monto_inicial").val("");
        $("#txt-exoneration_id").selectpicker("val", ""); // <--- AÑADIR ESTO
        $('#div-descuento-fields').hide(); // Ocultar campos de descuento
        $("#txt-descuento").val("");
        $('#txt-descuento').prop('readonly', false); // Asegurar que no esté bloqueado
        $('#txt-documento_descuento').val(''); // Limpiar el input de archivo
        $('#doc-descuento-actual').text(''); // Limpiar el texto del archivo actual
        $("#txt-monto_final").val("");
        $("#txt-metodo_pago_id").selectpicker("val", "");
        $("#txt-fecha").val("");
        $("#txt-banco_id").selectpicker("val", "");
        $("#txt-estado").selectpicker("val", "1");
        $("#txt-nro_operacion").val("");
        $("#txt-documento").val("");
        $("#txt-resolucion").val("");
        $("#txt-descripcion").val("");
        // mostrar nro de operacion y documento por defecto
        // metodo_pago
        $('#div-txt-metodo_pago_id').css('display', 'block');
        $('#txt-metodo_pago_id').attr('required', 'true');    // agregar required
        // banco
        $('#div-txt-banco_id').css('display', 'block');
        $('#txt-banco_id').attr('required', 'true');    // agregar required
        // nro_operacion
        $('#div-txt-nro_operacion').css('display', 'block');
        // documento
        $('#div-txt-documento').css('display', 'block');
    }

    function vaciar_students() {
        $("#txt-student_id").find("option").remove().end() // delete options
        $("#txt-student_id").append('<option selected disabled value="">Buscar alumno</option>');
        $("#txt-student_id").selectpicker("refresh");
    }
});
