'use strict';
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {

    const tableName = "Exoneraciones de Pago";

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/registros_pagos/exoneraciones/list',
        },
        processing: true,
        serverSide: true, // Habilitar serverSide para mejor performance
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', className: 'text-center', orderable: false, searchable: false },
            { data: 'nombre', name: 'nombre', className: 'text-center' },
            { data: 'descripcion', name: 'descripcion', className: 'text-center' },
            {
                data: 'documento_resolucion', name: 'documento_resolucion', className: 'text-center', orderable: false, searchable: false,
                render: function (data, type, full, meta) {
                    if (data) {
                        // --- CAMBIO AQUÍ: Apuntar a la nueva ruta de visualización ---
                        const viewUrl = `/admin/registros_pagos/exoneraciones/view_document/${full.id}`;
                        return `
                            <div class="d-flex justify-content-center">
                                <a href="${viewUrl}" target="_blank" class="btn btn-primary btn-xs sharp" title="Ver Documento"><i class="fas fa-file-pdf"></i>
                                </a>
                            </div>`;
                    }
                    return 'N/A';
                }
            },
            {
                data: 'porcentaje_descuento', name: 'porcentaje_descuento', className: 'text-center',
                render: function (data, type, full, meta) {
                    return data + ' %';
                }
            },
            {
                data: "id", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                            data-id="${all.id}"
                            data-nombre="${all.nombre}"
                            data-descripcion="${all.descripcion || ''}"
                            data-documento_resolucion="${all.documento_resolucion || ''}"
                            data-porcentaje_descuento="${all.porcentaje_descuento}"
                            title="Editar registro">
                            <i class="fas fa-pencil-alt"></i>
                            </a>
                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                            data-id="${all.id}"
                            title="Eliminar registro">
                            <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ]
    });


    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();


    // - - - - - - - - - - M O D A L S - - - - - - - - - -
    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        document.getElementById("btnCreateUpdate").setAttribute("value", "Create");
        document.getElementById("btnCreateUpdate").innerHTML = "Guardar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Registrar Datos de la Exoneracion de Pago";
        Clearform();
    });
    // FIN - MODAL CREATE


    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        //cambiar el text del button
        document.getElementById("btnCreateUpdate").innerHTML = "Actualizar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Actualizar Datos de la Exoneracion de Pago";
        // setear data de cargo
        document.getElementById("txt-id").value = $(this).attr("data-id");
        document.getElementById("txt-nombre").value = $(this).attr("data-nombre");
        document.getElementById("txt-descripcion").value = $(this).attr("data-descripcion");
        document.getElementById("txt-porcentaje_descuento").value = $(this).attr("data-porcentaje_descuento");
        // Mostrar nombre del documento actual
        const docName = $(this).data("documento_resolucion");
        $('#doc-actual').text(docName ? `Archivo actual: ${docName.split('/').pop()}` : 'No hay archivo cargado.');
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        document.getElementById("btnCreateUpdate").setAttribute("value", "Update");
    });
    // FIN - MODAL UPDATE


    var valbtn = "";
    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (e) {
        // obtener valor del boton
        valbtn = $("#btnCreateUpdate").val()
        // FUNCION CREAR
        if (valbtn === "Create") {
            // insertar tabla cargo
            store();
        }

        // FUNCION ACTUALIZAR
        if (valbtn === "Update") {
            // actualizar tabla cargo
            update();
        }
    });
    // FIN - FUNCION CREATE O UPDATE


    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        var id = $(this).attr("data-id");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(id);
                } else {
                    console.log("Cancelado");
                }
            });
    });


    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function store() {
        var formData = new FormData($('#formModal')[0]); // Usar FormData para incluir archivos

        $.ajax({
            type: "POST",
            url: '/admin/registros_pagos/exoneraciones/store',
            data: formData,
            processData: false, // Requerido para FormData
            contentType: false, // Requerido para FormData
            dataType: 'json',
            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                    $("#modalCreateUpdate").modal("hide");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                notificaciontoast("error", "Ocurrió un error inesperado", "Error!");
            },
        });
    }


    function update() {
        var id = document.getElementById("txt-id").value;
        var formData = new FormData($('#formModal')[0]);
        formData.append('_method', 'PUT'); // Simular un método PUT para la ruta

        $.ajax({
            type: "POST", // Usar POST y simular PUT
            url: '/admin/registros_pagos/exoneraciones/update/' + id,
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                    $("#modalCreateUpdate").modal("hide");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                notificaciontoast("error", "Ocurrió un error inesperado", "Error!");
            },
        });
    }

    function destroy(id) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/registros_pagos/exoneraciones/destroy/' + id,
            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    // MODIFICACIÓN AQUÍ: Se muestra una alerta modal con el mensaje de error del servidor.
                    Swal.fire({
                        icon: 'error',
                        title: 'Acción denegada',
                        text: data.mensaje, // Este es el mensaje que viene de tu backend
                        confirmButtonText: 'Entendido'
                    });
                }
            },
            error: function (error) {
                notificaciontoast("error", "Ocurrió un error inesperado", "Error!");
            },
        });
    }

    // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
    function Clearform() {
        $('#formModal')[0].reset();
        document.getElementById("txt-id").value = "";
        document.getElementById("txt-nombre").value = "";
        document.getElementById("txt-descripcion").value = "";
        document.getElementById("txt-porcentaje_descuento").value = "";
        $('#doc-actual').text('');
    }
});
