"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {
    const tableName = "Permisos ";

    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/seguridad/permisos/list",
        },
        pageLength: 18, // numero de filas
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            {
                data: "idrol",
                className: "text-center",
                name: "primero",
                render: function (data, type, all, meta) {
                    return (
                        "<h3>" +
                        all.rol +
                        "</h3>" +
                        "<br>" +
                        "<b>" +
                        all.descripcion +
                        "</b>"
                    );
                },
            },
            {
                data: "modulo",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    return all.modulo;
                },
            },
            {
                data: "estado",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.permiso == "1") {
                        return `
                        <i class="fa fa-check-circle text-success" aria-hidden="true"></i>
                        <select class="editBtn default-select"
                        data-idrol="${all.idrol}"
                        data-idmodulo="${all.idmodulo}"
                        data-permiso="${all.permiso}"
                        data-newpermiso="0"
                        >
                            <option selected value="1">Habilitado</option>
                            <option value="0">Inhabilitado</option>
                        </select>
                        `;
                    } else {
                        return `
                        <i class="fa fa-times-circle text-danger" aria-hidden="true"></i>
                        <select class="editBtn default-select"
                        data-idrol="${all.idrol}"
                        data-idmodulo="${all.idmodulo}"
                        data-permiso="${all.permiso}"
                        data-newpermiso="1"
                        >
                            <option value="1">Habilitado</option>
                            <option selected value="0">Inhabilitado</option>
                        </select>
                        `;
                    }
                },
            },
            {
                data: "read",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    const disabled = (all.permiso == '0') ? 'disabled' : '';
                    const checked = (all.read == 1) ? 'checked' : '';
                    return `
                <input type="checkbox" class="permiso-checkbox"
                    ${disabled}
                    data-action="read"
                    data-idpermiso="${all.idpermiso}"
                    data-newvalue="${all.read == 1 ? 0 : 1}"
                    ${checked}>
            `;
                },
            },
            {
                data: "create",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    const disabled = (all.permiso == '0') ? 'disabled' : '';
                    const checked = (all.create == 1) ? 'checked' : '';
                    return `
                <input type="checkbox" class="permiso-checkbox"
                    ${disabled}
                    data-action="create"
                    data-idpermiso="${all.idpermiso}"
                    data-newvalue="${all.create == 1 ? 0 : 1}"
                    ${checked}>
            `;
                },
            },
            {
                data: "update",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    const disabled = (all.permiso == '0') ? 'disabled' : '';
                    const checked = (all.update == 1) ? 'checked' : '';
                    return `
                <input type="checkbox" class="permiso-checkbox"
                    ${disabled}
                    data-action="update"
                    data-idpermiso="${all.idpermiso}"
                    data-newvalue="${all.update == 1 ? 0 : 1}"
                    ${checked}>
            `;
                },
            },
            {
                data: "delete",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    const disabled = (all.permiso == '0') ? 'disabled' : '';
                    const checked = (all.delete == 1) ? 'checked' : '';
                    return `
                <input type="checkbox" class="permiso-checkbox"
                    ${disabled}
                    data-action="delete"
                    data-idpermiso="${all.idpermiso}"
                    data-newvalue="${all.delete == 1 ? 0 : 1}"
                    ${checked}>
            `;
                },
            },
        ],
        rowsGroup: ["primero:name"],
        orderFixed: [0, "asc"], // Fija el orden por defecto de la primera columna
    });

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -

    $("#datatableGeneral tbody").on("change", ".editBtn", async function (e) {
        document.getElementById("txt_idrol_name").value =
            $(this).attr("data-idrol");
        document.getElementById("txt_idmodulo_name").value =
            $(this).attr("data-idmodulo");
        document.getElementById("txt_permiso_name").value =
            $(this).attr("data-newpermiso");

        var idrol = document.getElementById("txt_idrol_name").value;
        var idmodulo = document.getElementById("txt_idmodulo_name").value;

        var formData = $("#formModal").serialize();
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url: "/admin/seguridad/" + idrol + "/" + idmodulo + "",
            data: formData,
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    // let pagina_seleccionada = $('#myTabContent-2 .paginate_button.current').attr('data-dt-idx');
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    Clearform();
                } else {
                    notificaciontoast(
                        "error",
                        data.mensaje.txt_idrol_name[0],
                        "Error!"
                    );
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

    $("#datatableGeneral tbody").on(
        "change",
        ".permiso-checkbox",
        async function (e) {
            const $checkbox = $(this);
            const idPermiso = $(this).data("idpermiso");
            const action = $(this).data("action");
            const actionNewValue = $(this).data("newvalue");
            // const checked = $(this).is(":checked") ? 1 : 0;

            $("#txt-action").val(action);
            $("#txt-action_new_value").val(actionNewValue);

            // deshabilita el checkbox temporalmente
            $checkbox.prop("disabled", true);

            var formData = $("#formModal").serialize();
            $.ajax({
                headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
                type: "PUT",
                url: "/admin/seguridad/accion/" + idPermiso,
                data: formData,
                dataType: "json",
                beforeSend: function () {},
                success: function (data) {
                    if (data.status == true) {
                        // let pagina_seleccionada = $('#myTabContent-2 .paginate_button.current').attr('data-dt-idx');
                        table.ajax.reload();
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        Clearform();
                    } else {
                        notificaciontoast(
                            "error",
                            data.mensaje.txt_idrol_name[0],
                            "Error!"
                        );
                    }
                },
                error: function (error) {
                    console.log("Error", error);
                },
                complete: function () {
                    $checkbox.prop("disabled", false);
                    $checkbox.closest("td").find(".fa-spinner").remove();
                },
            });
        }
    );

    function Clearform() {
        document.getElementById("txt_idrol_name").value = "";
        document.getElementById("txt_idmodulo_name").value = "";
        document.getElementById("txt_permiso_name").value = "";
    }
});
