import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

window.addEventListener("DOMContentLoaded", async () => {
    //
    var estadomodulo = false;
    $(document).on("click", "#pills-home-tab", function () {
        estadomodulo = false;
    });
    $(document).on("click", "#pills-profile-tab", function () {
        estadomodulo = true;
    });

    var js_btnDonwload_Plantilla = document.querySelector(
        "#btn_download_pantilla"
    );

    js_btnDonwload_Plantilla.addEventListener("click", async function (e) {
        e.preventDefault();
        if (estadomodulo == true) {
            var nombreArchivo = "plantilla_usuarios.xlsx";
            fetch("/admin/seguridad/usuarios/plantilla/download", {
                method: "POST",
                body: new FormData(document.getElementById("form")),
            })
                .then((response) => response.blob())
                .then((blob) => {
                    // Crea un objeto URL para el blob
                    var url = window.URL.createObjectURL(blob);

                    // Crea un enlace para descargar el archivo
                    var a = document.createElement("a");
                    a.href = url;
                    a.download = nombreArchivo;
                    document.body.appendChild(a);
                    a.click();

                    // Libera el objeto URL
                    window.URL.revokeObjectURL(url);
                })
                .catch((error) => {
                    notificaciontoast("Error al descargar el archivo:", error);
                });
        } else {
            document
                .getElementById("modulemasive")
                .classList.add("border", "border-3", "border-danger");
            setTimeout(function () {
                document
                    .getElementById("modulemasive")
                    .classList.remove("border", "border-3", "border-danger");
            }, 1100);
        }
    });
});

$(document).ready(function () {});
