//"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";

$(document).ready(function () {


    function list_backup() {
        let html = "";
        let count = 1;
        $.ajax({
            type: "GET",
            url: "/admin/seguridad/list/backupbd",
            dataType: "json",
            beforeSend: function () {},
            success: function (response) {
                response.data.forEach((elemento) => {
                    html += `  <li>
                        <div class="file-list items-align-beetwem">
                            <div class="dz-media">
                                <svg width="35" height="40" viewBox="0 0 59 81" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M53.1365 80H5.86371C3.13985 80 0.90918 77.7693 0.90918 75.0455V5.95453C0.90918 3.23067 3.13985 1 5.86371 1H38.3839L58.091 20.7071V75.0455C58.091 77.7693 55.8604 80 53.1365 80Z" fill="#D0E9FF" stroke="#1B87FF"/>
                                    <path d="M38.5911 0.5L58.5911 20.5H38.5911V0.5Z" fill="#1B87FF"/>
                                    <path d="M38.5911 0.5L58.5911 20.5H38.5911V0.5Z" stroke="#1B87FF"/>
                                    <path d="M13.1365 31.4092H45.8638V35.9546H13.1365V31.4092Z" fill="#1B87FF"/>
                                    <path d="M13.1365 31.4092H45.8638V35.9546H13.1365V31.4092Z" stroke="#1B87FF"/>
                                    <path d="M13.1365 42.3184H45.8638V46.8638H13.1365V42.3184Z" fill="#1B87FF"/>
                                    <path d="M13.1365 42.3184H45.8638V46.8638H13.1365V42.3184Z" stroke="#1B87FF"/>
                                    <path d="M13.1365 53.2275H36.7729V57.773H13.1365V53.2275Z" fill="#1B87FF"/>
                                    <path d="M13.1365 53.2275H36.7729V57.773H13.1365V53.2275Z" stroke="#1B87FF"/>
                                </svg>
                            </div>
                            <div class="dz-info">

                                    <h4 class="title">Backup N° ${count}</h4>
                                    <div class="row">
                                        <div class="col-xl-4">
                                            <span>Realizado por: ${elemento.nombres} ${elemento.apellidos}</span> <br>
                                        </div>
                                        <div class="col-xl-5">
                                            <span>Realizado: ${elemento.fechcreacion}   hora: ${elemento.hora_registro}</span>
                                        </div>
                                        <div class="col-xl-3">
                                                <a href="/admin/seguridad/download/backupbd/${elemento.namezip}"  target="_blank" data-bs-placement="top"  title="Descargar Zip">
                                                <i class="fas fa-database"></i> Descargar
                                                </a>
                                        </div>
                                    </div>
                            </div>

                        </div>
                    </li>`;
                    count++;
                });

                document.getElementById("folder").innerHTML = html;
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    list_backup();

    $(document).on("click", "#btn_generar_backup", function () {
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a realizar el Backup de la Base de datos; esto podría demorar unos minutos", "warning")
        .then(function (isConfirm) {
            if (isConfirm.value) {
                $.ajax({
                    headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                    type: "POST",
                    url: '/admin/seguridad/create/backupbd',
                    beforeSend: function () { notificaciontoast("warning", "Comprobando Solicitud de Backup!", "Mensaje!");},
                    success: function (data) {
                        console.log(data)
                        if (data.status == true) {
                            notificaciontoast("info", data.mensaje, "Éxito!");
                            list_backup();
                        } else {
                            notificaciontoast("error", data.mensaje, "Error!");
                        }
                    },
                    error: function (error) {
                        console.log("Error", error);
                    },
                });

            } else {
                console.log("Cancelado");
            }
        });
    });


});
