'use strict'

import { getButtonsSchema, languageSchema } from '../../common/schemas.js'

$(document).ready(function () {
  const tableName = 'Auditorías'

  const table = $('#datatableGeneral').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    ajax: {
      url: '/admin/seguridad/auditoria/list',
      type: 'POST',
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      data: function (d) {
        d.event = $('#filter-event').val()
        d.user_id = $('#filter-user-id').val()
        d.user_name = $('#filter-user-name').val()
        d.user_type = $('#filter-user-type').val()
        d.auditable_type = $('#filter-auditable-type').val()
        d.ip_address = $('#filter-ip').val()
        d.date_from = $('#filter-date-from').val()
        d.date_to = $('#filter-date-to').val()
      }
    },
    serverSide: true,
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: languageSchema,
    buttons: getButtonsSchema(tableName),
    columns: [
      {
        data: 'DT_RowIndex',
        name: 'DT_RowIndex',
        className: 'text-center',
        searchable: false,
        orderable: false
      },
      { data: 'created_at', name: 'created_at', className: 'text-center' },
      {
        data: 'event',
        name: 'event',
        className: 'text-center',
        render: function (data, type, row, meta) {
          let badge = ''

          switch (data) {
            case 'created':
              badge = '<span class="badge light badge-success">Creación</span>'
              break
            case 'updated':
              badge =
                '<span class="badge light badge-warning">Actualización</span>'
              break
            case 'deleted':
              badge =
                '<span class="badge light badge-danger">Eliminación</span>'
              break
            default:
              badge =
                '<span class="badge light badge-secondary">Desconocido</span>'
          }

          return badge
        }
      },
      { data: 'usuario', name: 'usuario', className: 'text-center' },
      { data: 'tipo_usuario', name: 'tipo_usuario', className: 'text-center' },
      { data: 'modelo', name: 'modelo', className: 'text-center' },
      { data: 'cambios', name: 'cambios', className: 'text-center' },
      { data: 'ip_address', name: 'ip_address', className: 'text-center' },
      { data: 'url', name: 'url' },
      {
        data: null,
        className: 'text-center',
        searchable: false,
        orderable: false,
        render: function (data, type, row, meta) {
          return `
            <div class="d-flex justify-content-center">
              <a href="javascript:void(0);" 
                 class="btnViewAudit btn btn-info shadow btn-xs sharp me-1"
                 data-bs-placement="top"
                 title="Ver detalle JSON">
                <i class="fas fa-eye"></i>
              </a>
            </div>
          `
        }
      },
      {
        data: 'old_values_json',
        name: 'old_values_json',
        visible: false,
        searchable: false
      },
      {
        data: 'new_values_json',
        name: 'new_values_json',
        visible: false,
        searchable: false
      }
    ]
  })

  // Botón "Buscar"
  $('#btnFilter').on('click', function () {
    table.ajax.reload()
  })

  // Botón "Limpiar"
  $('#btnClearFilters').on('click', function () {
    $('#filtersForm')[0].reset()
    table.ajax.reload()
  })

  // - - - - - - - - - -  M O D A L  D E T A L L E  J S O N  - - - - - - - - - -

  $('#datatableGeneral tbody').on('click', '.btnViewAudit', function (e) {
    e.preventDefault()

    const rowData = table.row($(this).closest('tr')).data()

    // Datos de cabecera para el modal
    const event = rowData.event || '--'
    const fecha = rowData.created_at || '--'
    const usuario = rowData.usuario || '--'
    const modelo = rowData.modelo || '--'
    const ip = rowData.ip_address || '--'
    const url = rowData.url || '--'

    // JSON completo (old y new)
    const oldObj = rowData.old_values_json || {}
    const newObj = rowData.new_values_json || {}

    const oldPretty = JSON.stringify(oldObj, null, 2)
    const newPretty = JSON.stringify(newObj, null, 2)

    // Setear datos en el modal (ajusta los IDs según el Blade que armes)
    $('#auditDetail-event').text(event.toUpperCase())
    $('#auditDetail-datetime').text(fecha)
    $('#auditDetail-user').text(usuario)
    $('#auditDetail-model').text(modelo)
    $('#auditDetail-ip').text(ip)
    $('#auditDetail-url').text(url)

    $('#pre-old-values').text(oldPretty)
    $('#pre-new-values').text(newPretty)

    $('#modalAuditDetail').modal('show')
  })
})
