import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';
import { cb_provincias, cb_distritos, ubigeo_for_update, vaciar_distritos, vaciar_provincias } from "../../common/combobox/ubigeo.js";

$(document).ready(function () {

    const tableName = "Administradores";

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/seguridad/administradores/list',
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: 'tipoidenti', className: 'text-center' },
            { data: 'tipoidenti', className: 'text-center' },
            { data: 'nroidenti', className: 'text-center' },
            { data: 'apellidos', className: 'text-center' },
            { data: 'nombres', className: 'text-center' },
            { data: 'correo', className: 'text-center' },
            { data: 'nombrerole', className: 'text-center' },
            { data: "estado", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado == "1") {
                        return `<span class="badge light badge-success">Activo</span>`;
                    } else {
                        return `<span class="badge light badge-danger">Inactivo</span>`;
                    }
                },
            },
            {
                data: "idadministrador",
                className: "text-center noExport",
                sortable: false,
                searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="passwordBtn btn btn-dark shadow btn-xs sharp  me-1"
                                data-iduser="${all.iduser}"
                                data-nroidenti="${all.nroidenti}"
                                data-nombres="${all.nombres}"
                                data-apellido_pa="${all.apellido_pa}"
                                data-apellido_ma="${all.apellido_ma}"
                                data-bs-placement="top"
                                title="Actualizar contraseña">
                                <i class="fas fa-key"></i>
                                </a>

                                <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                data-iduser="${all.iduser}"
                                data-tipoidenti="${all.tipoidenti}"
                                data-nroidenti="${all.nroidenti}"
                                data-estado="${all.estado}"
                                data-nombres="${all.nombres}"
                                data-apellido_pa="${all.apellido_pa}"
                                data-apellido_ma="${all.apellido_ma}"
                                data-fecnac="${all.fecnac}"
                                data-correo="${all.correo}"
                                data-telefono="${all.telefono}"
                                data-celular="${all.celular}"
                                data-genre_id="${all.idgenre}"
                                data-ubigeo_id="${all.idubigeo}"
                                data-iddepartamento="${all.iddepartamento}"
                                data-departamento="${all.departamento}"
                                data-idprovincia="${all.idprovincia}"
                                data-provincia="${all.provincia}"
                                data-iddistrito="${all.iddistrito}"
                                data-distrito="${all.distrito}"
                                data-direccion="${all.direccion}"
                                data-idadministrador="${all.idadministrador}"
                                data-role_id="${all.idrole}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                                </a>

                                <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-idadministrador="${all.idadministrador}"
                                data-iduser="${all.iduser}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                                </a>

                            </div>

                            `;
                },
            },
        ]
    });

    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    var valbtn, formCheck;

    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        $("#btnCreateUpdate").attr("value", "Create");
        $("#btnCreateUpdate").html("Registrar");
        $("#modalCreateUpdateLabel").html("Registrar datos del Administrador");
        // mostrar contraseña
        $("#div_txt_password").removeAttr("style");
        clearCheck();
        clearForm();
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        clearCheck();   // borrar validaciones
        //cambiar el text del button
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar datos del Administrador");
        // ocultar txt_password
        $("#div_txt_password").css("display", "none");
        $("#txt_password").val("****"); // para poder pasar el check validity
        // setear data de usuario
        $("#txt_iduser").val($(this).data("iduser"));
        $("#txt_nroidenti").val($(this).data("nroidenti"));
        $("#txt_estado").selectpicker("val", $(this).attr("data-estado"));
        $("#txt_nombres").val($(this).data("nombres"));
        $("#txt_apellido_pa").val($(this).data("apellido_pa"));
        $("#txt_apellido_ma").val($(this).data("apellido_ma"));
        $("#txt_fecnac").val($(this).data("fecnac"));
        $("#txt_correo").val($(this).data("correo"));
        $("#txt_telefono").val($(this).data("telefono"));
        $("#txt_celular").val($(this).data("celular"));
        $("#txt_genre_id").selectpicker("val", $(this).attr("data-genre_id"));
        $("#txt_direccion").val($(this).data("direccion"));
        // ubigeo
        $("#txt_departamento").selectpicker("val", $(this).attr("data-iddepartamento"));
        let sl_departamento = $(this).data("departamento");
        let sl_provincia = $(this).data("provincia");
        let sl_distrito = $(this).data("distrito");
        ubigeo_for_update(sl_departamento, sl_provincia, sl_distrito);
        // obtener datos del administrador
        $("#txt_idadministrador").val($(this).data("idadministrador"));
        $("#txt_role_id").selectpicker("val", $(this).attr("data-role_id"));
        // show form
        $("#modalCreateUpdate").modal("show");
        // change value
        $("#btnCreateUpdate").attr("value", "Update");
    });
    // FIN - MODAL UPDATE

    // INICIO - MODAL UPDATE PASSWORD
    $("#datatableGeneral tbody").on("click", ".passwordBtn", function (e) {
        // borrar validaciones
        formCheck = $("#formModal2")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        // setear data de usuario
        $("#txt_iduser2").val($(this).data("iduser"));
        $("#txt_nroidenti2").val($(this).data("nroidenti"));
        let apenom = $(this).data("apellido_pa") + " " + $(this).data("apellido_ma") + ", " + $(this).data("nombres");
        $("#txt_apenom").val(apenom);
        $("#txt_password2").val("");
        // show form
        $("#modalUpdatePassword").modal("show");
    });
    // FIN - MODAL UPDATE PASSWORD

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        let iduser = $(this).data("iduser")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(iduser);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE

    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass('was-validated'); // añadir validaciones
        } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar
                update($("#txt_iduser").val());
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE

    // INICIO - FUNCION UPDATE PASSWORD
    $("#btnUpdatePassword").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal2")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            update_password($("#txt_iduser2").val());
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION UPDATE PASSWORD

    var formModal;

    function store() {
        formModal = $('#formModal');
        $.ajax({
            type: "POST",
            url: '/admin/seguridad/administradores/store',
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update(iduser) {
        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/seguridad/administradores/update/' + iduser,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function update_password(iduser) {
        formModal = $('#formModal2');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/seguridad/administradores/update_password/' + iduser,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalUpdatePassword").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function destroy(iduser) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/seguridad/administradores/destroy/' + iduser,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LIMPIAR VALIDACIONES
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
    }

    // LIMPIAR FORMULARIO
    function clearForm() {
        $("#txt_iduser").val("");
        $("#txt_nroidenti").val("");
        $("#txt_password").val("");
        $("#txt_role_id").selectpicker("val", "");
        $("#txt_estado").selectpicker("val", "1");
        $("#txt_nombres").val("");
        $("#txt_apellido_pa").val("");
        $("#txt_apellido_ma").val("");
        $("#txt_fecnac").val("");
        $("#txt_correo").val("");
        $("#txt_telefono").val("");
        $("#txt_celular").val("");
        $("#txt_genre_id").selectpicker("val", "");
        $("#txt_direccion").val("");
        $("#txt_departamento").selectpicker("val", "");
        vaciar_provincias();
        vaciar_distritos();
        $("#txt_idadministrador").val("");
    }

    function clearClasses() {
        // limpiar clases
        $("#txt_nombres").removeClass("border border-info shadow");
        $("#txt_apellido_pa").removeClass("border border-info shadow");
        $("#txt_apellido_ma").removeClass("border border-info shadow");
        $("#txt_fecnac").removeClass("border border-info shadow");
        $("#txt_correo").removeClass("border border-info shadow");
        $("#txt_telefono").removeClass("border border-info shadow");
        $("#txt_celular").removeClass("border border-info shadow");
        $("#txt_direccion").removeClass("border border-info shadow");
        $("#txt_estado").siblings('button[type="button"]').removeClass("border border-info shadow");
        $("#txt_genre_id").siblings('button[type="button"]').removeClass("border border-info shadow");
        $("#txt_departamento").siblings('button[type="button"]').removeClass("border border-info shadow");
        $("#txt_provincia").removeClass("border border-info shadow");
        $("#txt_provincia").closest('.bootstrap-select').removeClass("border border-info shadow");
        // $("#txt_provincia").siblings('button[type="button"]').removeClass("border border-info shadow");
        $("#txt_distrito").removeClass("border border-info shadow");
        $("#txt_distrito").closest('.bootstrap-select').removeClass("border border-info shadow");
        // $("#txt_distrito").siblings('button[type="button"]').removeClass("border border-info shadow");
    }

    //Traer datos con el DNI desde la base de datos
    $("#btn-querybd").on("click", function (event) {
        var nroidenti = $("#txt_nroidenti").val();
        $.ajax({
            type: "GET",
            url: '/admin/query_bd/' + nroidenti,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                if (response.data.length == 0) {
                    notificaciontoast("error", "El usuario no existe en la base de datos", "Error!", "top-center");
                } else {
                    const dataObj = response.data;
                    for (const key in dataObj) {
                        if (dataObj.hasOwnProperty(key)) {
                            const user = dataObj[key];
                            
                            // setear data de programa
                            $("#txt_nombres").val(convertirTexto(user.nombres));
                            $("#txt_apellido_pa").val(convertirTexto(user.apellido_pa));
                            $("#txt_apellido_ma").val(convertirTexto(user.apellido_ma));
                            $("#txt_fecnac").val(user.fecnac);
                            $("#txt_correo").val(user.correo);
                            $("#txt_telefono").val(user.telefono);
                            $("#txt_celular").val(user.celular);
                            $("#txt_direccion").val(user.direccion);
                            $("#txt_estado").selectpicker("val", String(user.estado));
                            $("#txt_genre_id").selectpicker("val", String(user.idgenre));
                            $("#txt_departamento").selectpicker("val", user.iddepartamento);
                            let sl_departamento = user.departamento;
                            let sl_provincia = user.provincia;
                            let sl_distrito = user.distrito;
                            ubigeo_for_update(sl_departamento, sl_provincia, sl_distrito);
                            
                            // añadir clases
                            $("#txt_nombres").addClass("border border-info shadow");
                            $("#txt_apellido_pa").addClass("border border-info shadow");
                            $("#txt_apellido_ma").addClass("border border-info shadow");
                            $("#txt_fecnac").addClass("border border-info shadow");
                            $("#txt_correo").addClass("border border-info shadow");
                            $("#txt_telefono").addClass("border border-info shadow");
                            $("#txt_celular").addClass("border border-info shadow");
                            $("#txt_direccion").addClass("border border-info shadow");
                            $("#txt_estado").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_genre_id").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_departamento").siblings('button[type="button"]').addClass("border border-info shadow");
                            $("#txt_provincia").addClass("border border-info shadow");
                            $("#txt_distrito").addClass("border border-info shadow");
                            
                            // remover clases después de un tiempo
                            setTimeout(function () {
                                clearClasses();
                            }, 1000);
                        }
                    }
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

    //Traer datos con el DNI desde la RENIEC
    $("#btn-querydata").on("click", function (event) {
        var nroidenti = $("#txt_nroidenti").val();
        $.ajax({
            type: "GET",
            url: '/admin/query_data/' + nroidenti,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                const dataObj = JSON.parse(response.data);
                if (dataObj.hasOwnProperty('message')) {
                    console.log(dataObj.message);
                    notificaciontoast("error", "Datos del DNI no encontrado", "Error!", "top-center");
                } else {
                    $("#txt_nombres").val(convertirTexto(dataObj.nombres));
                    $("#txt_apellido_pa").val(convertirTexto(dataObj.apellidoPaterno));
                    $("#txt_apellido_ma").val(convertirTexto(dataObj.apellidoMaterno));
                    // setear data de programa
                    $("#txt_nombres").addClass("border border-info shadow");
                    $("#txt_apellido_pa").addClass("border border-info shadow");
                    $("#txt_apellido_ma").addClass("border border-info shadow");
                    // remover clases después de un tiempo
                    setTimeout(function () {
                        $("#txt_nombres").removeClass("border border-info shadow");
                        $("#txt_apellido_pa").removeClass("border border-info shadow");
                        $("#txt_apellido_ma").removeClass("border border-info shadow");
                    }, 300);
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    });

    function convertirTexto(texto) {
        texto = texto.toLowerCase();
        var palabras = texto.split(' ');
        for (var i = 0; i < palabras.length; i++) {
            palabras[i] = palabras[i].charAt(0).toUpperCase() + palabras[i].substring(1);
        }
        var resultado = palabras.join(' ');
        
        return resultado;
    }

    // INICIO - FUNCION INSERTAR PLANTILLA ************************* LISTO
    $("#btn_insert_plantilla").click(function () {
        if (datajsondos.length > 0) {
            // confirmacion
            confirmation_sweetAlert(
                "Deseas continuar?",
                "Se procederá a insertar la plantilla a la base de datos, consideras que los datos enviados son los correctos",
                "warning"
            ).then(function (isConfirm) {
                if (isConfirm.value) {
                    store_plantilla();
                } else {
                }
            });
        } else {
            notificaciontoast("error", "Seleccione una plantilla y previsualice", "Error", "bottom-right", "2500");
        }
    });
    // FIN

        //
    var tableName2 = "datatableGeneral_preview_Excel";


    //INSERTAR STUDENTS DE PLANTILLA EXCEL
    function store_plantilla() {
        //
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/seguridad/administradores/storePlantilla",
            data: { datajsondos: datajsondos },
            dataType: "json",
            beforeSend: function () {
                // mostrar preloader
                $("#modalCargandoExcel").modal("show");
                document.getElementById('div_progressbar_modal_preload').innerHTML =
                    ` <div class="drive-content mt-2 mx-2 p-1">
                        <div class="progress default-progress">
                            <div class="progress-bar bg-vigit progress-animated bg-info" style="width: 100%; height:100%;" role="progressbar">
                                <span id="txt_title_progressbar">... Cargando!</span>
                            </div>
                        </div>
                    </div>`
                document.getElementById("id_preload_excel").innerHTML = " Registrando";
            },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    document.getElementById("id_preload_excel").innerHTML = " " + data.mensaje;
                    table.ajax.reload();
                    // preloader
                    document.getElementById("hiddenswitch").value = "1";
                    if (document.getElementById("hiddenswitch").value == "1") {
                        document.getElementById("hiddenswitch").value = "0";
                        setTimeout(function () {
                            // limpiar preloader
                            document.getElementById('div_progressbar_modal_preload').innerHTML = ""
                            document.getElementById("id_preload_excel").innerHTML = "";
                            $("#modalCargandoExcel").modal("hide");
                            $("#file_select_plantilla").val("");
                            $("#btn_previsualizar_plantilla").prop("disabled", true);
                            datajsondos.splice(0, datajsondos.length);
                            // limpiart tabla
                            $("#datatableGeneral_preview_Excel").DataTable().clear().draw();
                        }, 3500);
                    }

                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                    document.getElementById("id_preload_excel").innerHTML = " " + data.mensaje;
                    // preloader
                    document.getElementById("hiddenswitch").value = "1";
                    if (document.getElementById("hiddenswitch").value == "1") {
                        document.getElementById("hiddenswitch").value = "0";
                        setTimeout(function () {
                            // limpiar preloader
                            document.getElementById('div_progressbar_modal_preload').innerHTML = ""
                            document.getElementById("id_preload_excel").innerHTML = "";
                            $("#modalCargandoExcel").modal("hide");
                            $("#file_select_plantilla").val("");
                            $("#btn_previsualizar_plantilla").prop("disabled", true);
                            datajsondos.splice(0, datajsondos.length);
                            // limpiart tabla
                            $("#datatableGeneral_preview_Excel").DataTable().clear().draw();
                        }, 3500);
                    }
                }

            },
            error: function (error) {
                document.getElementById('div_progressbar_modal_preload').innerHTML = ""
                document.getElementById("id_preload_excel").innerHTML = "";
                $("#modalCargandoExcel").modal("hide");
                console.log("Error", error);
            },
        });
    }

        /* ---------------------------------  METODO CARGAR PLANTILLA DE EXCEL ------------------------------------------------- */
    var datajsondos = [];
    var clickdato = true;

    //activar boton cargar excel una ves que se haya selecionado el archivo excel en el input type "file"
    $("#file_select_plantilla").change(function () {
        $("#btn_previsualizar_plantilla").prop(
            "disabled",
            this.files.length == 0
        );
    });

    function CargardatosdelExcel() {
        // Obtener el archivo seleccionado
        var archivo = document.getElementById("file_select_plantilla").files[0];
        // Crear un objeto FileReader para leer el archivo
        var reader = new FileReader();
        reader.onload = function (e) {
            // Obtener los datos del archivo
            var data = e.target.result;
            var workbook = XLSX.read(data, {
                type: "binary",
            });

            // Obtener los datos de la primera hoja del archivo
            var sheetName = workbook.SheetNames[0];
            var sheet = workbook.Sheets[sheetName];

            var rangoInicio = "A4"; // Cambia la celda de inicio según sea necesario (columna B, fila 2)

            var rangoCompleto = sheet["!ref"]; // Obtiene el rango completo de la hoja
            var rangoFinal = rangoCompleto.split(":")[1]; // Obtiene la celda final del rango completo

            var rango = rangoInicio + ":" + rangoFinal;

            var datajson = XLSX.utils.sheet_to_json(sheet, {
                header: 1, // Indica que la primera fila es el encabezado
                range: rango, // Empieza desde la fila 2 (cero-indexed)
            });

            //recorremos el datajson del excel este contiene dato con filas nulas o no definidas
            datajson.forEach((row) => {
                // Si la fila tiene al menos un valor distinto de null o undefined
                if (row.some((cell) => cell !== null && cell !== undefined)) {
                    //llenamos el array de javaScript
                    datajsondos.push(row);
                }
            });

            $("#datatableGeneral_preview_Excel").DataTable({
                data: datajsondos,
                order: [],
                searching: true,
                dom: "Bfrtip",
                select: false,
                lengthChange: false,
                responsive: true,
                language: languageSchema,
                buttons: getButtonsSchema(tableName2),
                fnCreatedRow: function (row, data, dataIndex) {
                    $(row).attr("id", "fila-" + dataIndex);
                    $(row)
                        .find("td")
                        .each(function (i) {
                            $(this).attr(
                                "id",
                                "fila-" + dataIndex + "-col-" + i
                            );
                        });
                },
                columns: [
                    {
                        data: `${[0]}`,
                        render: function (data, type, row, meta) {
                            return `${row[0]}`;
                        },
                    },
                    {
                        data: `${[1]}`,
                        render: function (data, type, row, meta) {
                            return `${row[1]}`;
                        },
                    },
                    {
                        data: [2],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[2]}`;
                        },
                    },
                    {
                        data: [3],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[3]}`;
                        },
                    },
                    {
                        data: [4],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[4]}`;
                        },
                    },
                    {
                        data: [5],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[5]}`;
                        },
                    },
                    {
                        data: [6],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[6]}`;
                        },
                    },
                    {
                        data: [7],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[7]}`;
                        },
                    },
                    {
                        data: [8],
                        className: "text-start",
                            render: function (data, type, row, meta) {
                                var dateValue = row[8];
                                if (type === 'display' && dateValue) {
                                    // Convertir el valor de la celda a un objeto de fecha
                                    var excelDate = new Date((dateValue - (25567 + 1)) * 86400 * 1000);
                                    // Formatear la fecha en el formato deseado (por ejemplo, DD/MM/YYYY)
                                    var formattedDate = excelDate.toLocaleDateString('es-ES');
                                    // Devolver la fecha formateada
                                    return formattedDate;
                                } else {
                                    return data;
                                }
                            },
                    },
                    {
                        data: [9],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[9]}`;
                        },
                    },
                    {
                        data: [10],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[10]}`;
                        },
                    },
                    {
                        data: [11],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[11]}`;
                        },
                    },
                    {
                        data: [12],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[12]}`;
                        },
                    },
                    {
                        data: [13],
                        className: "text-start",
                        render: function (data, type, row, meta) {
                            return `${row[13]}`;
                        },
                    },
                ],
            });
        };
        reader.readAsBinaryString(archivo);
    }

    let btnjs_btn_previsualizar_plantilla = document.querySelector(
        "#btn_previsualizar_plantilla"
    );
    btnjs_btn_previsualizar_plantilla.addEventListener("click", function (e) {
        e.preventDefault();

        if (clickdato == true) {
            CargardatosdelExcel();
            clickdato = false;
            datajsondos.splice(0, datajsondos.length);
        } else {
            datajsondos.splice(0, datajsondos.length);
            $("#datatableGeneral_preview_Excel").DataTable().destroy();
            CargardatosdelExcel();
        }
    });
});


