"use strict";
import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {
    const tableName = "Items_Titulacion";
    var number = 0;
    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: "/admin/seguimiento_egresado/items_titulacion/list",
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),


        columns: [
            { data: "id", className: "text-center" },
            { data: "concepto", className: "text-center" },
            {
                data: "descripcion",
                className: "text-start descripcion-col",
                render: function (data, type, row) {
                    if (!data) return "";
                    return data;
                },
            },
            

            { data: "estado", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    if (all.estado == "1") {
                        return `<span class="badge light badge-success">Activo</span>`;
                    } else {
                        return `<span class="badge light badge-danger">Inactivo</span>`;
                    }
                },
            },


            {
                data: "created_at",
                className: "text-center",
                render: function (data, type, row) {
                    if (!data) return "";
                    const d = new Date(data);
                    if (isNaN(d)) return data; // por si acaso
            
                    const pad = (n) => n.toString().padStart(2, "0");
                    const dia   = pad(d.getDate());
                    const mes   = pad(d.getMonth() + 1);
                    const anio  = d.getFullYear();
                    const hora  = pad(d.getHours());
                    const min   = pad(d.getMinutes());
            
                    return `${dia}/${mes}/${anio} ${hora}:${min}`;
                },
            },
            {
                data: "updated_at",
                className: "text-center",
                render: function (data, type, row) {
                    if (!data) return "";
                    const d = new Date(data);
                    if (isNaN(d)) return data;

                    const pad = (n) => n.toString().padStart(2, "0");
                    const dia   = pad(d.getDate());
                    const mes   = pad(d.getMonth() + 1);
                    const anio  = d.getFullYear();
                    const hora  = pad(d.getHours());
                    const min   = pad(d.getMinutes());

                    return `${dia}/${mes}/${anio} ${hora}:${min}`;
                },
            },
            


            {
                data: "id",
                className: "text-center",
                sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                
                            <!-- Editar -->
                            <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                data-id="${all.id}"
                                data-concepto="${all.concepto}"
                                data-descripcion="${all.descripcion}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                            </a>
                
                            <!-- Actualizar estado -->
                            <a href="javascript:void(0);" class="estadoBtn btn btn-info shadow btn-xs sharp me-1"
                                data-id="${all.id}"
                                data-estado="${all.estado}"
                                data-bs-placement="top"
                                title="Actualizar estado / visibilidad">
                                <i class="fas fa-sync-alt"></i>
                            </a>


                            <!-- Eliminar -->
                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-id="${all.id}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                            </a>
                
                        </div>
                    `;
                },
                


            },
        ],
    });

    // Agregar una columna de números automáticos
    table
        .on("order.dt search.dt", function () {
            table
                .column(0, { search: "applied", order: "applied" })
                .nodes()
                .each(function (cell, i) {
                    cell.innerHTML = i + 1;
                });
        })
        .draw();

    // - - - - - - - - - - M O D A L S - - - - - - - - - -
    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        document.getElementById("btnCreateUpdate").setAttribute("value", "Create");
        document.getElementById("btnCreateUpdate").innerHTML = "Guardar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Registrar datos de Items Titulacion";
        clearCheck();
        Clearform();
    
        // 👇 mostrar y habilitar estado SOLO en crear
        $("#col-estado-create").removeClass("d-none");
        $("#txt-estado").prop("disabled", false);
    });    
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        clearCheck();
        document.getElementById("btnCreateUpdate").innerHTML = "Actualizar";
        document.getElementById("modalCreateUpdateLabel").innerHTML = "Actualizar datos del Item";
    
        document.getElementById("txt-id").value = $(this).attr("data-id");
        document.getElementById("txt-concepto").value = $(this).attr("data-concepto");
        document.getElementById("txt-descripcion").value = $(this).attr("data-descripcion");
    
        //ocultar y deshabilitar estado para que NO se envíe en update
        $("#col-estado-create").addClass("d-none");
        $("#txt-estado").prop("disabled", true).val("");
    
        $("#modalCreateUpdate").modal("show");
        document
            .getElementById("btnCreateUpdate")
            .setAttribute("value", "Update");
    });
    // FIN - MODAL UPDATE



    // INICIO - MODAL UPDATE ESTADO
    $("#datatableGeneral tbody").on("click", ".estadoBtn", function (e) {
        clearCheckEstado();

        const id = $(this).data("id");
        const estado = $(this).data("estado"); // 0 o 1

        $("#txt-id-estado").val(id);

        // Normalizar siempre a "0" o "1" como string
        const estadoValue = parseInt(estado, 10) == 1 ? "1" : "0";
        $("#estado-item").val(estadoValue);

        $("#modalUpdateEstado").modal("show");
    });
    // FIN - MODAL UPDATE ESTADO








    var valbtn, formCheck;
    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass("was-validated"); // añadir validaciones
        } else {
            // obtener valor del boton
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar tabla cargo
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar tabla cargo
                update();
            }
        }
    });
    // FIN - FUNCION CREATE O UPDATE

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        var id = $(this).attr("data-id");
        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a eliminar el registro de la base de datos",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                destroy(id);
            } else {
                console.log("Cancelado");
            }
        });
    });

    // INICIO - FUNCION UPDATE ESTADO
    $("#btnUpdateEstado").on("click", function (event) {
        event.preventDefault();
    
        const formEstado = $("#formEstado")[0];
        if (!formEstado.checkValidity()) {
            event.stopPropagation();
            $(formEstado).addClass("was-validated");
            return;
        }
    
        updateEstado();
    });
    









    var formModal;

    // - - - - - - - - - - F U N C I O N E S - - - - - - - - - -
    function store() {
        formModal = $("#formModal");
        $.ajax({
            type: "POST",
            url: "/admin/seguimiento_egresado/items_titulacion/store",
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: function () { },


            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000);
                } else {
                    console.log("Error backend:", data.error); // 👈 IMPORTANTE
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            


            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update() {
        formModal = $("#formModal");
        var id = document.getElementById("txt-id").value;
        var formData = $("#formModal").serialize();
        $.ajax({
            type: "PUT",
            url: "/admin/seguimiento_egresado/items_titulacion/update/" + id,
            data: formData,
            dataType: "json",
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function destroy(id) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/seguimiento_egresado/items_titulacion/destroy/" + id,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // FUNCION ACTUALIZAR ESTADO
    function updateEstado() {
        const id = $("#txt-id-estado").val();
        const estado = $("#estado-item").val();
    
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').first().val() },
            type: "PUT",
            url: "/admin/seguimiento_egresado/items_titulacion/updateestado/" + id,
            data: { estado: estado },
            dataType: "json",
            beforeSend: function () {},
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                    setTimeout(function () {
                        $("#modalUpdateEstado").modal("hide");
                    }, 800);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
    
    function clearCheckEstado() {
        const formEstado = $("#formEstado")[0];
        $(formEstado).removeClass("was-validated");
    }
    

    // LIMPIAR VALIDACIONES
    function clearCheck() {
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
    }

    // - - - - - - - - - - LIMPIAR CAMPOS - - - - - - - - - -
    function Clearform() {
        document.getElementById("txt-id").value = "";
        $("#txt-concepto").val("");
        $("#txt-descripcion").val("");
        $("#txt-estado").val("");
    }
});
