import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import { tl_plans } from "../../common/timeline/programs.js";
import { cb_itemstitulacion } from "../../common/combobox/itemstitulacion.js";

$(document).ready(function () {

    const tableName = "Documentos de Titulación";
    var dt_idstudent = "0", dt_idplan = "0";

    // =======================================================
    // ===================== DATATABLE =======================
    // =======================================================

    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/seguimiento_egresado/documentos_titulacion/list",
            data: function (d) {
                d.idstudent = dt_idstudent !== "0" ? dt_idstudent : "";
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "id", className: "text-center" },
            { data: "item_concepto", className: "text-center" },
            {
                data: "archivo",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    if (data == null) {
                        return "--Sin PDF--";
                    } else {
                        return `
                            <div class="d-flex justify-content-center">
                                <a href="/admin/seguimiento_egresado/documentos_titulacion/ver/${all.id}"
                                    class="btnVerArchivo btn btn-info shadow btn-xs sharp me-1" target="_blank" data-bs-placement="top"
                                    title="Ver Archivo">
                                    <i class="fas fa-file-lines fa-lg"></i>
                                </a>
                            </div>
                        `;
                    }
                },
            },
            {
                data: "estado",
                className: "text-center",
                sortable: false,
                render: function (data, type, all) {
                    switch (all.estado) {
                        case "0":
                        case 0:
                            return `<span class="badge light" style="background:#ff9800; color:white;">Pendiente</span>`;
                        case "1":
                        case 1:
                            return `<span class="badge light badge-success">Aprobado</span>`;
                        case "2":
                        case 2:
                            return `<span class="badge light badge-danger">Rechazado</span>`;
                        case "3":
                        case 3:
                            return `<span class="badge light" style="background:#2196f3; color:white;">Observado</span>`;
                        default:
                            return `<span class="badge light badge-secondary">Desconocido</span>`;
                    }
                },
            },
            {
                data: "permiso_observacion",
                className: "text-center",
                sortable: false,
                render: function (data, type, all, meta) {
                    if (all.permiso_observacion == "1") {
                        return `<span class="badge light badge-success">Permitido</span>`;
                    } else {
                        return `<span class="badge light badge-danger">Sin Permiso</span>`;
                    }
                },
            },
            {
                data: "es_visible",
                className: "text-center",
                sortable: false,
                render: function (data, type, all, meta) {
                    if (all.es_visible == "1") {
                        return `<span class="badge light badge-success">Visible</span>`;
                    } else {
                        return `<span class="badge light badge-danger">Oculto</span>`;
                    }
                },
            },
            {
                data: "id",
                className: "text-center",
                sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <!-- Editar -->
                            <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                data-id="${all.id}"
                                data-es_visible="${all.es_visible}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                            </a>

                            <!-- Actualizar estado -->
                            <a href="javascript:void(0);" class="estadoBtn btn btn-info shadow btn-xs sharp me-1"
                                data-id="${all.id}"
                                data-estado="${all.estado}"
                                data-bs-placement="top"
                                title="Actualizar estado del documento">
                                <i class="fas fa-sync-alt"></i>
                            </a>

                            <!-- Actualizar permiso de observación -->
                            <a href="javascript:void(0);" 
                                class="permisoObservacionBtn btn btn-primary shadow btn-xs sharp me-1"
                                data-id="${all.id}"
                                data-permiso_observacion="${all.permiso_observacion}"
                                title="Actualizar permiso de observación">
                                <i class="fas fa-user-check"></i>
                            </a>

                            <!-- Eliminar -->
                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-id="${all.id}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                            </a>
                        </div>
                    `;
                },
            },
        ],
    });

    table
        .on("order.dt search.dt", function () {
            table
                .column(0, { search: "applied", order: "applied" })
                .nodes()
                .each(function (cell, i) {
                    cell.innerHTML = i + 1;
                });
        })
        .draw();

    // =======================================================
    // ======= PROGRAMAS / PLANES / ALUMNOS (TIMELINES) ======
    // =======================================================

    $("#tlprogram").on("click", ".btnProgram", function (e) {
        e.preventDefault();

        dt_idstudent = "0";
        cleanInfoAlumno();

        $(".divprogram").removeClass("dark").addClass("primary");
        $(this).prev(".divprogram").removeClass("primary").addClass("dark");

        const idProgram = $(this).data("idprogram");
        tl_plans(idProgram);

        $("#txt-students").find("option").remove().end();
        $("#txt-students").append('<option selected disabled value="">Buscar alumno</option>');
        $("#txt-students").selectpicker("refresh");

        table.ajax.reload();
    });

    $("#tlplan").on("click", ".btnPlan", function (e) {
        e.preventDefault();

        dt_idstudent = "0";
        cleanInfoAlumno();

        $(".divplan").removeClass("dark").addClass("primary");
        $(this).prev(".divplan").removeClass("primary").addClass("dark");

        dt_idplan = $(this).data("idplan");

        cb_students(dt_idplan);

        notificaciontoast("info", "Consultando a la base de datos!", "Mensaje!");
        table.ajax.reload();
    });

    function cb_students(idplan) {
        let apenom;

        $("#txt-students").find("option").remove().end();

        $.ajax({
            type: "GET",
            url: "/ajax_all/students_egresados/" + idplan,
            dataType: "json",
            success: function (response) {
                $("#txt-students").append('<option selected disabled value="">Buscar alumno</option>');
                response.forEach((elemento) => {
                    apenom = elemento.apellido_pa + " " + elemento.apellido_ma + ", " + elemento.nombres;
                    $("#txt-students").append(
                        '<option' +
                        ' value="' + elemento.idstudent + '" ' +
                        ' data-subtext="' + elemento.nroidenti + '" ' +
                        ' data-idstudent="' + elemento.idstudent + '" ' +
                        ' data-apellido_pa="' + elemento.apellido_pa + '" ' +
                        ' data-apellido_ma="' + elemento.apellido_ma + '" ' +
                        ' data-nombres="' + elemento.nombres + '" ' +
                        ' data-tipoidenti="' + elemento.tipoidenti + '" ' +
                        ' data-nroidenti="' + elemento.nroidenti + '" ' +
                        ' data-celular="' + elemento.celular + '" ' +
                        ' data-fec_egreso="' + elemento.fec_egreso + '" ' +
                        ' data-estado="' + elemento.estado + '" ' +
                        ">" + apenom + "</option>"
                    );
                });
                $("#txt-students").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    var selectedOption;

    $("#txt-students").on("change", function () {
        dt_idstudent = $(this).val();
        selectedOption = $(this).find("option:selected");
        let apenom =
            selectedOption.data("apellido_pa") +
            " " +
            selectedOption.data("apellido_ma") +
            ", " +
            selectedOption.data("nombres");
        $("#txt-info-nombres").html(apenom);
        $("#txt-info-id").html(selectedOption.data("tipoidenti") + ": " + selectedOption.data("nroidenti"));
        $("#txt-info-fec_egreso").html(selectedOption.data("fec_egreso"));

        table.ajax.reload();
    });

    function cleanInfoAlumno() {
        $("#txt-info-nombres").html("--");
        $("#txt-info-id").html("--");
        $("#txt-info-fec_egreso").html("--");
    }

    // =======================================================
    // ===================== MODAL CREATE =====================
    // =======================================================

    $("#btnCreateModal").click(function () {
        if (dt_idstudent == "0") {
            notificaciontoast("error", "Debe seleccionar un estudiante antes de registrar un documento", "Error!");
            return;
        }

        $("#btnCreateUpdate").val("Create");
        $("#btnCreateUpdate").html("Guardar");
        $("#modalCreateUpdateLabel").html("Registrar nuevo Documento de Titulación");

        clearCheck();
        clearForm();

        $("#group-item-titulacion").removeClass("d-none");
        $("#group-estado").removeClass("d-none");
        $("#group-permiso").removeClass("d-none");
        $("#group-visible").removeClass("d-none");
        $("#group-archivo").removeClass("d-none");

        $("#txt-archivo").prop("required", false);
        $("#txt-item_titulacion").prop("disabled", false);

        // 👉 AQUÍ se cargan los ítems SOLO para STORE
        cb_itemstitulacion();

        $("#txt-item_titulacion").val("");
        $("#txt-id").val("");
        $("#modalCreateUpdate").modal("show");
    });

    // =======================================================
    // ===================== MODAL EDITAR =====================
    // =======================================================

    $("#datatableGeneral tbody").on("click", ".editBtn", function () {
        clearCheck();

        $("#btnCreateUpdate").val("Update");
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar documento");

        const id        = $(this).attr("data-id");
        const esVisible = $(this).attr("data-es_visible");

        $("#txt-id").val(id);

        // ---- es_visible usa selectpicker ----
        $("#txt-es_visible").selectpicker("val", String(esVisible));
        $("#txt-es_visible").selectpicker("refresh");

        // 👉 NO tocamos ítem ni estado ni permiso en editar
        $("#group-item-titulacion").addClass("d-none");
        $("#group-estado").addClass("d-none");
        $("#group-permiso").addClass("d-none");

        $("#group-visible").removeClass("d-none");
        $("#group-archivo").removeClass("d-none");

        $("#txt-archivo").prop("required", false).val("");

        $("#modalCreateUpdate").modal("show");
    });

    

    // ===================== GUARDAR / ACTUALIZAR =====================

    $("#btnCreateUpdate").click(function (e) {
        e.preventDefault();

        const form = $("#formModal")[0];
        if (!form.checkValidity()) {
            $(form).addClass("was-validated");
            return;
        }

        const action = $("#btnCreateUpdate").val();

        if (action === "Create") store();
        if (action === "Update") update();
    });

    // 👉 STORE: item + archivo + estado + permiso + es_visible
    function store() {
        let formData = new FormData();
        formData.append("student_id", dt_idstudent);
        formData.append("item_titulacion_id", $("#txt-item_titulacion").val());
        formData.append("estado", $("#txt-estado").val());
        formData.append("permiso_observacion", $("#txt-permiso_observacion").val());
        formData.append("es_visible", $("#txt-es_visible").val());
        formData.append("_token", $('input[name="_token"]').val());

        let file = $("#txt-archivo")[0].files[0];
        formData.append("archivo", file);

        $.ajax({
            url: "/admin/seguimiento_egresado/documentos_titulacion/store",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                    setTimeout(() => $("#modalCreateUpdate").modal("hide"), 800);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
        });
    }

    // 👉 UPDATE: SOLO archivo + es_visible (según tu requerimiento)
    function update() {
        let id = $("#txt-id").val();

        let formData = new FormData();
        formData.append("es_visible", $("#txt-es_visible").val());
        formData.append("_token", $('input[name="_token"]').val());
        formData.append("_method", "PUT");

        let file = $("#txt-archivo")[0].files[0];
        if (file) formData.append("archivo", file);

        $.ajax({
            url: "/admin/seguimiento_egresado/documentos_titulacion/update/" + id,
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Actualizado!");
                    table.ajax.reload();
                    setTimeout(() => $("#modalCreateUpdate").modal("hide"), 800);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
        });
    }

    // ===================== ELIMINAR =====================

    $("#datatableGeneral tbody").on("click", ".deleteBtn", function () {
        const id = $(this).data("id");

        confirmation_sweetAlert(
            "¿Desea eliminar el documento?",
            "Esta acción no se puede deshacer",
            "warning"
        ).then((res) => {
            if (res.value) destroy(id);
        });
    });

    function destroy(id) {
        $.ajax({
            url: "/admin/seguimiento_egresado/documentos_titulacion/destroy/" + id,
            type: "DELETE",
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
        });
    }





    // ===================== MODAL ESTADO =====================

    $("#datatableGeneral tbody").on("click", ".estadoBtn", function () {
        const id           = $(this).attr("data-id");
        const estadoActual = String($(this).attr("data-estado"));

        $("#txt-id-estado").val(id);

        // Reset y set con selectpicker
        $("#estado-documento").selectpicker("val", "");
        $("#estado-documento").selectpicker("val", estadoActual);
        $("#estado-documento").selectpicker("refresh");

        $("#modalUpdateEstado").modal("show");
    });

    $("#btnUpdateEstado").click(function () {
        updateEstado();
    });

    function updateEstado() {
        let id = $("#txt-id-estado").val();

        $.ajax({
            url: "/admin/seguimiento_egresado/documentos_titulacion/updateestado/" + id,
            type: "PUT",
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            data: { estado: $("#estado-documento").val() },
            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                    $("#modalUpdateEstado").modal("hide");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
        });
    }



    // ===================== MODAL PERMISO =====================

    $("#datatableGeneral tbody").on("click", ".permisoObservacionBtn", function () {
        const id      = $(this).attr("data-id");
        const permiso = String($(this).attr("data-permiso_observacion"));

        $("#txt-id-permiso").val(id);

        // Reset y set con selectpicker
        $("#permiso-documento").selectpicker("val", "");
        $("#permiso-documento").selectpicker("val", permiso);
        $("#permiso-documento").selectpicker("refresh");

        $("#modalUpdatePermiso").modal("show");
    });

    $("#btnUpdatePermiso").click(function () {
        updatePermiso();
    });

    function updatePermiso() {
        let id = $("#txt-id-permiso").val();

        $.ajax({
            url: "/admin/seguimiento_egresado/documentos_titulacion/updatepermiso_observacion/" + id,
            type: "PUT",
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            data: { permiso_observacion: $("#permiso-documento").val() },

            success: function (data) {
                if (data.status) {
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    table.ajax.reload();
                    $("#modalUpdatePermiso").modal("hide");
                } else {
                    notificaciontoast("error", data.mensaje || "Ocurrió un error al actualizar el permiso.", "Error!");
                }
            },

            error: function (xhr) {
                let msg = "Error inesperado al actualizar el permiso.";

                if (xhr.responseJSON && xhr.responseJSON.mensaje) {
                    msg = xhr.responseJSON.mensaje;
                }

                notificaciontoast("error", msg, "Error!");
            },
        });
    }

    

    // ===================== LIMPIAR FORM =====================

    function clearCheck() {
        $("#formModal").removeClass("was-validated");
    }

    function clearForm() {
        $("#txt-id").val("");
    
        $("#txt-item_titulacion").selectpicker("val", "");
        $("#txt-estado").selectpicker("val", "");
        $("#txt-permiso_observacion").selectpicker("val", "");
        $("#txt-es_visible").selectpicker("val", "");
    
        $("#txt-item_titulacion").selectpicker("refresh");
        $("#txt-estado").selectpicker("refresh");
        $("#txt-permiso_observacion").selectpicker("refresh");
        $("#txt-es_visible").selectpicker("refresh");
    
        $("#txt-archivo").val("");
    }


    
    
});
