import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';

$(document).ready(function () {

    const tableName = "Semestre por Periodo Lectivo";
    var dt_idsemester = "0", dt_idprogram = "0", dt_idperiod = "0", formModal;

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/cursos/periodos_semestre/list',
            beforeSend: function () {
                notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
            },
            data: function (d) {
                d.idsemester = dt_idsemester;
                d.idprogram = dt_idprogram;
            },
        },
        searching: true,
        pageLength: 12, // 12 filas
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "idplan", className: "text-center", name: "primero",
                render: function (data, type, all, meta) {
                    return "<h3>" + all.nombreplan + "</h3>" +
                        "<br>" +
                        "<b> Tipo: </b>" + all.tipo +
                        "<br>" +
                        "<b> Modalidad: </b>" + all.modalidad +
                        "<br>" +
                        "<b> Enfoque: </b>" + all.enfoque
                },
                
            },
            { data: 'numeroperiod', className: 'text-center', sortable: false, },
            { data: "relacion_estado", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnVerCursos btn btn-info shadow btn-xs sharp"
                            data-idperiod="${all.idperiod}"
                            data-bs-placement="top"
                            title="Ver Curso">
                            <i class="fas fa-eye fa-lg"></i>
                            </a>
                        </div>
                        `;
                },
            },
            { data: "relacion_estado", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.relacion_estado == "1") {
                        return `<span class="badge light badge-success">Relacionado</span>`;
                    } else {
                        return `<span class="badge light badge-danger">No Relacionado</span>`;
                    }
                },
            },
            { data: "relacion_estado", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.relacion_estado == "1") {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnDesenlazar btn btn-danger shadow btn-xs sharp"
                            data-idsemesterperiod="${all.idsemesterperiod}"
                            data-bs-placement="top"
                            title="Desenlazar">
                            <i class="fas fa-x fa-lg"></i>
                            </a>
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnEnlazar btn btn-success shadow btn-xs sharp"
                            data-idsemester="${all.idsemester}"
                            data-idperiod="${all.idperiod}"
                            data-bs-placement="top"
                            title="Enlazar">
                            <i class="fas fa-link fa-beat fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
        ],
        rowsGroup: [
            'primero:name',
        ],
    });


    // INICIO - SELECCIONAR SEMESTRE
    $("#tlsemester").on("click", ".btnSemester", function (e) {
        dt_idsemester = $(this).data("idsemester");
        $("#txt-anho_numero").html($(this).data("anho") + " - " + $(this).data("numero"));
        $("#txt-fecinicio").html($(this).data("fecinicio"));
        $("#txt-fecfin").html($(this).data("fecfin"));
        //Colorear la opcion seleccionada
        $('.divsemester').removeClass("dark").addClass("primary");
        $(this).prev('div').removeClass("primary").addClass("dark");
        //Info toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        // CARGAR TABLA
        table.ajax.reload();

    });
    // FIN - SELECCIONAR SEMESTRE


    // INICIO - SELECCIONAR PROGRAMA
    $("#tlprogram").on("click", ".btnProgram", function (e) {
        dt_idprogram = $(this).data("idprogram");
        $("#txt-codprograma").html($(this).data("codprograma"));
        $("#txt-nombre").html($(this).data("nombre"));
        $("#txt-nivel_formativo").html($(this).data("nivel_formativo"));
        //Colorear la opcion seleccionada
        $('.divprogram').removeClass("dark").addClass("primary");
        $(this).prev('div').removeClass("primary").addClass("dark");
        //Info toast
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        // CARGAR TABLA
        table.ajax.reload();
    });
    // FIN - SELECCIONAR PROGRAMA


    // INICIO - MODAL ENLAZAR
    $("#datatableGeneral tbody").on("click", ".btnEnlazar", function (e) {
        let idsemester = $(this).data("idsemester");
        let idperiod = $(this).data("idperiod");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a registrar el PERIODO seleccionado y sus CURSOS en el PERIODO LECTIVO seleccionado", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    $("#txt-idsemester").val(idsemester)
                    $("#txt-idperiod").val(idperiod)
                    enlazar();
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL ENLAZAR

    function enlazar() {
        formModal = $('#formModal');
        $.ajax({
            type: "POST",
            url: '/admin/cursos/periodos_semestre/store',
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - MODAL DESENLAZAR
    $("#datatableGeneral tbody").on("click", ".btnDesenlazar", function (e) {
        let idsemesterperiod = $(this).data("idsemesterperiod");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro seleccionado y las ASIGNATURAS del PERIODO LECTIVO seleccionado", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    desenlazar(idsemesterperiod);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DESENLAZAR

    function desenlazar(idsemesterperiod) {
        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/cursos/periodos_semestre/destroy/' + idsemesterperiod,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // LISTAR DATATABLE 2
    var table2 = $('#datatableGeneral2').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/cursos/periodos_semestre/list_by_idperiod',
            data: function (d) {
                d.idperiod = dt_idperiod;
            },
        },
        searching: false,
        paging: false, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 12, // 12 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        columns: [
            { data: 'id', className: 'text-center' },
            { data: 'codcurso', className: 'text-center' },
            { data: 'nombre', className: 'text-center' },
            { data: 'tipo', className: 'text-center' },
            {
                data: "creditos-horas",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    return "Cr: " + all.creditos + " - Hrs: " + all.horas;
                }
            },
        ],
    });

    // Agregar una columna de números automáticos
    table2.on('order.dt search.dt', function () {
        table2.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    // INICIO - MODAL VER CURSOS
    $("#datatableGeneral tbody").on("click", ".btnVerCursos", function (e) {
        dt_idperiod = $(this).data("idperiod");
        // cargar tabla
        table2.ajax.reload();
        setTimeout(function () { $("#modalDetalleCursos").modal("show"); }, 500); // mostrar despues de x sec
        // mostrar modal
    });
    // FIN - MODAL VER CURSOS


});


