import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { integer_to_roman } from "../../utils/number_functions.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";
import {
    tl_periods,
    tl_plans,
} from "../../common/timeline/programs.js";
import { cb_teachers } from "../../common/combobox/teachers.js";

$(document).ready(function () {

    const tableName = "Asignaturas";
    var dt_idsemester = "0",
        dt_idplan = "0",
        dt_idperiod = "0";
    var formModal, formData, formCheck;
    // LISTAR DATATABLE

    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/cursos/asignaturas/list",
            data: function (d) {
                d.idsemester = dt_idsemester;
                d.idperiod = dt_idperiod;
            },
        },
        searching: true,
        pageLength: 12, // 12 filas
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: "nomcurso", className: "text-center", sortable: false },
            {
                data: "tipo", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    return all.tipo;
                },
            },
            {
                data: "creditos-horas", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return "Cr: " + all.creditos + " - Hrs: " + all.horas;
                },
            },
            {
                data: "seccion", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    if (all.seccion == "") {
                        return "--";
                    } else {
                        return all.seccion;
                    }
                },
            },
            {
                data: "turno", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    if (all.turno == "") {
                        return "--";
                    } else {
                        return all.turno;
                    }
                },
            },
            {
                data: "condicion", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    if (all.condicion == "0") {
                        return "--";
                    } else {
                        return all.condicion;
                    }
                },
            },
            { data: "cupos", className: "text-center", sortable: false },
            {
                data: "silabo", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.silabo == null) {
                        return "--";
                    } else if (all.silabo == "--") {
                        return `<div class="d-flex justify-content-center"> -- </div>`;
                        return all.silabo;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verSilabo/${all.idsubject}" class="btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Documento">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            {
                data: "instrumentos_evaluacion", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.instrumentos_evaluacion == null) {
                        return "--";
                    } else if (all.instrumentos_evaluacion == "--") {
                        return `
                        <div class="d-flex justify-content-center">
                            ${all.instrumentos_evaluacion}
                        </div>
                        `;
                    } else {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="/verInstrumentosEvaluacion/${all.idsubject}" class="btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Documento">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `;
                    }
                },
            },
            {
                data: "apenom", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.apellido_pa == null && all.apellido_ma == null) {
                        return (
                            `
                                <div class="d-flex justify-content-center">` +
                            `<span class="me-3">Sin docente</span>
                                    <a href="javascript:void(0);" class="modalAssign btn btn-info shadow btn-xs sharp me-1"
                                    data-idsubject="${all.idsubject}"
                                    data-nomcurso="${all.nomcurso}"
                                    data-bs-placement="top"
                                    title="Buscar docente">
                                    <i class="fas fa-search"></i>
                                    </a>
                                </div>
                            `
                        );
                    } else {
                        return (
                            `
                        <div class="d-flex justify-content-center">` +
                            `<span class="me-3">` +
                            all.apellido_pa +
                            " " +
                            all.apellido_ma +
                            `</span>
                        <a href="javascript:void(0);" class="modalAssign btn btn-warning shadow btn-xs sharp me-1"
                        data-idsubject="${all.idsubject}"
                        data-nomcurso="${all.nomcurso}"
                        data-bs-placement="top"
                        title="Cambiar docente">
                        <i class="fas fa-user-gear"></i>
                    </a>
                    <a href="javascript:void(0);" class="modalUnassign btn btn-danger shadow btn-xs sharp me-1"
                        data-idsubject="${all.idsubject}"
                        data-bs-placement="top"
                        title="Quitar docente">
                        <i class="fas fa-user-slash"></i>
                    </a>
                        </div>
                    `
                        );
                    }
                },
            },
            // En la columna de "Acciones", dentro del render function, agregamos el botón de análisis
            {
                data: "idsubject",
                className: "text-center noExport",
                sortable: false,
                searchable: false,
                render: function (data, type, all, meta) {
                    let newseccion;
                    if (all.seccion == "A") {
                        newseccion = "B";
                        if (all.exist_sec_b == "1") {
                            return `
                <div class="d-flex justify-content-center">

                    <a href="javascript:void(0);" class="modalUpdate btn btn-warning shadow btn-xs sharp me-1"
                    data-idsubject="${all.idsubject}"
                    data-nomcurso="${all.nomcurso}"
                    data-seccion="${all.seccion}"
                    data-turno="${all.turno}"
                    data-condicion="${all.condicion}"
                    data-nota_minima="${all.nota_minima}"
                    data-bs-placement="top"
                    title="Editar sección">
                    <i class="fas fa-pencil-alt"></i>
                    </a>

                    <a href="javascript:void(0);" class="modalDestroy btn btn-danger shadow btn-xs sharp me-1"
                    data-idsubject="${all.idsubject}"
                    data-bs-placement="top"
                    title="Eliminar sección">
                    <i class="fas fa-trash"></i>
                    </a>

                    <!-- NUEVO BOTÓN DE ANÁLISIS -->
                    <a href="javascript:void(0);" class="btn-analisis btn btn-info shadow btn-xs sharp"
                    data-idsubject="${all.idsubject}"
                    data-nomcurso="${all.nomcurso}"
                    data-seccion="${all.seccion}"
                    data-bs-placement="top"
                    title="Análisis de Rendimiento">
                    <i class="fas fa-chart-bar"></i>
                    </a>

                </div>
                `;
                        }
                    } else if (all.seccion == "B") {
                        newseccion = "C";
                        if (all.exist_sec_c == "1") {
                            return `
                <div class="d-flex justify-content-center">

                    <a href="javascript:void(0);" class="modalUpdate btn btn-warning shadow btn-xs sharp me-1"
                    data-idsubject="${all.idsubject}"
                    data-nomcurso="${all.nomcurso}"
                    data-seccion="${all.seccion}"
                    data-turno="${all.turno}"
                    data-condicion="${all.condicion}"
                    data-nota_minima="${all.nota_minima}"
                    data-bs-placement="top"
                    title="Editar sección">
                    <i class="fas fa-pencil-alt"></i>
                    </a>

                    <a href="javascript:void(0);" class="modalDestroy btn btn-danger shadow btn-xs sharp me-1"
                    data-idsubject="${all.idsubject}"
                    data-bs-placement="top"
                    title="Eliminar sección">
                    <i class="fas fa-trash"></i>
                    </a>

                    <!-- NUEVO BOTÓN DE ANÁLISIS -->
                    <a href="javascript:void(0);" class="btn-analisis btn btn-info shadow btn-xs sharp"
                    data-idsubject="${all.idsubject}"
                    data-nomcurso="${all.nomcurso}"
                    data-seccion="${all.seccion}"
                    data-bs-placement="top"
                    title="Análisis de Rendimiento">
                    <i class="fas fa-chart-bar"></i>
                    </a>

                </div>
                `;
                        }
                    } else if (all.seccion == "C") {
                        return `
                <div class="d-flex justify-content-center">

                    <a href="javascript:void(0);" class="modalUpdate btn btn-warning shadow btn-xs sharp me-1"
                    data-idsubject="${all.idsubject}"
                    data-nomcurso="${all.nomcurso}"
                    data-seccion="${all.seccion}"
                    data-turno="${all.turno}"
                    data-condicion="${all.condicion}"
                    data-nota_minima="${all.nota_minima}"
                    data-bs-placement="top"
                    title="Editar sección">
                    <i class="fas fa-pencil-alt"></i>
                    </a>

                    <a href="javascript:void(0);" class="modalDestroy btn btn-danger shadow btn-xs sharp me-1"
                    data-idsubject="${all.idsubject}"
                    data-bs-placement="top"
                    title="Eliminar sección">
                    <i class="fas fa-trash"></i>
                    </a>

                    <!-- NUEVO BOTÓN DE ANÁLISIS -->
                    <a href="javascript:void(0);" class="btn-analisis btn btn-info shadow btn-xs sharp"
                    data-idsubject="${all.idsubject}"
                    data-nomcurso="${all.nomcurso}"
                    data-seccion="${all.seccion}"
                    data-bs-placement="top"
                    title="Análisis de Rendimiento">
                    <i class="fas fa-chart-bar"></i>
                    </a>

                </div>
                `;
                    }
                    return `
                <div class="d-flex justify-content-center">

                    <a href="javascript:void(0);" class="modalStore btn btn-success shadow btn-xs sharp me-1"
                    data-idsubject="${all.idsubject}"
                    data-newseccion="${newseccion}"
                    data-idcourse="${all.idcourse}"
                    data-bs-placement="top"
                    title="Añadir sección: ${newseccion}">
                    <i class="fas fa-solid fa-plus"></i>
                    </a>

                    <a href="javascript:void(0);" class="modalUpdate btn btn-warning shadow btn-xs sharp me-1"
                    data-idsubject="${all.idsubject}"
                    data-nomcurso="${all.nomcurso}"
                    data-seccion="${all.seccion}"
                    data-turno="${all.turno}"
                    data-condicion="${all.condicion}"
                    data-cupos="${all.cupos}"
                    data-nota_minima="${all.nota_minima}"
                    data-bs-placement="top"
                    title="Editar sección">
                    <i class="fas fa-pencil-alt"></i>
                    </a>

                    <a href="javascript:void(0);" class="modalDestroy btn btn-danger shadow btn-xs sharp me-1"
                    data-idsubject="${all.idsubject}"
                    data-bs-placement="top"
                    title="Eliminar sección">
                    <i class="fas fa-trash"></i>
                    </a>

                    <!-- NUEVO BOTÓN DE ANÁLISIS -->
                    <a href="javascript:void(0);" class="btn-analisis btn btn-info shadow btn-xs sharp"
                    data-idsubject="${all.idsubject}"
                    data-nomcurso="${all.nomcurso}"
                    data-seccion="${all.seccion}"
                    data-bs-placement="top"
                    title="Análisis de Rendimiento">
                    <i class="fas fa-chart-bar"></i>
                    </a>

                </div>
                `;
                }
            },
        ],
    });

    var selectedOption;

    // on change semesters
    $(document).on("click", ".btnSemester", function () {
        dt_idsemester = $(this).attr("data-idsemester");
        $(".divsemester").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        notificaciontoast(
            "info",
            "Consultando a la  base de datos!",
            "Mensaje!"
        );
        tl_periods(dt_idsemester, dt_idplan);
        table.ajax.reload();
    });

    // on change programas
    $(document).on("click", ".btnProgram", function () {
        let idprogram = $(this).attr("data-idprogram");
        $(".divprogram").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        document.getElementById("tlplan").innerHTML = "";
        document.getElementById("tlperiod").innerHTML = "";
        tl_plans(idprogram);
        // limpiar tabla
        dt_idperiod = "0";
        table.ajax.reload();
    });

    // on change planes
    $(document).on("click", ".btnPlan", function () {
        dt_idplan = $(this).attr("data-idplan");
        $(".divplan").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        tl_periods(dt_idsemester, dt_idplan);
        // limpiar tabla
        dt_idperiod = "0";
        table.ajax.reload();
    });

    // on change periodos
    $(document).on("click", ".btnPeriod", function () {
        dt_idperiod = $(this).attr("data-idperiod");
        $(".divperiod").removeClass("dark").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("dark");
        //info Toast
        notificaciontoast(
            "info",
            "Consultando a la  base de datos!",
            "Mensaje!"
        );
        table.ajax.reload();
    });

    // INICIO - MODAL
    $("#datatableGeneral tbody").on("click", ".modalAssign", function (e) {
        cb_teachers();
        // borrar validaciones
        formCheck = $("#formModal2")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
        // limpiar data docente
        $("#txt-idteacher").val("");
        $("#dt-doc-coddocente").html("--");
        $("#dt-doc-apenom").html("--");
        $("#dt-doc-contacto").html("--");
        $("#dt-doc-tipocontrato").html("--");
        $("#dt-doc-horas_lectivas").html("--");
        // setear data asignatura
        $("#txt-idsubject").val($(this).data("idsubject"));
        let nomcurso = $(this).data("nomcurso");
        $("#dt-sub-nombre").html(nomcurso);
        // modal
        $("#modalBuscarDocente").modal("show");
    });
    // FIN - MODAL

    // on change teachers
    $("#txt-teachers").on("change", function () {
        // setear idteacher
        let idteacher = $(this).val();
        $("#txt-idteacher").val(idteacher);
        // insertar info en card
        selectedOption = $(this).find("option:selected");
        let apenom =
            selectedOption.data("apellido_pa") +
            " " +
            selectedOption.data("apellido_ma") +
            ", " +
            selectedOption.data("nombres");
        $("#dt-doc-coddocente").html(selectedOption.data("nroidenti"));
        $("#dt-doc-apenom").html(apenom);
        $("#dt-doc-contacto").html(selectedOption.data("celular"));
        $("#dt-doc-tipocontrato").html(selectedOption.data("tipocontrato"));
        $("#dt-doc-horas_lectivas").html(selectedOption.data("horas_lectivas"));
    });

    // ASIGNAR DOCENTE Y ASIGNATURA
    $("#btnAssign").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal2")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            $(formCheck).addClass("was-validated"); // añadir validaciones
        } else {
            let idsubject = $("#txt-idsubject").val();
            assign_docente(idsubject);
        }
    });

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".modalUnassign", function (e) {
        // obtener idsubject seleccionado
        let idsubject = $(this).data("idsubject");
        // setear data idteacher
        $("#txt-idteacher").val("");
        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a quitar al docente de la asignatura",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                assign_docente(idsubject);
            } else {
                console.log("Cancelado");
            }
        });
    });
    // FIN - MODAL ELIMINAR

    // FN ASIGNAR DOCENTE
    function assign_docente(idsubject) {
        formModal = $("#formModal2");
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "PUT",
            url: "/admin/cursos/asignaturas/update_teacher/" + idsubject,
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalBuscarDocente").modal("hide");
                    }, 500); // ocultar despues de 1/2 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".modalUpdate", function (e) {
        // borrar validaciones
        formCheck = $("#formModal3")[0];
        $(formCheck).removeClass("was-validated"); // remover validaciones
        // // setear data asignatura
        $("#txt-idsubject").val($(this).data("idsubject"));
        $("#txt-nomcurso").val($(this).data("nomcurso"));
        $("#txt-seccion").selectpicker("val", $(this).data("seccion"));
        $("#txt-turno").selectpicker("val", $(this).data("turno"));
        $("#txt-cupos").val($(this).data("cupos"));
        $("#txt-sub_tipo").selectpicker("val", $(this).data("condicion"));
        $("#txt-nota_minima").val($(this).data("nota_minima"));
        $("#txt-silabo").val("");
        $("#txt-instrumentos_evaluacion").val("");
        // modal
        $("#modalUpdate").modal("show");
    });
    // FIN - MODAL UPDATE

    // ASIGNAR DOCENTE Y ASIGNATURA
    $("#btnUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal3")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            let idsubject = $("#txt-idsubject").val();
            update(idsubject);
        }
        $(formCheck).addClass("was-validated"); // añadir validaciones
    });

    // FN ASIGNAR DOCENTE
    function update(idsubject) {
        formData = new FormData(document.getElementById("formModal3"));
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/admin/cursos/asignaturas/update/" + idsubject,
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalUpdate").modal("hide");
                    }, 500); // ocultar despues de 1/2 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - MODAL CREAR NUEVA SECCION
    $("#datatableGeneral tbody").on("click", ".modalStore", function (e) {
        let newseccion = $(this).data("newseccion");
        let idcourse = $(this).data("idcourse");
        console.log("newseccion: " + $(this).data("newseccion"));
        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a crear una nueva sección de la asignatura",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // setear datos
                $("#txt-newseccion").val(newseccion);
                $("#txt-idsemester").val(dt_idsemester);
                $("#txt-idcourse").val(idcourse);
                store();
            } else {
                console.log("Cancelado");
            }
        });
    });
    // FIN - MODAL CREAR NUEVA SECCION
    // INICIO - MODAL ANALISIS RENDIMIENTO
    $("#datatableGeneral tbody").on("click", ".btn-analisis", function (e) {
        e.preventDefault();
        e.stopPropagation();

        let idsubject = $(this).data("idsubject");
        let nomcurso = $(this).data("nomcurso");
        let seccion = $(this).data("seccion");

        if (!idsubject) {
            notificaciontoast("error", "Error: No se pudo identificar el curso", "Error");
            return;
        }

        limpiarModalAnalisis();

        $("#cursoNombreModal").text(nomcurso + " - Sección " + seccion);

        // Placeholders
        $("#tablaEstudiantes tbody").html('<tr><td colspan="4" class="text-center">Cargando estudiantes...</td></tr>');
        $("#tablaRiesgo tbody").html('<tr><td colspan="6" class="text-center">Cargando estudiantes en riesgo...</td></tr>');

        $("#modalAnalisisRendimiento").modal("show");

        setTimeout(function () {
            cargarAnalisisRendimiento(idsubject);
        }, 300);
    });
    // FIN - MODAL ANALISIS RENDIMIENTO

    // Limpiar modal
    function limpiarModalAnalisis() {
        $("#tablaEstudiantes tbody").empty();
        $("#tablaRiesgo tbody").empty();
        $("#cursoNombreModal").text("");

        // Reset métricas
        $("#metricTotal").text("0");
        $("#metricPromedio").text("0.00");
        $("#metricAprobacion").text("0%");
        $("#metricNotaMinima").text("0");

        // Reset gráficos
        if (window.distribucionChart) {
            window.distribucionChart.destroy();
            window.distribucionChart = null;
        }
        if (window.estadoChart) {
            window.estadoChart.destroy();
            window.estadoChart = null;
        }
    }

    // Cargar análisis
    function cargarAnalisisRendimiento(idsubject) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr('content') },
            type: "GET",
            url: "/admin/cursos/asignaturas/analisis-rendimiento/" + idsubject,
            dataType: "json",
            success: function (data) {
                if (data.status == true) {
                    actualizarMetricas(data.metricas);
                    actualizarTablaEstudiantes(data.estudiantes);
                    actualizarEstudiantesRiesgo(data.estudiantesRiesgo);
                    actualizarTablaIndicadores(data.metricas_indicadores, data.estructura_evaluacion);

                    setTimeout(function () {
                        generarGraficos(data.graficos);
                    }, 100);
                } else {
                    notificaciontoast("error", data.mensaje || "Error en la respuesta", "Error!");
                }
            },
            error: function (xhr, status, error) {
                notificaciontoast("error", "Error de conexión: " + error, "Error!");
            }
        });
    }

    // Actualizar métricas
    function actualizarMetricas(metricas) {
        $("#metricTotal").text(metricas.total_estudiantes || 0);
        $("#metricPromedio").text((metricas.promedio || 0).toFixed(2));
        $("#metricAprobacion").text((metricas.porcentaje_aprobacion || 0) + '%');
        $("#metricNotaMinima").text(metricas.nota_minima || 0);
    }

    // Tabla general de estudiantes
    function actualizarTablaEstudiantes(estudiantes) {
        let tbody = $("#tablaEstudiantes tbody");
        tbody.empty();

        if (!estudiantes || estudiantes.length === 0) {
            tbody.html('<tr><td colspan="4" class="text-center text-muted">No hay estudiantes matriculados</td></tr>');
            return;
        }

        estudiantes.forEach(est => {
            let nota = est.nota !== null && est.nota !== undefined ? est.nota : 'N/A';
            let estadoClass = est.estado === 'Aprobado' ? 'bg-success' :
                est.estado === 'Reprobado' ? 'bg-danger' : 'bg-warning';

            let fila = `<tr>
            <td>${est.estudiante || 'N/A'}</td>
            <td>${est.codigo || 'N/A'}</td>
            <td><strong>${nota}</strong></td>
            <td><span class="badge ${estadoClass}">${est.estado || 'Sin definir'}</span></td>
        </tr>`;
            tbody.append(fila);
        });
    }

    // Tabla de estudiantes en riesgo
    function actualizarEstudiantesRiesgo(estudiantesRiesgo) {
        let tbody = $("#tablaRiesgo tbody");
        tbody.empty();

        if (!estudiantesRiesgo || estudiantesRiesgo.length === 0) {
            tbody.html('<tr><td colspan="6" class="text-center text-success">No hay estudiantes en riesgo</td></tr>');
            return;
        }

        estudiantesRiesgo.forEach(est => {
            let nota = est.nota !== null && est.nota !== undefined ? est.nota : 'N/A';
            let fila = `<tr>
            <td>${est.estudiante || 'N/A'}</td>
            <td>${est.codigo || 'N/A'}</td>
            <td><strong class="text-danger">${nota}</strong></td>
            <td>${est.evaluaciones_bajas || 0}</td>
            <td>${est.asistencias_bajas || 0}</td>
            <td>
                <button class="btn btn-sm btn-outline-warning" title="Enviar alerta">
                    <i class="fas fa-bell"></i>
                </button>
            </td>
        </tr>`;
            tbody.append(fila);
        });
    }

    // Función corregida para generar gráficos
    function generarGraficos(graficos) {
        // Verificar si Chart.js está disponible
        if (typeof Chart === 'undefined') {
            console.error('Chart.js no está cargado');
            notificaciontoast("warning", "La librería de gráficos no está disponible", "Advertencia");
            return;
        }

        try {
            // Destruir gráficos anteriores si existen
            if (window.distribucionChart) {
                window.distribucionChart.destroy();
            }
            if (window.estadoChart) {
                window.estadoChart.destroy();
            }

            // Gráfico de distribución de notas - MEJORADO
            const ctxDistribucion = document.getElementById('graficoDistribucion');
            if (ctxDistribucion) {
                // Configurar dimensiones del canvas
                ctxDistribucion.style.maxHeight = '300px';
                ctxDistribucion.style.width = '100%';

                window.distribucionChart = new Chart(ctxDistribucion, {
                    type: 'bar',
                    data: {
                        labels: graficos.distribucion.labels || ['0-10', '11-13', '14-16', '17-20'],
                        datasets: [{
                            label: 'Cantidad de Estudiantes',
                            data: graficos.distribucion.data || [0, 0, 0, 0],
                            backgroundColor: [
                                '#ff6384', // rojo para 0-10
                                '#ff9f40', // naranja para 11-13
                                '#ffcd56', // amarillo para 14-16
                                '#4bc0c0'  // verde para 17-20
                            ],
                            borderColor: [
                                '#ff6384',
                                '#ff9f40',
                                '#ffcd56',
                                '#4bc0c0'
                            ],
                            borderWidth: 1
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: true,
                        aspectRatio: 1.5, // Proporción más adecuada para barras
                        plugins: {
                            title: {
                                display: true,
                                text: 'Distribución de Notas',
                                font: {
                                    size: 14
                                }
                            },
                            legend: {
                                display: false // Ocultar leyenda ya que solo hay un dataset
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    stepSize: 1,
                                    font: {
                                        size: 11
                                    }
                                },
                                title: {
                                    display: true,
                                    text: 'Cantidad de Estudiantes',
                                    font: {
                                        size: 12
                                    }
                                }
                            },
                            x: {
                                ticks: {
                                    font: {
                                        size: 11
                                    }
                                },
                                title: {
                                    display: true,
                                    text: 'Rango de Notas',
                                    font: {
                                        size: 12
                                    }
                                }
                            }
                        }
                    }
                });
            }

            // Gráfico de estado académico - CORREGIDO (más pequeño)
            const ctxEstado = document.getElementById('graficoEstado');
            if (ctxEstado) {
                // Configurar dimensiones más pequeñas para el pie chart
                ctxEstado.style.maxHeight = '250px';
                ctxEstado.style.width = '100%';

                window.estadoChart = new Chart(ctxEstado, {
                    type: 'doughnut', // Cambiado a doughnut que es más compacto
                    data: {
                        labels: graficos.estado.labels || ['Aprobados', 'Reprobados', 'En proceso'],
                        datasets: [{
                            data: graficos.estado.data || [0, 0, 0],
                            backgroundColor: [
                                '#4bc0c0', // verde para aprobados
                                '#ff6384', // rojo para reprobados
                                '#ffcd56'  // amarillo para en proceso
                            ],
                            borderColor: '#ffffff',
                            borderWidth: 2,
                            hoverOffset: 8
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: true,
                        aspectRatio: 1.8, // Proporción más alargada para doughnut
                        cutout: '50%', // Tamaño del agujero central (para doughnut)
                        plugins: {
                            title: {
                                display: true,
                                text: 'Estado Académico',
                                font: {
                                    size: 14
                                }
                            },
                            legend: {
                                position: 'bottom',
                                labels: {
                                    boxWidth: 12,
                                    font: {
                                        size: 11
                                    },
                                    padding: 15
                                }
                            },
                            tooltip: {
                                callbacks: {
                                    label: function (context) {
                                        const label = context.label || '';
                                        const value = context.raw || 0;
                                        const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                        const percentage = Math.round((value / total) * 100);
                                        return `${label}: ${value} (${percentage}%)`;
                                    }
                                }
                            }
                        }
                    }
                });
            }

            // Forzar redimensionamiento de los gráficos
            setTimeout(() => {
                if (window.distribucionChart) {
                    window.distribucionChart.resize();
                }
                if (window.estadoChart) {
                    window.estadoChart.resize();
                }
            }, 100);

        } catch (error) {
            console.error('Error generando gráficos:', error);
            notificaciontoast("error", "Error al generar los gráficos", "Error!");
        }
    }

    // Función para actualizar la pestaña de indicadores
    function actualizarTablaIndicadores(metricasIndicadores, estructuraEvaluacion) {
        let tbody = $("#tablaIndicadores tbody");
        tbody.empty();

        if (!metricasIndicadores || metricasIndicadores.length === 0) {
            tbody.html('<tr><td colspan="5" class="text-center text-muted">No hay indicadores configurados</td></tr>');
            return;
        }

        metricasIndicadores.forEach(indicador => {
            let estadoClass = indicador.promedio_indicador >= 11 ? 'bg-success' : 'bg-warning';
            let estadoText = indicador.promedio_indicador >= 11 ? 'Bueno' : 'Necesita mejora';

            let fila = `<tr class="indicador-row" data-indicador-id="${indicador.indicador_id}">
            <td><strong>${indicador.indicador_nombre}</strong></td>
            <td>${indicador.total_actividades}</td>
            <td>${indicador.total_porcentaje}%</td>
            <td><strong>${indicador.promedio_indicador}</strong></td>
            <td><span class="badge ${estadoClass}">${estadoText}</span></td>
        </tr>`;
            tbody.append(fila);
        });

        // Evento para mostrar detalle de actividades
        $(".indicador-row").on("click", function () {
            let indicadorId = $(this).data('indicador-id');
            mostrarDetalleActividades(indicadorId, estructuraEvaluacion);
        });
    }

    // Función para mostrar detalle de actividades
    function mostrarDetalleActividades(indicadorId, estructuraEvaluacion) {
        let actividades = estructuraEvaluacion[indicadorId];
        let tbody = $("#tablaActividades tbody");
        tbody.empty();

        if (!actividades) {
            tbody.html('<tr><td colspan="3" class="text-center text-muted">No hay actividades para este indicador</td></tr>');
            return;
        }

        Object.keys(actividades).forEach(actividadId => {
            let evaluaciones = actividades[actividadId];
            evaluaciones.forEach(evaluacion => {
                let fila = `<tr>
                <td>${evaluacion.actividad_nombre}</td>
                <td>${evaluacion.evaluacion_nombre}</td>
                <td>${evaluacion.porcentaje}%</td>
            </tr>`;
                tbody.append(fila);
            });
        });

        $("#detalleActividades").show();
    }

    // Evento para limpiar el modal cuando se cierre
    $('#modalAnalisisRendimiento').on('hidden.bs.modal', function () {
        limpiarModalAnalisis();
    });

    function mostrarLoadingAnalisis() {
        // Puedes implementar un loading spinner aquí
        $("#modalAnalisisRendimiento .modal-body").append('<div class="loading-spinner">Cargando...</div>');
    }

    function ocultarLoadingAnalisis() {
        $(".loading-spinner").remove();
    }

    function store() {
        formModal = $("#formModal");
        $.ajax({
            type: "POST",
            url: "/admin/cursos/asignaturas/store",
            data: formModal.serialize(),
            dataType: "json",
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated"); // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () {
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".modalDestroy", function (e) {
        let idsubject = $(this).data("idsubject");
        // confirmacion
        confirmation_sweetAlert(
            "Deseas continuar?",
            "Se procederá a eliminar el registro de la base de datos",
            "warning"
        ).then(function (isConfirm) {
            if (isConfirm.value) {
                // enviando el parametro de la data que se procede a delete
                destroy(idsubject);
            } else {
                console.log("Cancelado");
            }
        });
    });
    // FIN - MODAL DELETE

    function destroy(idsubject) {
        $.ajax({
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "DELETE",
            url: "/admin/cursos/asignaturas/destroy/" + idsubject,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }
});
