'use strict';
import { notificaciontoast } from "../../common/method_toast.js";
import Chart from "chart.js/auto";

$(document).ready(function () {

    var programa = 0;
    let chart1, chart2, chart3;

    $(document).on("change", "#txt-programs", function () {
        programa = $(this).val();
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        actualizarGrafico1();
        actualizarGrafico2();
        actualizarGrafico3();
    });

    function actualizarGrafico1() {
        console.log("grafico 1");
        $.ajax({
            url: '/admin/planes_estudio/evaluacion/grafica_1/' + programa,
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                function getRandomColor() {
                    const r = Math.floor(Math.random() * 17) * 15;
                    const g = Math.floor(Math.random() * 17) * 15;
                    const b = Math.floor(Math.random() * 17) * 15;
                    return `rgba(${r}, ${g}, ${b}, 0.6)`;  // backticks
                }

                const backgroundColors = data.map(() => getRandomColor());
                const labels = data.map(item => item.nombre);
                const values = data.map(item => item.total_estudiantes);

                const ctx = document.getElementById('grafico-1').getContext('2d');
                if (chart1) chart1.destroy();

                chart1 = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: labels,
                        datasets: [{
                            data: values,
                            backgroundColor: backgroundColors,
                            borderColor: backgroundColors,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        indexAxis: 'y',
                        responsive: true,
                        scales: {
                            x: {
                                beginAtZero: true
                            }
                        },
                        plugins: {
                            tooltip: {
                                callbacks: {
                                    label: function (context) {
                                        return context.parsed.x.toLocaleString('es-PE');
                                    }
                                }
                            },
                            legend: {
                                display: false
                            },
                            title: {
                                display: false
                            }
                        }
                    },
                })
            }
        })
    }

    function actualizarGrafico2() {
        console.log("grafico 2");
        $.ajax({
            url: '/admin/planes_estudio/evaluacion/grafica_2/' + programa,
            type: 'GET',
            dataType: 'json',
            success: function (data) {

                function getRandomColor() {
                    const r = Math.floor(Math.random() * 17) * 15;
                    const g = Math.floor(Math.random() * 17) * 15;
                    const b = Math.floor(Math.random() * 17) * 15;
                    return `rgba(${r}, ${g}, ${b}, 0.6)`;   // backticks
                }

                const backgroundColors = data.map(() => getRandomColor());
                const labels = data.map(item => item.nombre);            // nombre del plan
                const values = data.map(item => item.total_egresados);   // total de egresados

                const ctx = document.getElementById('grafico-2').getContext('2d'); // usa grafico-2
                if (chart2) chart2.destroy();

                chart2 = new Chart(ctx, {
                    type: 'pie',   // 👈 gráfico de pie
                    data: {
                        labels: labels,
                        datasets: [{
                            label: 'Egresados por plan',
                            data: values,
                            backgroundColor: backgroundColors,
                            borderColor: backgroundColors,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            tooltip: {
                                callbacks: {
                                    label: function (context) {
                                        const label = context.label || '';
                                        const value = context.parsed || 0;
                                        return `${label}: ${value} egresados`;
                                    }
                                }
                            },
                            legend: {
                                display: true,
                                position: 'top'
                            },
                            title: {
                                display: false
                            }
                        }
                    },
                });
            }
        });
    }

    function actualizarGrafico3() {
        console.log("grafico 3");
        $.ajax({
            url: '/admin/planes_estudio/evaluacion/grafica_3/' + programa,
            type: 'GET',
            dataType: 'json',
            success: function (data) {

                const labels = data.map(item => item.semestre);               // "2025-1", "2025-2", ...
                const values = data.map(item => item.total_matriculados);    // 10, 14, ...

                const ctx = document.getElementById('grafico-3').getContext('2d');
                if (chart3) chart3.destroy();

                chart3 = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: labels,
                        datasets: [{
                            label: 'Estudiantes matriculados',
                            data: values,
                            fill: false,
                            backgroundColor: 'rgba(99, 132, 255, 0.6)',
                            borderColor: 'rgba(99, 132, 255, 1)',
                            borderWidth: 2,
                            tension: 0.3,
                            pointRadius: 4,
                            pointHoverRadius: 6
                        }]
                    },
                    options: {
                        responsive: true,
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    precision: 0   // solo enteros
                                }
                            }
                        },
                        plugins: {
                            tooltip: {
                                callbacks: {
                                    label: function (context) {
                                        const label = context.label || '';
                                        const value = context.parsed.y ?? context.parsed ?? 0;
                                        return `${label}: ${value} estudiantes`;
                                    }
                                }
                            },
                            legend: {
                                display: true,
                                position: 'top'
                            },
                            title: {
                                display: false
                            }
                        }
                    }
                });
            }
        });
    }
})